/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigtableColumn;
import com.google.cloud.bigquery.BigtableColumnFamily;
import com.google.cloud.bigquery.BigtableOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BigtableOptionsTest {
    private static final BigtableColumn COL1 = BigtableColumn.newBuilder().setQualifierEncoded("aaa").setFieldName("field1").setOnlyReadLatest(Boolean.valueOf(true)).setEncoding("BINARY").setType("BYTES").build();
    private static final BigtableColumn COL2 = BigtableColumn.newBuilder().setQualifierEncoded("bbb").setFieldName("field2").setOnlyReadLatest(Boolean.valueOf(true)).setEncoding("TEXT").setType("STRING").build();
    private static final BigtableColumnFamily TESTFAMILY = BigtableColumnFamily.newBuilder().setFamilyID("fooFamily").setEncoding("TEXT").setOnlyReadLatest(Boolean.valueOf(true)).setType("INTEGER").setColumns((List)ImmutableList.of((Object)COL1, (Object)COL2)).build();
    private static final BigtableOptions OPTIONS = BigtableOptions.newBuilder().setIgnoreUnspecifiedColumnFamilies(Boolean.valueOf(true)).setReadRowkeyAsString(Boolean.valueOf(true)).setColumnFamilies((List)ImmutableList.of((Object)TESTFAMILY)).build();

    @Test
    public void testConstructors() {
        Truth.assertThat((String)COL1.getQualifierEncoded()).isEqualTo((Object)"aaa");
        Truth.assertThat((String)COL1.getFieldName()).isEqualTo((Object)"field1");
        Truth.assertThat((Boolean)COL1.getOnlyReadLatest()).isEqualTo((Object)true);
        Truth.assertThat((String)COL1.getEncoding()).isEqualTo((Object)"BINARY");
        Truth.assertThat((String)COL1.getType()).isEqualTo((Object)"BYTES");
        Truth.assertThat((Boolean)COL1.equals(COL1)).isTrue();
        Truth.assertThat((Object)COL1).isNotEqualTo((Object)TESTFAMILY);
        Truth.assertThat((String)TESTFAMILY.getFamilyID()).isEqualTo((Object)"fooFamily");
        Truth.assertThat((String)TESTFAMILY.getEncoding()).isEqualTo((Object)"TEXT");
        Truth.assertThat((Boolean)TESTFAMILY.getOnlyReadLatest()).isEqualTo((Object)true);
        Truth.assertThat((String)TESTFAMILY.getType()).isEqualTo((Object)"INTEGER");
        Truth.assertThat((Iterable)TESTFAMILY.getColumns()).isEqualTo((Object)ImmutableList.of((Object)COL1, (Object)COL2));
        Truth.assertThat((Boolean)OPTIONS.getIgnoreUnspecifiedColumnFamilies()).isEqualTo((Object)true);
        Truth.assertThat((Boolean)OPTIONS.getReadRowkeyAsString()).isEqualTo((Object)true);
        Truth.assertThat((Iterable)OPTIONS.getColumnFamilies()).isEqualTo((Object)ImmutableList.of((Object)TESTFAMILY));
        this.compareBigtableOptions(OPTIONS, OPTIONS.toBuilder().build());
    }

    @Test
    public void testNullPointerException() {
        try {
            BigtableColumnFamily.newBuilder().setFamilyID(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Truth.assertThat((String)ex.getMessage()).isNotNull();
        }
        try {
            BigtableColumnFamily.newBuilder().setColumns(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Truth.assertThat((String)ex.getMessage()).isNotNull();
        }
        try {
            BigtableColumnFamily.newBuilder().setEncoding(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Truth.assertThat((String)ex.getMessage()).isNotNull();
        }
        try {
            BigtableColumnFamily.newBuilder().setOnlyReadLatest(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Truth.assertThat((String)ex.getMessage()).isNotNull();
        }
        try {
            BigtableColumnFamily.newBuilder().setType(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Truth.assertThat((String)ex.getMessage()).isNotNull();
        }
    }

    @Test
    public void testIllegalStateException() {
        try {
            BigtableColumnFamily.newBuilder().build();
        }
        catch (IllegalStateException ex) {
            Truth.assertThat((String)ex.getMessage()).isNotNull();
        }
    }

    @Test
    public void testToAndFromPb() {
        this.compareBigtableColumn(COL1, BigtableColumn.fromPb((com.google.api.services.bigquery.model.BigtableColumn)COL1.toPb()));
        this.compareBigtableColumnFamily(TESTFAMILY, BigtableColumnFamily.fromPb((com.google.api.services.bigquery.model.BigtableColumnFamily)TESTFAMILY.toPb()));
        this.compareBigtableOptions(OPTIONS, BigtableOptions.fromPb((com.google.api.services.bigquery.model.BigtableOptions)OPTIONS.toPb()));
    }

    @Test
    public void testEquals() {
        this.compareBigtableColumn(COL1, COL1);
        this.compareBigtableColumnFamily(TESTFAMILY, TESTFAMILY);
        Truth.assertThat((Boolean)TESTFAMILY.equals(TESTFAMILY)).isTrue();
        Truth.assertThat((Object)TESTFAMILY).isNotEqualTo((Object)COL1);
        Truth.assertThat((Boolean)OPTIONS.equals((Object)OPTIONS)).isTrue();
        Truth.assertThat((Object)OPTIONS).isNotEqualTo((Object)TESTFAMILY);
        this.compareBigtableOptions(OPTIONS, OPTIONS);
    }

    private void compareBigtableColumn(BigtableColumn expected, BigtableColumn value) {
        Truth.assertThat((Object)expected).isEqualTo((Object)value);
        Truth.assertThat((String)expected.getEncoding()).isEqualTo((Object)value.getEncoding());
        Truth.assertThat((String)expected.getFieldName()).isEqualTo((Object)value.getFieldName());
        Truth.assertThat((String)expected.getQualifierEncoded()).isEqualTo((Object)value.getQualifierEncoded());
        Truth.assertThat((Boolean)expected.getOnlyReadLatest()).isEqualTo((Object)value.getOnlyReadLatest());
        Truth.assertThat((String)expected.getType()).isEqualTo((Object)value.getType());
        Truth.assertThat((String)expected.toString()).isEqualTo((Object)value.toString());
        Truth.assertThat((Integer)expected.hashCode()).isEqualTo((Object)value.hashCode());
    }

    private void compareBigtableColumnFamily(BigtableColumnFamily expected, BigtableColumnFamily value) {
        Truth.assertThat((Object)expected).isEqualTo((Object)value);
        Truth.assertThat((String)expected.getFamilyID()).isEqualTo((Object)value.getFamilyID());
        Truth.assertThat((Boolean)expected.getOnlyReadLatest()).isEqualTo((Object)value.getOnlyReadLatest());
        Truth.assertThat((Iterable)expected.getColumns()).isEqualTo((Object)value.getColumns());
        Truth.assertThat((String)expected.getEncoding()).isEqualTo((Object)value.getEncoding());
        Truth.assertThat((String)expected.getType()).isEqualTo((Object)value.getType());
        Truth.assertThat((String)expected.toString()).isEqualTo((Object)value.toString());
        Truth.assertThat((Integer)expected.hashCode()).isEqualTo((Object)value.hashCode());
    }

    private void compareBigtableOptions(BigtableOptions expected, BigtableOptions value) {
        Truth.assertThat((Object)expected).isEqualTo((Object)value);
        Truth.assertThat((Boolean)expected.getIgnoreUnspecifiedColumnFamilies()).isEqualTo((Object)value.getIgnoreUnspecifiedColumnFamilies());
        Truth.assertThat((Boolean)expected.getReadRowkeyAsString()).isEqualTo((Object)value.getReadRowkeyAsString());
        Truth.assertThat((Iterable)expected.getColumnFamilies()).isEqualTo((Object)value.getColumnFamilies());
        Truth.assertThat((Integer)expected.hashCode()).isEqualTo((Object)value.hashCode());
        Truth.assertThat((String)expected.toString()).isEqualTo((Object)value.toString());
    }
}

