/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.CloneDefinition;
import com.google.cloud.bigquery.TableId;
import org.junit.Assert;
import org.junit.Test;

public class CloneDefinitionTest {
    private static final TableId BASE_TABLE_ID = TableId.of((String)"DATASET_NAME", (String)"BASE_TABLE_NAME");
    private static final String CLONE_TIME = "2021-05-19T11:32:26.553Z";
    private static final CloneDefinition CLONETABLE_DEFINITION = CloneDefinition.newBuilder().setBaseTableId(BASE_TABLE_ID).setCloneTime("2021-05-19T11:32:26.553Z").build();

    @Test
    public void testToBuilder() {
        this.compareCloneTableDefinition(CLONETABLE_DEFINITION, CLONETABLE_DEFINITION.toBuilder().build());
        CloneDefinition cloneTableDefinition = CLONETABLE_DEFINITION.toBuilder().setCloneTime("2021-05-20T11:32:26.553Z").build();
        Assert.assertEquals((Object)"2021-05-20T11:32:26.553Z", (Object)cloneTableDefinition.getCloneTime());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)BASE_TABLE_ID, (Object)CLONETABLE_DEFINITION.getBaseTableId());
        Assert.assertEquals((Object)CLONE_TIME, (Object)CLONETABLE_DEFINITION.getCloneTime());
        CloneDefinition cloneDefinition = CloneDefinition.newBuilder().setBaseTableId(BASE_TABLE_ID).setCloneTime(CLONE_TIME).build();
        Assert.assertEquals((Object)CLONETABLE_DEFINITION, (Object)cloneDefinition);
    }

    @Test
    public void testToAndFromPb() {
        CloneDefinition cloneDefinition = CLONETABLE_DEFINITION.toBuilder().build();
        Assert.assertTrue((boolean)(CloneDefinition.fromPb((com.google.api.services.bigquery.model.CloneDefinition)cloneDefinition.toPb()) instanceof CloneDefinition));
        this.compareCloneTableDefinition(cloneDefinition, CloneDefinition.fromPb((com.google.api.services.bigquery.model.CloneDefinition)cloneDefinition.toPb()));
    }

    private void compareCloneTableDefinition(CloneDefinition expected, CloneDefinition value) {
        Assert.assertEquals((Object)expected.getBaseTableId(), (Object)value.getBaseTableId());
        Assert.assertEquals((Object)expected.getCloneTime(), (Object)value.getCloneTime());
    }
}

