/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableConstraints;
import com.google.cloud.bigquery.ColumnReference;
import org.junit.Assert;
import org.junit.Test;

public class ColumnReferenceTest {
    private static final ColumnReference COLUMN_REFERENCE = ColumnReference.newBuilder().setReferencingColumn("column1").setReferencedColumn("column2").build();

    @Test
    public void testToBuilder() {
        this.compareColumnReferenceDefinition(COLUMN_REFERENCE, COLUMN_REFERENCE.toBuilder().build());
        ColumnReference columnReference = COLUMN_REFERENCE.toBuilder().setReferencingColumn("col1").setReferencedColumn("col2").build();
        Assert.assertEquals((Object)"col1", (Object)columnReference.getReferencingColumn());
        Assert.assertEquals((Object)"col2", (Object)columnReference.getReferencedColumn());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"column1", (Object)COLUMN_REFERENCE.getReferencingColumn());
        Assert.assertEquals((Object)"column2", (Object)COLUMN_REFERENCE.getReferencedColumn());
        ColumnReference columnReference = COLUMN_REFERENCE.newBuilder().setReferencingColumn("column1").setReferencedColumn("column2").build();
        Assert.assertEquals((Object)COLUMN_REFERENCE, (Object)columnReference);
    }

    @Test
    public void testToAndFromPb() {
        ColumnReference columnReference = COLUMN_REFERENCE.toBuilder().build();
        Assert.assertTrue((boolean)(ColumnReference.fromPb((TableConstraints.ForeignKeys.ColumnReferences)columnReference.toPb()) instanceof ColumnReference));
        this.compareColumnReferenceDefinition(columnReference, ColumnReference.fromPb((TableConstraints.ForeignKeys.ColumnReferences)columnReference.toPb()));
    }

    private void compareColumnReferenceDefinition(ColumnReference expected, ColumnReference value) {
        Assert.assertEquals((Object)expected.getReferencingColumn(), (Object)value.getReferencingColumn());
        Assert.assertEquals((Object)expected.getReferencedColumn(), (Object)value.getReferencedColumn());
    }
}

