/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics2;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryDryRunResult;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryResult;
import com.google.cloud.bigquery.BigQueryResultImpl;
import com.google.cloud.bigquery.BigQueryResultStats;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.Connection;
import com.google.cloud.bigquery.ConnectionImpl;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExecuteSelectResponse;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionImplTest {
    private BigQueryOptions options;
    private BigQueryRpcFactory rpcFactoryMock;
    private BigQueryRpc bigqueryRpcMock;
    private Connection connectionMock;
    private BigQuery bigquery;
    private ConnectionImpl connection;
    private static final String PROJECT = "project";
    private static final String JOB = "job";
    private static final String LOCATION = "US";
    private static final String DEFAULT_TEST_DATASET = "bigquery_test_dataset";
    private static final String PAGE_TOKEN = "ABCD123";
    private static final TableId TABLE_NAME = TableId.of((String)"bigquery_test_dataset", (String)"project");
    private static final TableCell STRING_CELL = new TableCell().setV((Object)"Value");
    private static final TableRow TABLE_ROW = new TableRow().setF((List)ImmutableList.of((Object)STRING_CELL));
    private static final String SQL_QUERY = "SELECT  county, state_name FROM bigquery_test_dataset.large_data_testing_table limit 2";
    private static final String DRY_RUN_SQL = "SELECT  county, state_name FROM bigquery_test_dataset.large_data_testing_table where country = ?";
    private static final int DEFAULT_PAGE_SIZE = 10000;
    private ConnectionSettings connectionSettings;
    private static final Schema QUERY_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"country", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"state_name", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final Schema QUERY_SCHEMA_WITH_INTERVAL_FIELD = Schema.of((Field[])new Field[]{Field.newBuilder((String)"interval", (StandardSQLTypeName)StandardSQLTypeName.INTERVAL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final TableSchema FAST_QUERY_TABLESCHEMA = QUERY_SCHEMA.toPb();
    private static final BigQueryResult BQ_RS_MOCK_RES = new BigQueryResultImpl(QUERY_SCHEMA, 2L, null, null);
    private static final BigQueryResult BQ_RS_MOCK_RES_MULTI_PAGE = new BigQueryResultImpl(QUERY_SCHEMA, 4L, null, null);
    private static final JobId QUERY_JOB = JobId.of((String)"project", (String)"job").setLocation("US");
    private static final GetQueryResultsResponse GET_QUERY_RESULTS_RESPONSE = new GetQueryResultsResponse().setJobReference(QUERY_JOB.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken("ABCD123").setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L)).setSchema(FAST_QUERY_TABLESCHEMA);
    private static final GetQueryResultsResponse GET_QUERY_RESULTS_RESPONSE_EMPTY = new GetQueryResultsResponse().setJobReference(QUERY_JOB.toPb()).setJobComplete(Boolean.valueOf(true)).setCacheHit(Boolean.valueOf(false)).setPageToken("ABCD123").setTotalBytesProcessed(Long.valueOf(0L)).setTotalRows(BigInteger.valueOf(0L)).setSchema(FAST_QUERY_TABLESCHEMA);
    private static final GetQueryResultsResponse GET_QUERY_RESULTS_RESPONSE_NULL_SCHEMA = new GetQueryResultsResponse().setJobReference(QUERY_JOB.toPb()).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setJobComplete(Boolean.valueOf(false)).setPageToken("ABCD123").setTotalBytesProcessed(Long.valueOf(42L)).setTotalRows(BigInteger.valueOf(1L)).setSchema(null);
    private static List<TableRow> TABLE_ROWS = ImmutableList.of((Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value1"), (Object)new TableCell().setV((Object)"Value2"))), (Object)new TableRow().setF((List)ImmutableList.of((Object)new TableCell().setV((Object)"Value3"), (Object)new TableCell().setV((Object)"Value4"))));

    private BigQueryOptions createBigQueryOptionsForProject(String project, BigQueryRpcFactory rpcFactory) {
        return ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(project)).setServiceRpcFactory((ServiceRpcFactory)rpcFactory)).setRetrySettings(ServiceOptions.getNoRetrySettings())).build();
    }

    @Before
    public void setUp() {
        this.rpcFactoryMock = (BigQueryRpcFactory)Mockito.mock(BigQueryRpcFactory.class);
        this.bigqueryRpcMock = (BigQueryRpc)Mockito.mock(BigQueryRpc.class);
        this.connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.rpcFactoryMock.create((ServiceOptions)((BigQueryOptions)ArgumentMatchers.any(BigQueryOptions.class)))).thenReturn((Object)this.bigqueryRpcMock);
        this.options = this.createBigQueryOptionsForProject(PROJECT, this.rpcFactoryMock);
        this.bigquery = (BigQuery)this.options.getService();
        this.connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DEFAULT_TEST_DATASET)).setNumBufferedRows(Integer.valueOf(10000)).build();
        this.bigquery = (BigQuery)((BigQueryOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        this.connection = (ConnectionImpl)this.bigquery.createConnection(this.connectionSettings);
        Assert.assertNotNull((Object)this.connection);
    }

    @Test
    public void testFastQuerySinglePage() throws BigQuerySQLException {
        QueryResponse mockQueryRes = new QueryResponse().setSchema(FAST_QUERY_TABLESCHEMA).setJobComplete(Boolean.valueOf(true));
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class))).thenReturn((Object)mockQueryRes);
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
    }

    @Test
    public void testFastQueryMultiplePages() throws BigQuerySQLException {
        QueryResponse mockQueryRes = new QueryResponse().setSchema(FAST_QUERY_TABLESCHEMA).setJobComplete(Boolean.valueOf(true)).setPageToken(PAGE_TOKEN);
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class))).thenReturn((Object)mockQueryRes);
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES_MULTI_PAGE).when((Object)connectionSpy)).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)4L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
    }

    @Test
    public void testClose() throws BigQuerySQLException {
        boolean cancelled = this.connection.close();
        Assert.assertTrue((boolean)cancelled);
    }

    @Test
    public void testQueryDryRun() throws BigQuerySQLException {
        ImmutableList queryParametersMock = ImmutableList.of((Object)new QueryParameter().setParameterType(new QueryParameterType().setType("STRING")));
        JobStatistics2 queryMock = new JobStatistics2().setSchema(FAST_QUERY_TABLESCHEMA).setUndeclaredQueryParameters((List)queryParametersMock);
        JobStatistics jobStatsMock = new JobStatistics().setCreationTime(Long.valueOf(1234L)).setStartTime(Long.valueOf(5678L)).setQuery(queryMock);
        JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery();
        JobConfiguration jobConfig = new JobConfiguration().setQuery(jobConfigurationQuery);
        Job mockDryRunJob = new Job().setStatistics(jobStatsMock).setConfiguration(jobConfig);
        Mockito.when((Object)this.bigqueryRpcMock.createJobForQuery((Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)mockDryRunJob);
        BigQueryDryRunResult dryRunResult = this.connection.dryRun(DRY_RUN_SQL);
        Assert.assertEquals((long)1L, (long)dryRunResult.getQueryParameters().size());
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)dryRunResult.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).createJobForQuery((Job)ArgumentMatchers.any(Job.class));
    }

    @Test
    public void testQueryDryRunNoQueryParameters() throws BigQuerySQLException {
        JobStatistics2 queryMock = new JobStatistics2().setSchema(FAST_QUERY_TABLESCHEMA);
        JobStatistics jobStatsMock = new JobStatistics().setCreationTime(Long.valueOf(1234L)).setStartTime(Long.valueOf(5678L)).setQuery(queryMock);
        JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery();
        JobConfiguration jobConfig = new JobConfiguration().setQuery(jobConfigurationQuery);
        Job mockDryRunJob = new Job().setStatistics(jobStatsMock).setConfiguration(jobConfig);
        Mockito.when((Object)this.bigqueryRpcMock.createJobForQuery((Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)mockDryRunJob);
        BigQueryDryRunResult dryRunResult = this.connection.dryRun(DRY_RUN_SQL);
        Assert.assertEquals((long)0L, (long)dryRunResult.getQueryParameters().size());
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)dryRunResult.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).createJobForQuery((Job)ArgumentMatchers.any(Job.class));
    }

    @Test
    public void testParseDataTask() throws InterruptedException {
        LinkedBlockingDeque pageCache = new LinkedBlockingDeque(2);
        LinkedBlockingDeque<Tuple> rpcResponseQueue = new LinkedBlockingDeque<Tuple>(2);
        rpcResponseQueue.offer(Tuple.of(null, (Object)false));
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        connectionSpy.parseRpcDataAsync(TABLE_ROWS, QUERY_SCHEMA, pageCache, rpcResponseQueue);
        Tuple fvlTupple = (Tuple)pageCache.take();
        Assert.assertNotNull((Object)fvlTupple);
        Iterable iterableFvl = (Iterable)fvlTupple.x();
        int rowCnt = 0;
        for (FieldValueList fvl : iterableFvl) {
            Assert.assertEquals((long)2L, (long)fvl.size());
            ++rowCnt;
        }
        Assert.assertEquals((long)2L, (long)rowCnt);
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).parseRpcDataAsync((List)ArgumentMatchers.any(List.class), (Schema)ArgumentMatchers.any(Schema.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class));
    }

    @Test
    public void testPopulateBuffer() throws InterruptedException {
        LinkedBlockingDeque pageCache = new LinkedBlockingDeque(2);
        LinkedBlockingDeque<Tuple> rpcResponseQueue = new LinkedBlockingDeque<Tuple>(2);
        LinkedBlockingDeque buffer = new LinkedBlockingDeque(5);
        rpcResponseQueue.offer(Tuple.of(null, (Object)false));
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        connectionSpy.parseRpcDataAsync(TABLE_ROWS, QUERY_SCHEMA, pageCache, rpcResponseQueue);
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).parseRpcDataAsync((List)ArgumentMatchers.any(List.class), (Schema)ArgumentMatchers.any(Schema.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class));
        connectionSpy.populateBufferAsync(rpcResponseQueue, pageCache, buffer);
        AbstractList fvl1 = (AbstractList)buffer.take();
        Assert.assertNotNull((Object)fvl1);
        Assert.assertEquals((long)2L, (long)fvl1.size());
        Assert.assertEquals((Object)"Value1", (Object)((FieldValue)fvl1.get(0)).getValue().toString());
        Assert.assertEquals((Object)"Value2", (Object)((FieldValue)fvl1.get(1)).getValue().toString());
        AbstractList fvl2 = (AbstractList)buffer.take();
        Assert.assertNotNull((Object)fvl2);
        Assert.assertEquals((long)2L, (long)fvl2.size());
        Assert.assertEquals((Object)"Value3", (Object)((FieldValue)fvl2.get(0)).getValue().toString());
        Assert.assertEquals((Object)"Value4", (Object)((FieldValue)fvl2.get(1)).getValue().toString());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).populateBufferAsync((BlockingQueue)ArgumentMatchers.any(BlockingQueue.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class));
    }

    @Test
    public void testNextPageTask() throws InterruptedException {
        LinkedBlockingDeque rpcResponseQueue = new LinkedBlockingDeque(2);
        TableDataList mockTabledataList = new TableDataList().setPageToken(PAGE_TOKEN).setRows((List)ImmutableList.of((Object)TABLE_ROW)).setTotalRows(Long.valueOf(1L));
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)mockTabledataList).when((Object)connectionSpy)).tableDataListRpc((TableId)ArgumentMatchers.any(TableId.class), (String)ArgumentMatchers.any(String.class));
        connectionSpy.runNextPageTaskAsync(PAGE_TOKEN, TABLE_NAME, rpcResponseQueue);
        Tuple tableDataListTuple = (Tuple)rpcResponseQueue.take();
        Assert.assertNotNull((Object)tableDataListTuple);
        TableDataList tableDataList = (TableDataList)tableDataListTuple.x();
        Assert.assertNotNull((Object)tableDataList);
        Assert.assertEquals((Object)PAGE_TOKEN, (Object)tableDataList.getPageToken());
        Assert.assertEquals((Object)1L, (Object)tableDataList.getTotalRows());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).runNextPageTaskAsync((String)ArgumentMatchers.any(String.class), (TableId)ArgumentMatchers.any(TableId.class), (BlockingQueue)ArgumentMatchers.any(BlockingQueue.class));
    }

    @Test
    public void testGetQueryResultsFirstPage() {
        Mockito.when((Object)this.bigqueryRpcMock.getQueryResultsWithRowLimit((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (Integer)ArgumentMatchers.any(Integer.class), (Long)ArgumentMatchers.any(Long.class))).thenReturn((Object)GET_QUERY_RESULTS_RESPONSE);
        GetQueryResultsResponse response = this.connection.getQueryResultsFirstPage(QUERY_JOB);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)GET_QUERY_RESULTS_RESPONSE, (Object)response);
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).getQueryResultsWithRowLimit((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (Integer)ArgumentMatchers.any(Integer.class), (Long)ArgumentMatchers.any(Long.class));
    }

    @Test
    public void testLegacyQuerySinglePage() throws BigQuerySQLException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        Job jobResponseMock = new Job().setJobReference(QUERY_JOB.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE"));
        ((ConnectionImpl)Mockito.doReturn((Object)false).when((Object)connectionSpy)).isFastQuerySupported();
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).getSubsequentQueryResultsWithJob((Long)ArgumentMatchers.any(Long.class), (Long)ArgumentMatchers.any(Long.class), (JobId)ArgumentMatchers.any(JobId.class), (GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (Boolean)ArgumentMatchers.any(Boolean.class));
        Mockito.when((Object)this.bigqueryRpcMock.createJobForQuery((Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)jobResponseMock);
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).createJobForQuery((Job)ArgumentMatchers.any(Job.class));
    }

    @Test
    public void testLegacyQuerySinglePageEmptyResults() throws BigQuerySQLException, SQLException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        Job jobResponseMock = new Job().setJobReference(QUERY_JOB.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE"));
        ((ConnectionImpl)Mockito.doReturn((Object)false).when((Object)connectionSpy)).isFastQuerySupported();
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE_EMPTY).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        Mockito.when((Object)this.bigqueryRpcMock.createJobForQuery((Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)jobResponseMock);
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)0L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        Assert.assertEquals((Object)false, (Object)res.getResultSet().next());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).createJobForQuery((Job)ArgumentMatchers.any(Job.class));
    }

    @Test
    public void testFastQueryLongRunning() throws SQLException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)true).when((Object)connectionSpy)).isFastQuerySupported();
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)TABLE_NAME).when((Object)connectionSpy)).getDestinationTable((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).tableDataList((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class));
        QueryResponse mockQueryRes = new QueryResponse().setSchema(FAST_QUERY_TABLESCHEMA).setJobComplete(Boolean.valueOf(false)).setTotalRows(new BigInteger(String.valueOf(4L))).setJobReference(QUERY_JOB.toPb()).setRows(TABLE_ROWS);
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class))).thenReturn((Object)mockQueryRes);
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class));
    }

    @Test
    public void testFastQueryLongRunningAsync() throws SQLException, ExecutionException, InterruptedException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)true).when((Object)connectionSpy)).isFastQuerySupported();
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)TABLE_NAME).when((Object)connectionSpy)).getDestinationTable((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).tableDataList((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class));
        QueryResponse mockQueryRes = new QueryResponse().setSchema(FAST_QUERY_TABLESCHEMA).setJobComplete(Boolean.valueOf(false)).setTotalRows(new BigInteger(String.valueOf(4L))).setJobReference(QUERY_JOB.toPb()).setRows(TABLE_ROWS);
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class))).thenReturn((Object)mockQueryRes);
        ListenableFuture executeSelectFut = connectionSpy.executeSelectAsync(SQL_QUERY);
        ExecuteSelectResponse exSelRes = (ExecuteSelectResponse)executeSelectFut.get();
        BigQueryResult res = exSelRes.getResultSet();
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        Assert.assertTrue((boolean)exSelRes.getIsSuccessful());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class));
    }

    @Test
    public void testFastQuerySinglePageAsync() throws BigQuerySQLException, ExecutionException, InterruptedException {
        QueryResponse mockQueryRes = new QueryResponse().setSchema(FAST_QUERY_TABLESCHEMA).setJobComplete(Boolean.valueOf(true));
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class))).thenReturn((Object)mockQueryRes);
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
        ListenableFuture executeSelectFut = connectionSpy.executeSelectAsync(SQL_QUERY);
        ExecuteSelectResponse exSelRes = (ExecuteSelectResponse)executeSelectFut.get();
        BigQueryResult res = exSelRes.getResultSet();
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        Assert.assertTrue((boolean)exSelRes.getIsSuccessful());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
    }

    @Test
    public void testExecuteSelectSlowWithParamsAsync() throws BigQuerySQLException, ExecutionException, InterruptedException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ArrayList parameters = new ArrayList();
        HashMap labels = new HashMap();
        ((ConnectionImpl)Mockito.doReturn((Object)false).when((Object)connectionSpy)).isFastQuerySupported();
        JobStatistics jobStatistics = new JobStatistics();
        Job jobResponseMock = new Job().setJobReference(QUERY_JOB.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE")).setStatistics(jobStatistics);
        ((ConnectionImpl)Mockito.doReturn((Object)jobResponseMock).when((Object)connectionSpy)).createQueryJob(SQL_QUERY, this.connectionSettings, parameters, labels);
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).getResultSet((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class), (String)ArgumentMatchers.any(String.class), (Boolean)ArgumentMatchers.any(Boolean.class));
        ListenableFuture executeSelectFut = connectionSpy.executeSelectAsync(SQL_QUERY, parameters, new Map[]{labels});
        ExecuteSelectResponse exSelRes = (ExecuteSelectResponse)executeSelectFut.get();
        BigQueryResult res = exSelRes.getResultSet();
        Assert.assertTrue((boolean)exSelRes.getIsSuccessful());
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).getResultSet((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class), (String)ArgumentMatchers.any(String.class), (Boolean)ArgumentMatchers.any(Boolean.class));
    }

    @Test
    public void testFastQueryMultiplePagesAsync() throws BigQuerySQLException, ExecutionException, InterruptedException {
        QueryResponse mockQueryRes = new QueryResponse().setSchema(FAST_QUERY_TABLESCHEMA).setJobComplete(Boolean.valueOf(true)).setPageToken(PAGE_TOKEN);
        Mockito.when((Object)this.bigqueryRpcMock.queryRpc((String)ArgumentMatchers.any(String.class), (QueryRequest)ArgumentMatchers.any(QueryRequest.class))).thenReturn((Object)mockQueryRes);
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES_MULTI_PAGE).when((Object)connectionSpy)).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
        ListenableFuture executeSelectFut = connectionSpy.executeSelectAsync(SQL_QUERY);
        ExecuteSelectResponse exSelRes = (ExecuteSelectResponse)executeSelectFut.get();
        BigQueryResult res = exSelRes.getResultSet();
        Assert.assertTrue((boolean)exSelRes.getIsSuccessful());
        Assert.assertEquals((long)res.getTotalRows(), (long)4L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).processQueryResponseResults((QueryResponse)ArgumentMatchers.any(QueryResponse.class));
    }

    @Test
    public void testLegacyQueryMultiplePages() throws SQLException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        JobStatistics jobStatistics = new JobStatistics();
        ((ConnectionImpl)Mockito.doReturn((Object)false).when((Object)connectionSpy)).isFastQuerySupported();
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)TABLE_NAME).when((Object)connectionSpy)).getDestinationTable((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).tableDataList((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class));
        Job jobResponseMock = new Job().setJobReference(QUERY_JOB.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE")).setStatistics(jobStatistics);
        Mockito.when((Object)this.bigqueryRpcMock.createJobForQuery((Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)jobResponseMock);
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)1))).createJobForQuery((Job)ArgumentMatchers.any(Job.class));
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).tableDataList((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class));
    }

    @Test
    public void testExecuteSelectSlow() throws BigQuerySQLException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ((ConnectionImpl)Mockito.doReturn((Object)false).when((Object)connectionSpy)).isFastQuerySupported();
        JobStatistics jobStatistics = new JobStatistics();
        Job jobResponseMock = new Job().setJobReference(QUERY_JOB.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE")).setStatistics(jobStatistics);
        ((ConnectionImpl)Mockito.doReturn((Object)jobResponseMock).when((Object)connectionSpy)).createQueryJob(SQL_QUERY, this.connectionSettings, null, null);
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).getResultSet((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class), (String)ArgumentMatchers.any(String.class), (Boolean)ArgumentMatchers.any(Boolean.class));
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY);
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).getResultSet((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class), (String)ArgumentMatchers.any(String.class), (Boolean)ArgumentMatchers.any(Boolean.class));
    }

    @Test
    public void testExecuteSelectSlowWithParams() throws BigQuerySQLException {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        ArrayList parameters = new ArrayList();
        HashMap labels = new HashMap();
        ((ConnectionImpl)Mockito.doReturn((Object)false).when((Object)connectionSpy)).isFastQuerySupported();
        JobStatistics jobStatistics = new JobStatistics();
        Job jobResponseMock = new Job().setJobReference(QUERY_JOB.toPb()).setId(JOB).setStatus(new JobStatus().setState("DONE")).setStatistics(jobStatistics);
        ((ConnectionImpl)Mockito.doReturn((Object)jobResponseMock).when((Object)connectionSpy)).createQueryJob(SQL_QUERY, this.connectionSettings, parameters, labels);
        ((ConnectionImpl)Mockito.doReturn((Object)GET_QUERY_RESULTS_RESPONSE).when((Object)connectionSpy)).getQueryResultsFirstPage((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).getResultSet((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class), (String)ArgumentMatchers.any(String.class), (Boolean)ArgumentMatchers.any(Boolean.class));
        BigQueryResult res = connectionSpy.executeSelect(SQL_QUERY, parameters, new Map[]{labels});
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).getResultSet((GetQueryResultsResponse)ArgumentMatchers.any(GetQueryResultsResponse.class), (JobId)ArgumentMatchers.any(JobId.class), (String)ArgumentMatchers.any(String.class), (Boolean)ArgumentMatchers.any(Boolean.class));
    }

    @Test
    public void testGetSubsequentQueryResultsWithJob() {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        JobId jobId = (JobId)Mockito.mock(JobId.class);
        BigQueryResultStats bqRsStats = (BigQueryResultStats)Mockito.mock(BigQueryResultStats.class);
        ((ConnectionImpl)Mockito.doReturn((Object)true).when((Object)connectionSpy)).useReadAPI((Long)ArgumentMatchers.any(Long.class), (Long)ArgumentMatchers.any(Long.class), (Schema)ArgumentMatchers.any(Schema.class), (Boolean)ArgumentMatchers.any(Boolean.class));
        ((ConnectionImpl)Mockito.doReturn((Object)BQ_RS_MOCK_RES).when((Object)connectionSpy)).highThroughPutRead((TableId)ArgumentMatchers.any(TableId.class), ((Long)ArgumentMatchers.any(Long.class)).longValue(), (Schema)ArgumentMatchers.any(Schema.class), (BigQueryResultStats)ArgumentMatchers.any(BigQueryResultStats.class));
        ((ConnectionImpl)Mockito.doReturn((Object)TABLE_NAME).when((Object)connectionSpy)).getDestinationTable((JobId)ArgumentMatchers.any(JobId.class));
        ((ConnectionImpl)Mockito.doReturn((Object)bqRsStats).when((Object)connectionSpy)).getBigQueryResultSetStats((JobId)ArgumentMatchers.any(JobId.class));
        BigQueryResult res = connectionSpy.getSubsequentQueryResultsWithJob(Long.valueOf(10000L), Long.valueOf(100L), jobId, GET_QUERY_RESULTS_RESPONSE, Boolean.valueOf(false));
        Assert.assertEquals((long)res.getTotalRows(), (long)2L);
        Assert.assertEquals((Object)QUERY_SCHEMA, (Object)res.getSchema());
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)1))).getSubsequentQueryResultsWithJob(Long.valueOf(10000L), Long.valueOf(100L), jobId, GET_QUERY_RESULTS_RESPONSE, Boolean.valueOf(false));
    }

    @Test
    public void testUseReadApi() {
        ConnectionSettings connectionSettingsSpy = (ConnectionSettings)Mockito.spy(ConnectionSettings.class);
        ((ConnectionSettings)Mockito.doReturn((Object)true).when((Object)connectionSettingsSpy)).getUseReadAPI();
        ((ConnectionSettings)Mockito.doReturn((Object)2).when((Object)connectionSettingsSpy)).getTotalToPageRowCountRatio();
        ((ConnectionSettings)Mockito.doReturn((Object)100).when((Object)connectionSettingsSpy)).getMinResultSize();
        this.connection = (ConnectionImpl)this.bigquery.createConnection(connectionSettingsSpy);
        Assert.assertTrue((boolean)this.connection.useReadAPI(null, null, QUERY_SCHEMA, Boolean.valueOf(false)));
        Assert.assertFalse((boolean)this.connection.useReadAPI(Long.valueOf(10000L), Long.valueOf(10000L), QUERY_SCHEMA, Boolean.valueOf(false)));
        Assert.assertFalse((boolean)this.connection.useReadAPI(Long.valueOf(50L), Long.valueOf(10L), QUERY_SCHEMA, Boolean.valueOf(false)));
        Assert.assertTrue((boolean)this.connection.useReadAPI(Long.valueOf(10000L), Long.valueOf(10L), QUERY_SCHEMA, Boolean.valueOf(false)));
        Assert.assertFalse((boolean)this.connection.useReadAPI(Long.valueOf(10000L), Long.valueOf(10L), QUERY_SCHEMA_WITH_INTERVAL_FIELD, Boolean.valueOf(false)));
        Assert.assertFalse((boolean)this.connection.useReadAPI(Long.valueOf(10000L), Long.valueOf(10L), QUERY_SCHEMA, Boolean.valueOf(true)));
        ((ConnectionSettings)Mockito.doReturn((Object)false).when((Object)connectionSettingsSpy)).getUseReadAPI();
        Assert.assertFalse((boolean)this.connection.useReadAPI(null, null, QUERY_SCHEMA, Boolean.valueOf(false)));
        Assert.assertFalse((boolean)this.connection.useReadAPI(Long.valueOf(10000L), Long.valueOf(10L), QUERY_SCHEMA, Boolean.valueOf(false)));
    }

    @Test
    public void testGetPageCacheSize() {
        ConnectionImpl connectionSpy = (ConnectionImpl)Mockito.spy((Object)this.connection);
        Assert.assertTrue((connectionSpy.getPageCacheSize(Integer.valueOf(10000), QUERY_SCHEMA) >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((connectionSpy.getPageCacheSize(Integer.valueOf(100000000), QUERY_SCHEMA) <= 20 ? 1 : 0) != 0);
        ((ConnectionImpl)Mockito.verify((Object)connectionSpy, (VerificationMode)Mockito.times((int)2))).getPageCacheSize((Integer)ArgumentMatchers.any(Integer.class), (Schema)ArgumentMatchers.any(Schema.class));
    }
}

