/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.ConnectionProperty;
import com.google.common.truth.Truth;
import org.junit.Test;

public class ConnectionPropertyTest {
    private static final String KEY = "time_zone";
    private static final String VALUE = "US/Eastern";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("time_zone").setValue("US/Eastern").build();

    @Test
    public void testToBuilder() {
        this.compareConnectionProperty(CONNECTION_PROPERTY, CONNECTION_PROPERTY.toBuilder().build());
        ConnectionProperty property = CONNECTION_PROPERTY.toBuilder().setKey("time-zone").build();
        Truth.assertThat((String)property.getKey()).isEqualTo((Object)"time-zone");
        property = CONNECTION_PROPERTY.toBuilder().setKey(KEY).build();
        this.compareConnectionProperty(CONNECTION_PROPERTY, property);
    }

    @Test
    public void testToBuilderIncomplete() {
        ConnectionProperty connectionProperty = ConnectionProperty.of((String)KEY, (String)VALUE);
        this.compareConnectionProperty(connectionProperty, connectionProperty.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Truth.assertThat((String)CONNECTION_PROPERTY.getKey()).isEqualTo((Object)KEY);
        Truth.assertThat((String)CONNECTION_PROPERTY.getValue()).isEqualTo((Object)VALUE);
    }

    @Test
    public void testToAndFromPb() {
        this.compareConnectionProperty(CONNECTION_PROPERTY, ConnectionProperty.fromPb((com.google.api.services.bigquery.model.ConnectionProperty)CONNECTION_PROPERTY.toPb()));
    }

    private void compareConnectionProperty(ConnectionProperty expected, ConnectionProperty value) {
        Truth.assertThat((Object)value).isEqualTo((Object)expected);
        Truth.assertThat((String)value.getKey()).isEqualTo((Object)expected.getKey());
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)expected.getValue());
        Truth.assertThat((String)value.toString()).isEqualTo((Object)expected.toString());
        Truth.assertThat((Integer)value.hashCode()).isEqualTo((Object)expected.hashCode());
    }
}

