/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionSettingsTest {
    private static final String TEST_PROJECT_ID = "test-project-id";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final Long REQUEST_TIMEOUT = 10L;
    private static final Integer NUM_BUFFERED_ROWS = 100;
    private static final Long MAX_RESULTS = 1000L;
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final String KEY = "time_zone";
    private static final String VALUE = "US/Eastern";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("time_zone").setValue("US/Eastern").build();
    private static final List<ConnectionProperty> CONNECTION_PROPERTIES = ImmutableList.of((Object)CONNECTION_PROPERTY);
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2});
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().build();
    private static final ExternalTableDefinition TABLE_CONFIGURATION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setCompression("GZIP").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).build();
    private static final Map<String, ExternalTableDefinition> TABLE_DEFINITIONS = ImmutableMap.of((Object)"tableName", (Object)TABLE_CONFIGURATION);
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final QueryJobConfiguration.Priority PRIORITY = QueryJobConfiguration.Priority.BATCH;
    private static final boolean ALLOW_LARGE_RESULTS = true;
    private static final boolean USE_QUERY_CACHE = false;
    private static final boolean FLATTEN_RESULTS = true;
    private static final Integer MAX_BILLING_TIER = 123;
    private static final Long MAX_BYTES_BILL = 12345L;
    private static final List<JobInfo.SchemaUpdateOption> SCHEMA_UPDATE_OPTIONS = ImmutableList.of((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final EncryptionConfiguration JOB_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final Long TIMEOUT = 10L;
    private static final RangePartitioning.Range RANGE = RangePartitioning.Range.newBuilder().setStart(Long.valueOf(1L)).setInterval(Long.valueOf(2L)).setEnd(Long.valueOf(10L)).build();
    private static final RangePartitioning RANGE_PARTITIONING = RangePartitioning.newBuilder().setField("IntegerField").setRange(RANGE).build();
    private static final ConnectionSettings CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setRequestTimeout(REQUEST_TIMEOUT).setNumBufferedRows(NUM_BUFFERED_ROWS).setMaxResults(MAX_RESULTS).setUseQueryCache(Boolean.valueOf(false)).setTableDefinitions(TABLE_DEFINITIONS).setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition(CREATE_DISPOSITION).setDefaultDataset(DATASET_ID).setDestinationTable(TABLE_ID).setWriteDisposition(WRITE_DISPOSITION).setPriority(PRIORITY).setFlattenResults(Boolean.valueOf(true)).setUserDefinedFunctions(USER_DEFINED_FUNCTIONS).setMaximumBillingTier(MAX_BILLING_TIER).setMaximumBytesBilled(MAX_BYTES_BILL).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setDestinationEncryptionConfiguration(JOB_ENCRYPTION_CONFIGURATION).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setJobTimeoutMs(TIMEOUT).setRangePartitioning(RANGE_PARTITIONING).setConnectionProperties(CONNECTION_PROPERTIES).build();

    @Test
    public void testToBuilder() {
        this.compareConnectionSettings(CONNECTION_SETTINGS, CONNECTION_SETTINGS.toBuilder().build());
    }

    @Test
    public void testToBuilderIncomplete() {
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DATASET_ID).build();
        this.compareConnectionSettings(connectionSettings, connectionSettings.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)REQUEST_TIMEOUT, (Object)CONNECTION_SETTINGS.getRequestTimeout());
        Assert.assertEquals((Object)NUM_BUFFERED_ROWS, (Object)CONNECTION_SETTINGS.getNumBufferedRows());
        Assert.assertEquals((Object)MAX_RESULTS, (Object)CONNECTION_SETTINGS.getMaxResults());
    }

    private void compareConnectionSettings(ConnectionSettings expected, ConnectionSettings value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getRequestTimeout(), (Object)value.getRequestTimeout());
        Assert.assertEquals((Object)expected.getNumBufferedRows(), (Object)value.getNumBufferedRows());
        Assert.assertEquals((Object)expected.getMaxResults(), (Object)value.getMaxResults());
        Assert.assertEquals((Object)expected.getAllowLargeResults(), (Object)value.getAllowLargeResults());
        Assert.assertEquals((Object)expected.getCreateDisposition(), (Object)value.getCreateDisposition());
        Assert.assertEquals((Object)expected.getDefaultDataset(), (Object)value.getDefaultDataset());
        Assert.assertEquals((Object)expected.getDestinationTable(), (Object)value.getDestinationTable());
        Assert.assertEquals((Object)expected.getFlattenResults(), (Object)value.getFlattenResults());
        Assert.assertEquals((Object)expected.getPriority(), (Object)value.getPriority());
        Assert.assertEquals((Object)expected.getTableDefinitions(), (Object)value.getTableDefinitions());
        Assert.assertEquals((Object)expected.getUseQueryCache(), (Object)value.getUseQueryCache());
        Assert.assertEquals((Object)expected.getUserDefinedFunctions(), (Object)value.getUserDefinedFunctions());
        Assert.assertEquals((Object)expected.getWriteDisposition(), (Object)value.getWriteDisposition());
        Assert.assertEquals((Object)expected.getMaximumBillingTier(), (Object)value.getMaximumBillingTier());
        Assert.assertEquals((Object)expected.getMaximumBytesBilled(), (Object)value.getMaximumBytesBilled());
        Assert.assertEquals((Object)expected.getSchemaUpdateOptions(), (Object)value.getSchemaUpdateOptions());
        Assert.assertEquals((Object)expected.getDestinationEncryptionConfiguration(), (Object)value.getDestinationEncryptionConfiguration());
        Assert.assertEquals((Object)expected.getTimePartitioning(), (Object)value.getTimePartitioning());
        Assert.assertEquals((Object)expected.getClustering(), (Object)value.getClustering());
        Assert.assertEquals((Object)expected.getJobTimeoutMs(), (Object)value.getJobTimeoutMs());
        Assert.assertEquals((Object)expected.getRangePartitioning(), (Object)value.getRangePartitioning());
        Assert.assertEquals((Object)expected.getConnectionProperties(), (Object)value.getConnectionProperties());
    }
}

