/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class CopyJobConfigurationTest {
    private static final String TEST_PROJECT_ID = "test-project-id";
    private static final TableId SOURCE_TABLE = TableId.of((String)"dataset", (String)"sourceTable");
    private static final List<TableId> SOURCE_TABLES = ImmutableList.of((Object)TableId.of((String)"dataset", (String)"sourceTable1"), (Object)TableId.of((String)"dataset", (String)"sourceTable2"));
    private static final TableId DESTINATION_TABLE = TableId.of((String)"dataset", (String)"destinationTable");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final EncryptionConfiguration COPY_JOB_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"job-name", (Object)"copy");
    private static final Long TIMEOUT = 10L;
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.newBuilder((TableId)DESTINATION_TABLE, (TableId)SOURCE_TABLE).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setDestinationEncryptionConfiguration(COPY_JOB_ENCRYPTION_CONFIGURATION).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).build();
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION_MULTIPLE_TABLES = CopyJobConfiguration.newBuilder((TableId)DESTINATION_TABLE, SOURCE_TABLES).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).build();

    @Test
    public void testToBuilder() {
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION, COPY_JOB_CONFIGURATION.toBuilder().build());
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION_MULTIPLE_TABLES, COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toBuilder().build());
        CopyJobConfiguration jobConfiguration = COPY_JOB_CONFIGURATION.toBuilder().setDestinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)jobConfiguration.getDestinationTable().getTable());
        jobConfiguration = jobConfiguration.toBuilder().setDestinationTable(DESTINATION_TABLE).build();
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION, jobConfiguration);
    }

    @Test
    public void testOf() {
        CopyJobConfiguration job = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, SOURCE_TABLES);
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)job.getDestinationTable());
        Assert.assertEquals(SOURCE_TABLES, (Object)job.getSourceTables());
        job = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, (TableId)SOURCE_TABLE);
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)job.getDestinationTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)SOURCE_TABLE), (Object)job.getSourceTables());
    }

    @Test
    public void testToBuilderIncomplete() {
        CopyJobConfiguration jobConfiguration = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, SOURCE_TABLES);
        this.compareCopyJobConfiguration(jobConfiguration, jobConfiguration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.getDestinationTable());
        Assert.assertEquals(SOURCE_TABLES, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.getSourceTables());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.getCreateDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.getWriteDisposition());
        Assert.assertEquals((Object)DESTINATION_TABLE, (Object)COPY_JOB_CONFIGURATION.getDestinationTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)SOURCE_TABLE), (Object)COPY_JOB_CONFIGURATION.getSourceTables());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION.getCreateDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)COPY_JOB_CONFIGURATION.getWriteDisposition());
        Assert.assertEquals(LABELS, (Object)COPY_JOB_CONFIGURATION.getLabels());
        Assert.assertEquals((Object)TIMEOUT, (Object)COPY_JOB_CONFIGURATION.getJobTimeoutMs());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)COPY_JOB_CONFIGURATION.toPb().getCopy());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getExtract());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getLoad());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getQuery());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION.toPb().getCopy().getSourceTable());
        Assert.assertNotNull((Object)COPY_JOB_CONFIGURATION.toPb().getCopy().getSourceTables());
        Assert.assertNull((Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toPb().getCopy().getSourceTable());
        Assert.assertNotNull((Object)COPY_JOB_CONFIGURATION.getLabels());
        Assert.assertNotNull((Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.getLabels());
        Assert.assertNotNull((Object)COPY_JOB_CONFIGURATION.getJobTimeoutMs());
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION, CopyJobConfiguration.fromPb((JobConfiguration)COPY_JOB_CONFIGURATION.toPb()));
        this.compareCopyJobConfiguration(COPY_JOB_CONFIGURATION_MULTIPLE_TABLES, CopyJobConfiguration.fromPb((JobConfiguration)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toPb()));
        CopyJobConfiguration jobConfiguration = CopyJobConfiguration.of((TableId)DESTINATION_TABLE, SOURCE_TABLES);
        this.compareCopyJobConfiguration(jobConfiguration, CopyJobConfiguration.fromPb((JobConfiguration)jobConfiguration.toPb()));
    }

    @Test
    public void testSetProjectId() {
        CopyJobConfiguration configuration = COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.setProjectId(TEST_PROJECT_ID);
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDestinationTable().getProject());
        for (TableId sourceTable : configuration.getSourceTables()) {
            Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)sourceTable.getProject());
        }
    }

    @Test
    public void testSetProjectIdDoNotOverride() {
        CopyJobConfiguration configuration = COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.toBuilder().setSourceTables(Lists.transform(SOURCE_TABLES, (Function)new Function<TableId, TableId>(){

            public TableId apply(TableId tableId) {
                return tableId.setProjectId(CopyJobConfigurationTest.TEST_PROJECT_ID);
            }
        })).setDestinationTable(DESTINATION_TABLE.setProjectId(TEST_PROJECT_ID)).build().setProjectId("do-not-update");
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDestinationTable().getProject());
        for (TableId sourceTable : configuration.getSourceTables()) {
            Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)sourceTable.getProject());
        }
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)JobConfiguration.Type.COPY, (Object)COPY_JOB_CONFIGURATION.getType());
        Assert.assertEquals((Object)JobConfiguration.Type.COPY, (Object)COPY_JOB_CONFIGURATION_MULTIPLE_TABLES.getType());
    }

    private void compareCopyJobConfiguration(CopyJobConfiguration expected, CopyJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getDestinationTable(), (Object)value.getDestinationTable());
        Assert.assertEquals((Object)expected.getSourceTables(), (Object)value.getSourceTables());
        Assert.assertEquals((Object)expected.getCreateDisposition(), (Object)value.getCreateDisposition());
        Assert.assertEquals((Object)expected.getWriteDisposition(), (Object)value.getWriteDisposition());
        Assert.assertEquals((Object)expected.getDestinationEncryptionConfiguration(), (Object)value.getDestinationEncryptionConfiguration());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getJobTimeoutMs(), (Object)value.getJobTimeoutMs());
    }
}

