/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.CsvOptions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class CsvOptionsTest {
    private static final Boolean ALLOW_JAGGED_ROWS = true;
    private static final Boolean ALLOW_QUOTED_NEWLINE = true;
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String FIELD_DELIMITER = ",";
    private static final String NULL_MARKER = "\\N";
    private static final String QUOTE = "\"";
    private static final long SKIP_LEADING_ROWS = 42L;
    private static final boolean PRESERVE_ASCII_CONTROL_CHARACTERS = true;
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().setAllowJaggedRows(ALLOW_JAGGED_ROWS.booleanValue()).setAllowQuotedNewLines(ALLOW_QUOTED_NEWLINE.booleanValue()).setEncoding(ENCODING).setFieldDelimiter(",").setNullMarker("\\N").setQuote("\"").setSkipLeadingRows(42L).setPreserveAsciiControlCharacters(true).build();

    @Test
    public void testToBuilder() {
        this.compareCsvOptions(CSV_OPTIONS, CSV_OPTIONS.toBuilder().build());
        CsvOptions csvOptions = CSV_OPTIONS.toBuilder().setFieldDelimiter(";").build();
        Assert.assertEquals((Object)";", (Object)csvOptions.getFieldDelimiter());
        csvOptions = csvOptions.toBuilder().setFieldDelimiter(FIELD_DELIMITER).build();
        this.compareCsvOptions(CSV_OPTIONS, csvOptions);
    }

    @Test
    public void testToBuilderIncomplete() {
        CsvOptions csvOptions = CsvOptions.newBuilder().setFieldDelimiter("|").build();
        Assert.assertEquals((Object)csvOptions, (Object)csvOptions.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"CSV", (Object)CSV_OPTIONS.getType());
        Assert.assertEquals((Object)ALLOW_JAGGED_ROWS, (Object)CSV_OPTIONS.allowJaggedRows());
        Assert.assertEquals((Object)ALLOW_QUOTED_NEWLINE, (Object)CSV_OPTIONS.allowQuotedNewLines());
        Assert.assertEquals((Object)ENCODING.name(), (Object)CSV_OPTIONS.getEncoding());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)CSV_OPTIONS.getFieldDelimiter());
        Assert.assertEquals((Object)NULL_MARKER, (Object)CSV_OPTIONS.getNullMarker());
        Assert.assertEquals((Object)QUOTE, (Object)CSV_OPTIONS.getQuote());
        Assert.assertEquals((long)42L, (long)CSV_OPTIONS.getSkipLeadingRows());
        Assert.assertEquals((Object)true, (Object)CSV_OPTIONS.getPreserveAsciiControlCharacters());
    }

    @Test
    public void testToAndFromPb() {
        this.compareCsvOptions(CSV_OPTIONS, CsvOptions.fromPb((com.google.api.services.bigquery.model.CsvOptions)CSV_OPTIONS.toPb()));
        CsvOptions csvOptions = CsvOptions.newBuilder().setAllowJaggedRows(ALLOW_JAGGED_ROWS.booleanValue()).build();
        this.compareCsvOptions(csvOptions, CsvOptions.fromPb((com.google.api.services.bigquery.model.CsvOptions)csvOptions.toPb()));
    }

    private void compareCsvOptions(CsvOptions expected, CsvOptions value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.allowJaggedRows(), (Object)value.allowJaggedRows());
        Assert.assertEquals((Object)expected.allowQuotedNewLines(), (Object)value.allowQuotedNewLines());
        Assert.assertEquals((Object)expected.getEncoding(), (Object)value.getEncoding());
        Assert.assertEquals((Object)expected.getFieldDelimiter(), (Object)value.getFieldDelimiter());
        Assert.assertEquals((Object)expected.getNullMarker(), (Object)value.getNullMarker());
        Assert.assertEquals((Object)expected.getQuote(), (Object)value.getQuote());
        Assert.assertEquals((Object)expected.getSkipLeadingRows(), (Object)value.getSkipLeadingRows());
    }
}

