/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalDatasetReference;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DatasetInfoTest {
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"dataset", (String)"table"))), (Object)Acl.of((Acl.Routine)new Acl.Routine(RoutineId.of((String)"dataset", (String)"routine"))));
    private static final List<Acl> ACCESS_RULES_COMPLETE = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"table"))), (Object)Acl.of((Acl.Routine)new Acl.Routine(RoutineId.of((String)"project", (String)"dataset", (String)"routine"))));
    private static final List<Acl> ACCESS_RULES_IAM_MEMBER = ImmutableList.of((Object)Acl.of((Acl.Entity)new Acl.IamMember("allUsers"), (Acl.Role)Acl.Role.READER));
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"example-label1", (Object)"example-value1", (Object)"example-label2", (Object)"example-value2");
    private static final Long CREATION_TIME = System.currentTimeMillis();
    private static final Long DEFAULT_TABLE_EXPIRATION = CREATION_TIME + 100L;
    private static final Long DEFAULT_PARTITION__EXPIRATION = CREATION_TIME + 86400L;
    private static final String DESCRIPTION = "description";
    private static final String ETAG = "0xFF00";
    private static final String FRIENDLY_NAME = "friendlyDataset";
    private static final String GENERATED_ID = "P/D:1";
    private static final Long LAST_MODIFIED = CREATION_TIME + 50L;
    private static final String LOCATION = "";
    private static final String SELF_LINK = "http://bigquery/p/d";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final DatasetId DATASET_ID_COMPLETE = DatasetId.of((String)"project", (String)"dataset");
    private static final EncryptionConfiguration DATASET_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final String STORAGE_BILLING_MODEL = "LOGICAL";
    private static final Long MAX_TIME_TRAVEL_HOURS_5_DAYS = 120L;
    private static final Long MAX_TIME_TRAVEL_HOURS_7_DAYS = 168L;
    private static final ExternalDatasetReference EXTERNAL_DATASET_REFERENCE = ExternalDatasetReference.newBuilder().setExternalSource("source").setConnection("connection").build();
    private static final DatasetInfo DATASET_INFO = DatasetInfo.newBuilder((DatasetId)DATASET_ID).setAcl(ACCESS_RULES).setCreationTime(CREATION_TIME).setDefaultTableLifetime(DEFAULT_TABLE_EXPIRATION).setDescription("description").setEtag("0xFF00").setFriendlyName("friendlyDataset").setGeneratedId("P/D:1").setLastModified(LAST_MODIFIED).setLocation("").setSelfLink("http://bigquery/p/d").setLabels(LABELS).setDefaultEncryptionConfiguration(DATASET_ENCRYPTION_CONFIGURATION).setDefaultPartitionExpirationMs(DEFAULT_PARTITION__EXPIRATION).setStorageBillingModel("LOGICAL").setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS_7_DAYS).build();
    private static final DatasetInfo DATASET_INFO_COMPLETE = DATASET_INFO.toBuilder().setDatasetId(DATASET_ID_COMPLETE).setAcl(ACCESS_RULES_COMPLETE).build();
    private static final DatasetInfo DATASET_INFO_COMPLETE_WITH_IAM_MEMBER = DATASET_INFO.toBuilder().setAcl(ACCESS_RULES_IAM_MEMBER).build();
    private static final DatasetInfo DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE = DATASET_INFO.toBuilder().setExternalDatasetReference(EXTERNAL_DATASET_REFERENCE).build();
    private static final DatasetInfo DATASET_INFO_WITH_MAX_TIME_TRAVEL_5_DAYS = DATASET_INFO.toBuilder().setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS_5_DAYS).build();

    @Test
    public void testToBuilder() {
        this.compareDatasets(DATASET_INFO, DATASET_INFO.toBuilder().build());
        this.compareDatasets(DATASET_INFO_COMPLETE_WITH_IAM_MEMBER, DATASET_INFO_COMPLETE_WITH_IAM_MEMBER.toBuilder().build());
        DatasetInfo datasetInfo = DATASET_INFO.toBuilder().setDatasetId(DatasetId.of((String)"dataset2")).setDescription("description2").build();
        Assert.assertEquals((Object)DatasetId.of((String)"dataset2"), (Object)datasetInfo.getDatasetId());
        Assert.assertEquals((Object)"description2", (Object)datasetInfo.getDescription());
        datasetInfo = datasetInfo.toBuilder().setDatasetId(DATASET_ID).setDescription(DESCRIPTION).build();
        this.compareDatasets(DATASET_INFO, datasetInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((DatasetId)DATASET_ID).build();
        Assert.assertEquals((Object)datasetInfo, (Object)datasetInfo.toBuilder().build());
    }

    @Test
    public void testToBuilderWithExternalDatasetReference() {
        this.compareDatasets(DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE, DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE.toBuilder().build());
        ExternalDatasetReference externalDatasetReference = ExternalDatasetReference.newBuilder().setExternalSource("source2").setConnection("connection2").build();
        DatasetInfo datasetInfo = DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE.toBuilder().setExternalDatasetReference(externalDatasetReference).build();
        Assert.assertEquals((Object)externalDatasetReference, (Object)datasetInfo.getExternalDatasetReference());
        datasetInfo = datasetInfo.toBuilder().setExternalDatasetReference(EXTERNAL_DATASET_REFERENCE).build();
        this.compareDatasets(DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE, datasetInfo);
    }

    @Test
    public void testBuilder() {
        Assert.assertNull((Object)DATASET_INFO.getDatasetId().getProject());
        Assert.assertEquals((Object)DATASET_ID, (Object)DATASET_INFO.getDatasetId());
        Assert.assertEquals(ACCESS_RULES, (Object)DATASET_INFO.getAcl());
        Assert.assertEquals((Object)CREATION_TIME, (Object)DATASET_INFO.getCreationTime());
        Assert.assertEquals((Object)DEFAULT_TABLE_EXPIRATION, (Object)DATASET_INFO.getDefaultTableLifetime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DATASET_INFO.getDescription());
        Assert.assertEquals((Object)ETAG, (Object)DATASET_INFO.getEtag());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)DATASET_INFO.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)DATASET_INFO.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED, (Object)DATASET_INFO.getLastModified());
        Assert.assertEquals((Object)LOCATION, (Object)DATASET_INFO.getLocation());
        Assert.assertEquals((Object)SELF_LINK, (Object)DATASET_INFO.getSelfLink());
        Assert.assertEquals((Object)DATASET_ENCRYPTION_CONFIGURATION, (Object)DATASET_INFO.getDefaultEncryptionConfiguration());
        Assert.assertEquals((Object)DEFAULT_PARTITION__EXPIRATION, (Object)DATASET_INFO.getDefaultPartitionExpirationMs());
        Assert.assertEquals((Object)DATASET_ID_COMPLETE, (Object)DATASET_INFO_COMPLETE.getDatasetId());
        Assert.assertEquals(ACCESS_RULES_COMPLETE, (Object)DATASET_INFO_COMPLETE.getAcl());
        Assert.assertEquals((Object)CREATION_TIME, (Object)DATASET_INFO_COMPLETE.getCreationTime());
        Assert.assertEquals((Object)DEFAULT_TABLE_EXPIRATION, (Object)DATASET_INFO_COMPLETE.getDefaultTableLifetime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DATASET_INFO_COMPLETE.getDescription());
        Assert.assertEquals((Object)ETAG, (Object)DATASET_INFO_COMPLETE.getEtag());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)DATASET_INFO_COMPLETE.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)DATASET_INFO_COMPLETE.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED, (Object)DATASET_INFO_COMPLETE.getLastModified());
        Assert.assertEquals((Object)LOCATION, (Object)DATASET_INFO_COMPLETE.getLocation());
        Assert.assertEquals((Object)SELF_LINK, (Object)DATASET_INFO_COMPLETE.getSelfLink());
        Assert.assertEquals(LABELS, (Object)DATASET_INFO_COMPLETE.getLabels());
        Assert.assertEquals((Object)EXTERNAL_DATASET_REFERENCE, (Object)DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE.getExternalDatasetReference());
        Assert.assertEquals((Object)STORAGE_BILLING_MODEL, (Object)DATASET_INFO_COMPLETE.getStorageBillingModel());
        Assert.assertEquals((Object)MAX_TIME_TRAVEL_HOURS_7_DAYS, (Object)DATASET_INFO.getMaxTimeTravelHours());
        Assert.assertEquals((Object)MAX_TIME_TRAVEL_HOURS_5_DAYS, (Object)DATASET_INFO_WITH_MAX_TIME_TRAVEL_5_DAYS.getMaxTimeTravelHours());
    }

    @Test
    public void testOf() {
        DatasetInfo datasetInfo = DatasetInfo.of((String)DATASET_ID.getDataset());
        Assert.assertEquals((Object)DATASET_ID, (Object)datasetInfo.getDatasetId());
        Assert.assertNull((Object)datasetInfo.getAcl());
        Assert.assertNull((Object)datasetInfo.getCreationTime());
        Assert.assertNull((Object)datasetInfo.getDefaultTableLifetime());
        Assert.assertNull((Object)datasetInfo.getDescription());
        Assert.assertNull((Object)datasetInfo.getEtag());
        Assert.assertNull((Object)datasetInfo.getFriendlyName());
        Assert.assertNull((Object)datasetInfo.getGeneratedId());
        Assert.assertNull((Object)datasetInfo.getLastModified());
        Assert.assertNull((Object)datasetInfo.getLocation());
        Assert.assertNull((Object)datasetInfo.getSelfLink());
        Assert.assertNull((Object)datasetInfo.getDefaultEncryptionConfiguration());
        Assert.assertNull((Object)datasetInfo.getDefaultPartitionExpirationMs());
        Assert.assertTrue((boolean)datasetInfo.getLabels().isEmpty());
        Assert.assertNull((Object)datasetInfo.getExternalDatasetReference());
        Assert.assertNull((Object)datasetInfo.getStorageBillingModel());
        Assert.assertNull((Object)datasetInfo.getMaxTimeTravelHours());
        datasetInfo = DatasetInfo.of((DatasetId)DATASET_ID);
        Assert.assertEquals((Object)DATASET_ID, (Object)datasetInfo.getDatasetId());
        Assert.assertNull((Object)datasetInfo.getAcl());
        Assert.assertNull((Object)datasetInfo.getCreationTime());
        Assert.assertNull((Object)datasetInfo.getDefaultTableLifetime());
        Assert.assertNull((Object)datasetInfo.getDescription());
        Assert.assertNull((Object)datasetInfo.getEtag());
        Assert.assertNull((Object)datasetInfo.getFriendlyName());
        Assert.assertNull((Object)datasetInfo.getGeneratedId());
        Assert.assertNull((Object)datasetInfo.getLastModified());
        Assert.assertNull((Object)datasetInfo.getLocation());
        Assert.assertNull((Object)datasetInfo.getSelfLink());
        Assert.assertNull((Object)datasetInfo.getDefaultEncryptionConfiguration());
        Assert.assertNull((Object)datasetInfo.getDefaultPartitionExpirationMs());
        Assert.assertTrue((boolean)datasetInfo.getLabels().isEmpty());
        Assert.assertNull((Object)datasetInfo.getExternalDatasetReference());
        Assert.assertNull((Object)datasetInfo.getStorageBillingModel());
        Assert.assertNull((Object)datasetInfo.getMaxTimeTravelHours());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareDatasets(DATASET_INFO_COMPLETE, DatasetInfo.fromPb((Dataset)DATASET_INFO_COMPLETE.toPb()));
        this.compareDatasets(DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE, DatasetInfo.fromPb((Dataset)DATASET_INFO_COMPLETE_WITH_EXTERNAL_DATASET_REFERENCE.toPb()));
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)"project", (String)"dataset").build();
        this.compareDatasets(datasetInfo, DatasetInfo.fromPb((Dataset)datasetInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)DATASET_INFO_COMPLETE, (Object)DATASET_INFO.setProjectId("project"));
    }

    @Test
    public void testSetMaxTimeTravelHours() {
        Assert.assertNotEquals((Object)DATASET_INFO_WITH_MAX_TIME_TRAVEL_5_DAYS.getMaxTimeTravelHours(), (Object)DATASET_INFO.getMaxTimeTravelHours());
        Assert.assertEquals((Object)DATASET_INFO_WITH_MAX_TIME_TRAVEL_5_DAYS, (Object)DATASET_INFO.toBuilder().setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS_5_DAYS).build());
    }

    private void compareDatasets(DatasetInfo expected, DatasetInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getDatasetId(), (Object)value.getDatasetId());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getFriendlyName(), (Object)value.getFriendlyName());
        Assert.assertEquals((Object)expected.getGeneratedId(), (Object)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getLocation(), (Object)value.getLocation());
        Assert.assertEquals((Object)expected.getSelfLink(), (Object)value.getSelfLink());
        Assert.assertEquals((Object)expected.getAcl(), (Object)value.getAcl());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getDefaultTableLifetime(), (Object)value.getDefaultTableLifetime());
        Assert.assertEquals((Object)expected.getLastModified(), (Object)value.getLastModified());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getDefaultEncryptionConfiguration(), (Object)value.getDefaultEncryptionConfiguration());
        Assert.assertEquals((Object)expected.getDefaultPartitionExpirationMs(), (Object)value.getDefaultPartitionExpirationMs());
        Assert.assertEquals((Object)expected.getExternalDatasetReference(), (Object)value.getExternalDatasetReference());
        Assert.assertEquals((Object)expected.getStorageBillingModel(), (Object)value.getStorageBillingModel());
        Assert.assertEquals((Object)expected.getMaxTimeTravelHours(), (Object)value.getMaxTimeTravelHours());
    }
}

