/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalDatasetReference;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.junit.MockitoRule;

@RunWith(value=MockitoJUnitRunner.class)
public class DatasetTest {
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER), (Object)Acl.of((Acl.View)new Acl.View(TableId.of((String)"dataset", (String)"table"))), (Object)Acl.of((Acl.Routine)new Acl.Routine(RoutineId.of((String)"dataset", (String)"routine"))));
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"example-label1", (Object)"example-value1", (Object)"example-label2", (Object)"example-value2");
    private static final Long CREATION_TIME = System.currentTimeMillis();
    private static final Long DEFAULT_TABLE_EXPIRATION = CREATION_TIME + 100L;
    private static final String DESCRIPTION = "description";
    private static final String ETAG = "0xFF00";
    private static final String FRIENDLY_NAME = "friendlyDataset";
    private static final String GENERATED_ID = "P/D:1";
    private static final Long LAST_MODIFIED = CREATION_TIME + 50L;
    private static final String LOCATION = "";
    private static final String SELF_LINK = "http://bigquery/p/d";
    private static final DatasetInfo DATASET_INFO = DatasetInfo.newBuilder((DatasetId)DATASET_ID).build();
    private static final Field FIELD = Field.of((String)"FieldName", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]);
    private static final String STORAGE_BILLING_MODEL = "LOGICAL";
    private static final Long MAX_TIME_TRAVEL_HOURS = 168L;
    private static final StandardTableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{FIELD}));
    private static final ViewDefinition VIEW_DEFINITION = ViewDefinition.of((String)"QUERY");
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.of((List)ImmutableList.of((Object)"URI"), (Schema)Schema.of((Field[])new Field[0]), (FormatOptions)FormatOptions.csv());
    private static final TableInfo TABLE_INFO1 = TableInfo.newBuilder((TableId)TableId.of((String)"dataset", (String)"table1"), (TableDefinition)TABLE_DEFINITION).build();
    private static final TableInfo TABLE_INFO2 = TableInfo.newBuilder((TableId)TableId.of((String)"dataset", (String)"table2"), (TableDefinition)VIEW_DEFINITION).build();
    private static final TableInfo TABLE_INFO3 = TableInfo.newBuilder((TableId)TableId.of((String)"dataset", (String)"table3"), (TableDefinition)EXTERNAL_TABLE_DEFINITION).build();
    private static final String NEW_PROJECT_ID = "projectId2";
    private static final TableId TABLE_ID1 = TableId.of((String)"projectId2", (String)"dataset", (String)"table3");
    private static final TableInfo TABLE_INFO4 = TableInfo.newBuilder((TableId)TableId.of((String)"projectId2", (String)"dataset", (String)"table3"), (TableDefinition)EXTERNAL_TABLE_DEFINITION).build();
    private static final ExternalDatasetReference EXTERNAL_DATASET_REFERENCE = ExternalDatasetReference.newBuilder().setExternalSource("source").setConnection("connection").build();
    @Rule
    public MockitoRule rule;
    private BigQuery bigquery;
    private BigQueryOptions mockOptions;
    private Dataset expectedDataset;
    private Dataset dataset;

    @Before
    public void setUp() {
        this.bigquery = (BigQuery)Mockito.mock(BigQuery.class);
        this.mockOptions = (BigQueryOptions)Mockito.mock(BigQueryOptions.class);
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        this.expectedDataset = new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO));
        this.dataset = new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(DATASET_INFO));
    }

    @Test
    public void testBuilder() {
        Dataset builtDataset = new Dataset.Builder(this.bigquery, DATASET_ID).setAcl(ACCESS_RULES).setCreationTime(CREATION_TIME).setDefaultTableLifetime(DEFAULT_TABLE_EXPIRATION).setDescription(DESCRIPTION).setEtag(ETAG).setFriendlyName(FRIENDLY_NAME).setGeneratedId(GENERATED_ID).setLastModified(LAST_MODIFIED).setLocation(LOCATION).setSelfLink(SELF_LINK).setLabels(LABELS).setStorageBillingModel(STORAGE_BILLING_MODEL).setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS).build();
        Assert.assertEquals((Object)DATASET_ID, (Object)builtDataset.getDatasetId());
        Assert.assertEquals(ACCESS_RULES, (Object)builtDataset.getAcl());
        Assert.assertEquals((Object)CREATION_TIME, (Object)builtDataset.getCreationTime());
        Assert.assertEquals((Object)DEFAULT_TABLE_EXPIRATION, (Object)builtDataset.getDefaultTableLifetime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)builtDataset.getDescription());
        Assert.assertEquals((Object)ETAG, (Object)builtDataset.getEtag());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)builtDataset.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)builtDataset.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED, (Object)builtDataset.getLastModified());
        Assert.assertEquals((Object)LOCATION, (Object)builtDataset.getLocation());
        Assert.assertEquals((Object)SELF_LINK, (Object)builtDataset.getSelfLink());
        Assert.assertEquals(LABELS, (Object)builtDataset.getLabels());
        Assert.assertEquals((Object)STORAGE_BILLING_MODEL, (Object)builtDataset.getStorageBillingModel());
        Assert.assertEquals((Object)MAX_TIME_TRAVEL_HOURS, (Object)builtDataset.getMaxTimeTravelHours());
    }

    @Test
    public void testToBuilder() {
        this.compareDataset(this.expectedDataset, this.expectedDataset.toBuilder().build());
    }

    @Test
    public void testExists_True() {
        BigQuery.DatasetOption[] expectedOptions = new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])};
        Mockito.when((Object)this.bigquery.getDataset(DATASET_INFO.getDatasetId(), expectedOptions)).thenReturn((Object)this.expectedDataset);
        Assert.assertTrue((boolean)this.dataset.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getDataset(DATASET_INFO.getDatasetId(), expectedOptions);
    }

    @Test
    public void testExists_False() {
        BigQuery.DatasetOption[] expectedOptions = new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])};
        Mockito.when((Object)this.bigquery.getDataset(DATASET_INFO.getDatasetId(), expectedOptions)).thenReturn(null);
        Assert.assertFalse((boolean)this.dataset.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getDataset(DATASET_INFO.getDatasetId(), expectedOptions);
    }

    @Test
    public void testReload() {
        DatasetInfo updatedInfo = DATASET_INFO.toBuilder().setDescription("Description").build();
        Dataset expectedDataset = new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getDataset(DATASET_INFO.getDatasetId().getDataset(), new BigQuery.DatasetOption[0])).thenReturn((Object)expectedDataset);
        Dataset updatedDataset = this.dataset.reload(new BigQuery.DatasetOption[0]);
        this.compareDataset(expectedDataset, updatedDataset);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getDataset(DATASET_INFO.getDatasetId().getDataset(), new BigQuery.DatasetOption[0]);
    }

    @Test
    public void testReloadNull() {
        Mockito.when((Object)this.bigquery.getDataset(DATASET_INFO.getDatasetId().getDataset(), new BigQuery.DatasetOption[0])).thenReturn(null);
        Assert.assertNull((Object)this.dataset.reload(new BigQuery.DatasetOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getDataset(DATASET_INFO.getDatasetId().getDataset(), new BigQuery.DatasetOption[0]);
    }

    @Test
    public void testReloadWithOptions() {
        DatasetInfo updatedInfo = DATASET_INFO.toBuilder().setDescription("Description").build();
        Dataset expectedDataset = new Dataset(this.bigquery, new DatasetInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getDataset(DATASET_INFO.getDatasetId().getDataset(), new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])})).thenReturn((Object)expectedDataset);
        Dataset updatedDataset = this.dataset.reload(new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])});
        this.compareDataset(expectedDataset, updatedDataset);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getDataset(DATASET_INFO.getDatasetId().getDataset(), new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])});
    }

    @Test
    public void testUpdate() {
        Dataset expectedUpdatedDataset = this.expectedDataset.toBuilder().setDescription("Description").build();
        Mockito.when((Object)this.bigquery.update((DatasetInfo)Mockito.eq((Object)this.expectedDataset), new BigQuery.DatasetOption[0])).thenReturn((Object)expectedUpdatedDataset);
        Dataset actualUpdatedDataset = this.dataset.update(new BigQuery.DatasetOption[0]);
        this.compareDataset(expectedUpdatedDataset, actualUpdatedDataset);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((DatasetInfo)Mockito.eq((Object)this.expectedDataset), new BigQuery.DatasetOption[0]);
    }

    @Test
    public void testUpdateWithOptions() {
        Dataset expectedUpdatedDataset = this.expectedDataset.toBuilder().setDescription("Description").build();
        Mockito.when((Object)this.bigquery.update((DatasetInfo)Mockito.eq((Object)this.expectedDataset), new BigQuery.DatasetOption[]{(BigQuery.DatasetOption)Mockito.eq((Object)BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0]))})).thenReturn((Object)expectedUpdatedDataset);
        Dataset actualUpdatedDataset = this.dataset.update(new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0])});
        this.compareDataset(expectedUpdatedDataset, actualUpdatedDataset);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((DatasetInfo)Mockito.eq((Object)this.expectedDataset), new BigQuery.DatasetOption[]{(BigQuery.DatasetOption)Mockito.eq((Object)BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0]))});
    }

    @Test
    public void testDeleteTrue() {
        Mockito.when((Object)this.bigquery.delete(DATASET_INFO.getDatasetId(), new BigQuery.DatasetDeleteOption[0])).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.dataset.delete(new BigQuery.DatasetDeleteOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(DATASET_INFO.getDatasetId(), new BigQuery.DatasetDeleteOption[0]);
    }

    @Test
    public void testDeleteFalse() {
        Mockito.when((Object)this.bigquery.delete(DATASET_INFO.getDatasetId(), new BigQuery.DatasetDeleteOption[0])).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.dataset.delete(new BigQuery.DatasetDeleteOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(DATASET_INFO.getDatasetId(), new BigQuery.DatasetDeleteOption[0]);
    }

    @Test
    public void testList() {
        ImmutableList tableResults = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO1)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO2)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO3)));
        PageImpl expectedPage = new PageImpl(null, "c", (Iterable)tableResults);
        Mockito.when((Object)this.bigquery.listTables(DATASET_INFO.getDatasetId(), new BigQuery.TableListOption[0])).thenReturn((Object)expectedPage);
        Page tablePage = this.dataset.list(new BigQuery.TableListOption[0]);
        Assert.assertArrayEquals((Object[])tableResults.toArray(), (Object[])Iterables.toArray((Iterable)tablePage.getValues(), Table.class));
        Assert.assertEquals((Object)expectedPage.getNextPageToken(), (Object)tablePage.getNextPageToken());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).listTables(DATASET_INFO.getDatasetId(), new BigQuery.TableListOption[0]);
    }

    @Test
    public void testListWithOptions() {
        ImmutableList tableResults = ImmutableList.of((Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO1)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO2)), (Object)new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO3)));
        PageImpl expectedPage = new PageImpl(null, "c", (Iterable)tableResults);
        Mockito.when((Object)this.bigquery.listTables(DATASET_INFO.getDatasetId(), new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)10L)})).thenReturn((Object)expectedPage);
        Page tablePage = this.dataset.list(new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)10L)});
        Assert.assertArrayEquals((Object[])tableResults.toArray(), (Object[])Iterables.toArray((Iterable)tablePage.getValues(), Table.class));
        Assert.assertEquals((Object)expectedPage.getNextPageToken(), (Object)tablePage.getNextPageToken());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).listTables(DATASET_INFO.getDatasetId(), new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)10L)});
    }

    @Test
    public void testGet() {
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO1));
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO1.getTableId(), new BigQuery.TableOption[0])).thenReturn((Object)expectedTable);
        Table table = this.dataset.get(TABLE_INFO1.getTableId().getTable(), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)expectedTable, (Object)table);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO1.getTableId(), new BigQuery.TableOption[0]);
    }

    @Test
    public void testGetTableWithNewProjectId() {
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO4));
        Mockito.when((Object)this.bigquery.getTable(TABLE_ID1, null)).thenReturn((Object)expectedTable);
        Table table = this.bigquery.getTable(TABLE_ID1, null);
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)table.getTableId().getProject(), (Object)NEW_PROJECT_ID);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_ID1, null);
    }

    @Test
    public void testGetNull() {
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO1.getTableId(), new BigQuery.TableOption[0])).thenReturn(null);
        Assert.assertNull((Object)this.dataset.get(TABLE_INFO1.getTableId().getTable(), new BigQuery.TableOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO1.getTableId(), new BigQuery.TableOption[0]);
    }

    @Test
    public void testGetWithOptions() {
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO1));
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO1.getTableId(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])})).thenReturn((Object)expectedTable);
        Table table = this.dataset.get(TABLE_INFO1.getTableId().getTable(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)expectedTable, (Object)table);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO1.getTableId(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
    }

    @Test
    public void testCreateTable() {
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO1));
        Mockito.when((Object)this.bigquery.create(TABLE_INFO1, new BigQuery.TableOption[0])).thenReturn((Object)expectedTable);
        Table table = this.dataset.create(TABLE_INFO1.getTableId().getTable(), (TableDefinition)TABLE_DEFINITION, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)expectedTable, (Object)table);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(TABLE_INFO1, new BigQuery.TableOption[0]);
    }

    @Test
    public void testCreateTableWithOptions() {
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO1));
        Mockito.when((Object)this.bigquery.create(TABLE_INFO1, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])})).thenReturn((Object)expectedTable);
        Table table = this.dataset.create(TABLE_INFO1.getTableId().getTable(), (TableDefinition)TABLE_DEFINITION, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        Assert.assertEquals((Object)expectedTable, (Object)table);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(TABLE_INFO1, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
    }

    @Test
    public void testBigQuery() {
        Assert.assertSame((Object)this.bigquery, (Object)this.expectedDataset.getBigQuery());
    }

    @Test
    public void testToAndFromPb() {
        this.compareDataset(this.expectedDataset, Dataset.fromPb((BigQuery)this.bigquery, (com.google.api.services.bigquery.model.Dataset)this.expectedDataset.toPb()));
    }

    @Test
    public void testExternalDatasetReference() {
        Dataset datasetWithExternalDatasetReference = new Dataset.Builder(this.bigquery, DATASET_ID).setAcl(ACCESS_RULES).setCreationTime(CREATION_TIME).setDefaultTableLifetime(DEFAULT_TABLE_EXPIRATION).setDescription(DESCRIPTION).setEtag(ETAG).setFriendlyName(FRIENDLY_NAME).setGeneratedId(GENERATED_ID).setLastModified(LAST_MODIFIED).setLocation(LOCATION).setSelfLink(SELF_LINK).setLabels(LABELS).setExternalDatasetReference(EXTERNAL_DATASET_REFERENCE).setStorageBillingModel(STORAGE_BILLING_MODEL).setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS).build();
        Assert.assertEquals((Object)EXTERNAL_DATASET_REFERENCE, (Object)datasetWithExternalDatasetReference.getExternalDatasetReference());
        this.compareDataset(datasetWithExternalDatasetReference, datasetWithExternalDatasetReference.toBuilder().build());
    }

    private void compareDataset(Dataset expected, Dataset value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareDatasetInfo((DatasetInfo)expected, (DatasetInfo)value);
        Assert.assertEquals((Object)expected.getBigQuery().getOptions(), (Object)value.getBigQuery().getOptions());
    }

    private void compareDatasetInfo(DatasetInfo expected, DatasetInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getDatasetId(), (Object)value.getDatasetId());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getFriendlyName(), (Object)value.getFriendlyName());
        Assert.assertEquals((Object)expected.getGeneratedId(), (Object)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getLocation(), (Object)value.getLocation());
        Assert.assertEquals((Object)expected.getSelfLink(), (Object)value.getSelfLink());
        Assert.assertEquals((Object)expected.getAcl(), (Object)value.getAcl());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getDefaultTableLifetime(), (Object)value.getDefaultTableLifetime());
        Assert.assertEquals((Object)expected.getLastModified(), (Object)value.getLastModified());
        Assert.assertEquals((Object)expected.getExternalDatasetReference(), (Object)value.getExternalDatasetReference());
        Assert.assertEquals((Object)expected.getStorageBillingModel(), (Object)value.getStorageBillingModel());
        Assert.assertEquals((Object)expected.getMaxTimeTravelHours(), (Object)value.getMaxTimeTravelHours());
    }
}

