/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DatastoreBackupOptionsTest {
    private static final List<String> PROJECTION_FIELDS = ImmutableList.of((Object)"field1", (Object)"field2");
    private static final DatastoreBackupOptions BACKUP_OPTIONS = DatastoreBackupOptions.newBuilder().setProjectionFields(PROJECTION_FIELDS).build();

    @Test
    public void testToBuilder() {
        this.compareDatastoreBackupOptions(BACKUP_OPTIONS, BACKUP_OPTIONS.toBuilder().build());
        ImmutableList fields = ImmutableList.of((Object)"field1", (Object)"field2");
        DatastoreBackupOptions backupOptions = BACKUP_OPTIONS.toBuilder().setProjectionFields((List)fields).build();
        Assert.assertEquals((Object)fields, (Object)backupOptions.getProjectionFields());
        backupOptions = backupOptions.toBuilder().setProjectionFields(PROJECTION_FIELDS).build();
        this.compareDatastoreBackupOptions(BACKUP_OPTIONS, backupOptions);
    }

    @Test
    public void testToBuilderIncomplete() {
        DatastoreBackupOptions backupOptions = DatastoreBackupOptions.newBuilder().setProjectionFields(PROJECTION_FIELDS).build();
        Assert.assertEquals((Object)backupOptions, (Object)backupOptions.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"DATASTORE_BACKUP", (Object)BACKUP_OPTIONS.getType());
        Assert.assertEquals(PROJECTION_FIELDS, (Object)BACKUP_OPTIONS.getProjectionFields());
    }

    private void compareDatastoreBackupOptions(DatastoreBackupOptions expected, DatastoreBackupOptions value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getProjectionFields(), (Object)value.getProjectionFields());
    }
}

