/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.DmlStatistics;
import com.google.cloud.bigquery.DmlStats;
import org.junit.Assert;
import org.junit.Test;

public class DmlStatsTest {
    private static final Long DELETED_ROW_COUNT = 10L;
    private static final Long INSERTED_ROW_COUNT = 20L;
    private static final Long UPDATED_ROW_COUNT = 30L;
    private static final DmlStats DML_STATS = DmlStats.newBuilder().setDeletedRowCount(DELETED_ROW_COUNT).setInsertedRowCount(INSERTED_ROW_COUNT).setUpdatedRowCount(UPDATED_ROW_COUNT).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)DELETED_ROW_COUNT, (Object)DML_STATS.getDeletedRowCount());
        Assert.assertEquals((Object)UPDATED_ROW_COUNT, (Object)DML_STATS.getUpdatedRowCount());
        Assert.assertEquals((Object)INSERTED_ROW_COUNT, (Object)DML_STATS.getInsertedRowCount());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareDmlStats(DML_STATS, DmlStats.fromPb((DmlStatistics)DML_STATS.toPb()));
    }

    private void compareDmlStats(DmlStats expected, DmlStats actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)expected.hashCode(), (long)actual.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((Object)expected.getDeletedRowCount(), (Object)actual.getDeletedRowCount());
        Assert.assertEquals((Object)expected.getInsertedRowCount(), (Object)actual.getInsertedRowCount());
        Assert.assertEquals((Object)expected.getUpdatedRowCount(), (Object)actual.getUpdatedRowCount());
    }
}

