/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.ExternalDatasetReference;
import org.junit.Assert;
import org.junit.Test;

public class ExternalDatasetReferenceTest {
    private static final String EXTERNAL_SOURCE = "test_source";
    private static final String CONNECTION = "test_connection";
    private static final ExternalDatasetReference EXTERNAL_DATASET_REFERENCE = ExternalDatasetReference.newBuilder().setExternalSource("test_source").setConnection("test_connection").build();

    @Test
    public void testToBuilder() {
        this.compareExternalDatasetReference(EXTERNAL_DATASET_REFERENCE, EXTERNAL_DATASET_REFERENCE.toBuilder().build());
        ExternalDatasetReference externalDatasetReference = EXTERNAL_DATASET_REFERENCE.toBuilder().setExternalSource("test_source2").build();
        Assert.assertEquals((Object)"test_source2", (Object)externalDatasetReference.getExternalSource());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)EXTERNAL_SOURCE, (Object)EXTERNAL_DATASET_REFERENCE.getExternalSource());
        Assert.assertEquals((Object)CONNECTION, (Object)EXTERNAL_DATASET_REFERENCE.getConnection());
        ExternalDatasetReference externalDatasetReference = ExternalDatasetReference.newBuilder().setExternalSource(EXTERNAL_SOURCE).setConnection(CONNECTION).build();
        Assert.assertEquals((Object)EXTERNAL_DATASET_REFERENCE, (Object)externalDatasetReference);
    }

    @Test
    public void testToAndFromPb() {
        ExternalDatasetReference externalDatasetReference = EXTERNAL_DATASET_REFERENCE.toBuilder().build();
        Assert.assertTrue((boolean)(ExternalDatasetReference.fromPb((com.google.api.services.bigquery.model.ExternalDatasetReference)externalDatasetReference.toPb()) instanceof ExternalDatasetReference));
        this.compareExternalDatasetReference(externalDatasetReference, ExternalDatasetReference.fromPb((com.google.api.services.bigquery.model.ExternalDatasetReference)externalDatasetReference.toPb()));
    }

    private void compareExternalDatasetReference(ExternalDatasetReference expected, ExternalDatasetReference value) {
        Assert.assertEquals((Object)expected.getExternalSource(), (Object)value.getExternalSource());
        Assert.assertEquals((Object)expected.getConnection(), (Object)value.getConnection());
    }
}

