/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.AvroOptions;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.ParquetOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ExternalTableDefinitionTest {
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final List<String> DECIMAL_TARGET_TYPES = ImmutableList.of((Object)"NUMERIC", (Object)"BIGNUMERIC", (Object)"STRING");
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final String CONNECTION_ID = "123456789";
    private static final Boolean AUTODETECT = true;
    private static final AvroOptions AVRO_OPTIONS = AvroOptions.newBuilder().build();
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().build();
    private static final ParquetOptions PARQUET_OPTIONS = ParquetOptions.newBuilder().build();
    private static final HivePartitioningOptions HIVE_PARTITIONING_OPTIONS = HivePartitioningOptions.newBuilder().setMode("AUTO").setSourceUriPrefix(SOURCE_URIS.get(0)).build();
    private static final String OBJECT_METADATA = "SIMPLE";
    private static final String METADATA_CACHE_MODE = "AUTOMATIC";
    private static final String MAX_STALENESS = "INTERVAL 15 MINUTE";
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setFileSetSpecType("FILE_SET_SPEC_TYPE_FILE_SYSTEM_MATCH").setDecimalTargetTypes(DECIMAL_TARGET_TYPES).setCompression("GZIP").setConnectionId("123456789").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setAutodetect(AUTODETECT).setHivePartitioningOptions(HIVE_PARTITIONING_OPTIONS).setObjectMetadata("SIMPLE").setMetadataCacheMode("AUTOMATIC").setMaxStaleness("INTERVAL 15 MINUTE").build();
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION_AVRO = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)AVRO_OPTIONS).build();
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION_PARQUET = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)PARQUET_OPTIONS).build();

    @Test
    public void testToBuilder() {
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION, EXTERNAL_TABLE_DEFINITION.toBuilder().build());
        ExternalTableDefinition externalTableDefinition = EXTERNAL_TABLE_DEFINITION.toBuilder().setCompression("NONE").setConnectionId("00000").build();
        Assert.assertEquals((Object)"NONE", (Object)externalTableDefinition.getCompression());
        Assert.assertEquals((Object)"00000", (Object)externalTableDefinition.getConnectionId());
        externalTableDefinition = externalTableDefinition.toBuilder().setCompression(COMPRESSION).setConnectionId(CONNECTION_ID).build();
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION, externalTableDefinition);
    }

    @Test
    public void testToBuilderIncomplete() {
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.of(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)FormatOptions.json());
        Assert.assertEquals((Object)externalTableDefinition, (Object)externalTableDefinition.toBuilder().build());
    }

    @Test
    public void testTypeNullPointerException() {
        try {
            EXTERNAL_TABLE_DEFINITION.toBuilder().setType(null).build();
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TableDefinition.Type.EXTERNAL, (Object)EXTERNAL_TABLE_DEFINITION.getType());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTERNAL_TABLE_DEFINITION.getCompression());
        Assert.assertEquals((Object)CONNECTION_ID, (Object)EXTERNAL_TABLE_DEFINITION.getConnectionId());
        Assert.assertEquals((Object)AVRO_OPTIONS, (Object)EXTERNAL_TABLE_DEFINITION_AVRO.getFormatOptions());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)EXTERNAL_TABLE_DEFINITION.getFormatOptions());
        Assert.assertEquals((Object)IGNORE_UNKNOWN_VALUES, (Object)EXTERNAL_TABLE_DEFINITION.ignoreUnknownValues());
        Assert.assertEquals((Object)MAX_BAD_RECORDS, (Object)EXTERNAL_TABLE_DEFINITION.getMaxBadRecords());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)EXTERNAL_TABLE_DEFINITION.getSchema());
        Assert.assertEquals(SOURCE_URIS, (Object)EXTERNAL_TABLE_DEFINITION.getSourceUris());
        Assert.assertEquals(DECIMAL_TARGET_TYPES, (Object)EXTERNAL_TABLE_DEFINITION.getDecimalTargetTypes());
        Assert.assertEquals((Object)AUTODETECT, (Object)EXTERNAL_TABLE_DEFINITION.getAutodetect());
        Assert.assertEquals((Object)HIVE_PARTITIONING_OPTIONS, (Object)EXTERNAL_TABLE_DEFINITION.getHivePartitioningOptions());
        Assert.assertNotEquals((Object)EXTERNAL_TABLE_DEFINITION, (Object)TableDefinition.Type.EXTERNAL);
    }

    @Test
    public void testToAndFromPb() {
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION, ExternalTableDefinition.fromPb((Table)EXTERNAL_TABLE_DEFINITION.toPb()));
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).build();
        this.compareExternalTableDefinition(externalTableDefinition, ExternalTableDefinition.fromPb((Table)externalTableDefinition.toPb()));
    }

    @Test
    public void testToAndFromPbParquet() {
        this.compareExternalTableDefinition(EXTERNAL_TABLE_DEFINITION_PARQUET, ExternalTableDefinition.fromPb((Table)EXTERNAL_TABLE_DEFINITION_PARQUET.toPb()));
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)PARQUET_OPTIONS).build();
        this.compareExternalTableDefinition(externalTableDefinition, ExternalTableDefinition.fromPb((Table)externalTableDefinition.toPb()));
    }

    private void compareExternalTableDefinition(ExternalTableDefinition expected, ExternalTableDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getFileSetSpecType(), (Object)value.getFileSetSpecType());
        Assert.assertEquals((Object)expected.getDecimalTargetTypes(), (Object)value.getDecimalTargetTypes());
        Assert.assertEquals((Object)expected.getCompression(), (Object)value.getCompression());
        Assert.assertEquals((Object)expected.getConnectionId(), (Object)value.getConnectionId());
        Assert.assertEquals((Object)expected.getFormatOptions(), (Object)value.getFormatOptions());
        Assert.assertEquals((Object)expected.ignoreUnknownValues(), (Object)value.ignoreUnknownValues());
        Assert.assertEquals((Object)expected.getMaxBadRecords(), (Object)value.getMaxBadRecords());
        Assert.assertEquals((Object)expected.getSchema(), (Object)value.getSchema());
        Assert.assertEquals((Object)expected.getSourceUris(), (Object)value.getSourceUris());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.getAutodetect(), (Object)value.getAutodetect());
        Assert.assertEquals((Object)expected.getHivePartitioningOptions(), (Object)value.getHivePartitioningOptions());
        Assert.assertEquals((Object)expected.getObjectMetadata(), (Object)value.getObjectMetadata());
        Assert.assertEquals((Object)expected.getMetadataCacheMode(), (Object)value.getMetadataCacheMode());
        Assert.assertEquals((Object)expected.getMaxStaleness(), (Object)value.getMaxStaleness());
    }
}

