/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.TableId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ExtractJobConfigurationTest {
    private static final String TEST_PROJECT_ID = "test-project-id";
    private static final List<String> DESTINATION_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final String DESTINATION_URI = "uri1";
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final ModelId MODEL_ID = ModelId.of((String)"dataset", (String)"model");
    private static final String FIELD_DELIMITER = ",";
    private static final String FORMAT = "CSV";
    private static final String AVRO_FORMAT = "AVRO";
    private static final String JSON_FORMAT = "NEWLINE_DELIMITED_JSON";
    private static final Boolean PRINT_HEADER = true;
    private static final String COMPRESSION = "GZIP";
    private static final Boolean USEAVROLOGICALTYPES = true;
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"test-job-name", (Object)"test-extract-job");
    private static final Long TIMEOUT = 10L;
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION = ExtractJobConfiguration.newBuilder((TableId)TABLE_ID, DESTINATION_URIS).setPrintHeader(PRINT_HEADER).setFieldDelimiter(",").setCompression("GZIP").setFormat("CSV").setLabels(LABELS).setJobTimeoutMs(TIMEOUT).build();
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION_ONE_URI = ExtractJobConfiguration.newBuilder((TableId)TABLE_ID, (String)"uri1").setPrintHeader(PRINT_HEADER).setFieldDelimiter(",").setCompression("GZIP").setFormat("CSV").setLabels(LABELS).setJobTimeoutMs(TIMEOUT).build();
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION_AVRO = ExtractJobConfiguration.newBuilder((TableId)TABLE_ID, (String)"uri1").setPrintHeader(PRINT_HEADER).setFieldDelimiter(",").setCompression("GZIP").setFormat("AVRO").setUseAvroLogicalTypes(USEAVROLOGICALTYPES).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).build();
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION_MODEL = ExtractJobConfiguration.newBuilder((ModelId)MODEL_ID, DESTINATION_URIS).setPrintHeader(PRINT_HEADER).setFieldDelimiter(",").setCompression("GZIP").setFormat("CSV").setUseAvroLogicalTypes(USEAVROLOGICALTYPES).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).build();

    @Test
    public void testToBuilder() {
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION, EXTRACT_CONFIGURATION.toBuilder().build());
        ExtractJobConfiguration job = EXTRACT_CONFIGURATION.toBuilder().setSourceTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)job.getSourceTable().getTable());
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION_MODEL, EXTRACT_CONFIGURATION_MODEL.toBuilder().build());
        ExtractJobConfiguration modelJob = EXTRACT_CONFIGURATION_MODEL.toBuilder().setSourceModel(ModelId.of((String)"dataset", (String)"newModel")).build();
        Assert.assertEquals((Object)"newModel", (Object)modelJob.getSourceModel().getModel());
        job = job.toBuilder().setSourceTable(TABLE_ID).build();
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION, job);
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION_AVRO, EXTRACT_CONFIGURATION_AVRO.toBuilder().build());
        ExtractJobConfiguration avroJob = EXTRACT_CONFIGURATION_AVRO.toBuilder().setSourceTable(TableId.of((String)"dataset", (String)"avroTable")).build();
        Assert.assertEquals((Object)"avroTable", (Object)avroJob.getSourceTable().getTable());
        avroJob = avroJob.toBuilder().setSourceTable(TABLE_ID).build();
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION_AVRO, avroJob);
    }

    @Test
    public void testOf() {
        ExtractJobConfiguration job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.getSourceTable());
        Assert.assertEquals(DESTINATION_URIS, (Object)job.getDestinationUris());
        job = ExtractJobConfiguration.of((TableId)TABLE_ID, (String)DESTINATION_URI);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.getSourceTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)job.getDestinationUris());
        job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS, (String)JSON_FORMAT);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.getSourceTable());
        Assert.assertEquals(DESTINATION_URIS, (Object)job.getDestinationUris());
        Assert.assertEquals((Object)JSON_FORMAT, (Object)job.getFormat());
        job = ExtractJobConfiguration.of((TableId)TABLE_ID, (String)DESTINATION_URI, (String)JSON_FORMAT);
        Assert.assertEquals((Object)TABLE_ID, (Object)job.getSourceTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)job.getDestinationUris());
        Assert.assertEquals((Object)JSON_FORMAT, (Object)job.getFormat());
        ExtractJobConfiguration modelJob = ExtractJobConfiguration.of((ModelId)MODEL_ID, DESTINATION_URIS);
        Assert.assertEquals((Object)MODEL_ID, (Object)modelJob.getSourceModel());
        Assert.assertEquals(DESTINATION_URIS, (Object)modelJob.getDestinationUris());
        modelJob = ExtractJobConfiguration.of((ModelId)MODEL_ID, (String)DESTINATION_URI);
        Assert.assertEquals((Object)MODEL_ID, (Object)modelJob.getSourceModel());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)modelJob.getDestinationUris());
        modelJob = ExtractJobConfiguration.of((ModelId)MODEL_ID, DESTINATION_URIS, (String)JSON_FORMAT);
        Assert.assertEquals((Object)MODEL_ID, (Object)modelJob.getSourceModel());
        Assert.assertEquals(DESTINATION_URIS, (Object)modelJob.getDestinationUris());
        Assert.assertEquals((Object)JSON_FORMAT, (Object)modelJob.getFormat());
        modelJob = ExtractJobConfiguration.of((ModelId)MODEL_ID, (String)DESTINATION_URI, (String)JSON_FORMAT);
        Assert.assertEquals((Object)MODEL_ID, (Object)modelJob.getSourceModel());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)modelJob.getDestinationUris());
        Assert.assertEquals((Object)JSON_FORMAT, (Object)modelJob.getFormat());
    }

    @Test
    public void testToBuilderIncomplete() {
        ExtractJobConfiguration job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS);
        this.compareExtractJobConfiguration(job, job.toBuilder().build());
        ExtractJobConfiguration modelJob = ExtractJobConfiguration.of((ModelId)MODEL_ID, DESTINATION_URIS);
        this.compareExtractJobConfiguration(modelJob, modelJob.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)EXTRACT_CONFIGURATION.getSourceTable());
        Assert.assertEquals(DESTINATION_URIS, (Object)EXTRACT_CONFIGURATION.getDestinationUris());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)EXTRACT_CONFIGURATION.getFieldDelimiter());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTRACT_CONFIGURATION.getCompression());
        Assert.assertEquals((Object)PRINT_HEADER, (Object)EXTRACT_CONFIGURATION.printHeader());
        Assert.assertEquals((Object)FORMAT, (Object)EXTRACT_CONFIGURATION.getFormat());
        Assert.assertEquals(LABELS, (Object)EXTRACT_CONFIGURATION.getLabels());
        Assert.assertEquals((Object)TIMEOUT, (Object)EXTRACT_CONFIGURATION.getJobTimeoutMs());
        Assert.assertEquals((Object)TABLE_ID, (Object)EXTRACT_CONFIGURATION_ONE_URI.getSourceTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)EXTRACT_CONFIGURATION_ONE_URI.getDestinationUris());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)EXTRACT_CONFIGURATION_ONE_URI.getFieldDelimiter());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTRACT_CONFIGURATION_ONE_URI.getCompression());
        Assert.assertEquals((Object)PRINT_HEADER, (Object)EXTRACT_CONFIGURATION_ONE_URI.printHeader());
        Assert.assertEquals((Object)FORMAT, (Object)EXTRACT_CONFIGURATION_ONE_URI.getFormat());
        Assert.assertEquals(LABELS, (Object)EXTRACT_CONFIGURATION_ONE_URI.getLabels());
        Assert.assertEquals((Object)TIMEOUT, (Object)EXTRACT_CONFIGURATION_ONE_URI.getJobTimeoutMs());
        Assert.assertEquals((Object)ImmutableList.of((Object)DESTINATION_URI), (Object)EXTRACT_CONFIGURATION_AVRO.getDestinationUris());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)EXTRACT_CONFIGURATION_AVRO.getFieldDelimiter());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTRACT_CONFIGURATION_AVRO.getCompression());
        Assert.assertEquals((Object)PRINT_HEADER, (Object)EXTRACT_CONFIGURATION_AVRO.printHeader());
        Assert.assertEquals((Object)AVRO_FORMAT, (Object)EXTRACT_CONFIGURATION_AVRO.getFormat());
        Assert.assertEquals((Object)USEAVROLOGICALTYPES, (Object)EXTRACT_CONFIGURATION_AVRO.getUseAvroLogicalTypes());
        Assert.assertEquals(LABELS, (Object)EXTRACT_CONFIGURATION_AVRO.getLabels());
        Assert.assertEquals((Object)TIMEOUT, (Object)EXTRACT_CONFIGURATION_AVRO.getJobTimeoutMs());
        Assert.assertEquals((Object)MODEL_ID, (Object)EXTRACT_CONFIGURATION_MODEL.getSourceModel());
        Assert.assertEquals(DESTINATION_URIS, (Object)EXTRACT_CONFIGURATION_MODEL.getDestinationUris());
        Assert.assertEquals((Object)FIELD_DELIMITER, (Object)EXTRACT_CONFIGURATION_MODEL.getFieldDelimiter());
        Assert.assertEquals((Object)COMPRESSION, (Object)EXTRACT_CONFIGURATION_MODEL.getCompression());
        Assert.assertEquals((Object)PRINT_HEADER, (Object)EXTRACT_CONFIGURATION_MODEL.printHeader());
        Assert.assertEquals((Object)FORMAT, (Object)EXTRACT_CONFIGURATION_MODEL.getFormat());
        Assert.assertEquals(LABELS, (Object)EXTRACT_CONFIGURATION_MODEL.getLabels());
        Assert.assertEquals((Object)TIMEOUT, (Object)EXTRACT_CONFIGURATION_MODEL.getJobTimeoutMs());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)EXTRACT_CONFIGURATION.toPb().getExtract());
        Assert.assertNull((Object)EXTRACT_CONFIGURATION.toPb().getCopy());
        Assert.assertNull((Object)EXTRACT_CONFIGURATION.toPb().getLoad());
        Assert.assertNull((Object)EXTRACT_CONFIGURATION.toPb().getQuery());
        Assert.assertNotNull((Object)EXTRACT_CONFIGURATION.toPb().getLabels());
        Assert.assertNotNull((Object)EXTRACT_CONFIGURATION.toPb().getJobTimeoutMs());
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION, ExtractJobConfiguration.fromPb((JobConfiguration)EXTRACT_CONFIGURATION.toPb()));
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION_ONE_URI, ExtractJobConfiguration.fromPb((JobConfiguration)EXTRACT_CONFIGURATION_ONE_URI.toPb()));
        this.compareExtractJobConfiguration(EXTRACT_CONFIGURATION_AVRO, ExtractJobConfiguration.fromPb((JobConfiguration)EXTRACT_CONFIGURATION_AVRO.toPb()));
        ExtractJobConfiguration job = ExtractJobConfiguration.of((TableId)TABLE_ID, DESTINATION_URIS);
        this.compareExtractJobConfiguration(job, ExtractJobConfiguration.fromPb((JobConfiguration)job.toPb()));
        ExtractJobConfiguration modelJob = ExtractJobConfiguration.of((ModelId)MODEL_ID, DESTINATION_URIS);
        this.compareExtractJobConfiguration(modelJob, ExtractJobConfiguration.fromPb((JobConfiguration)modelJob.toPb()));
    }

    @Test
    public void testSetProjectId() {
        ExtractJobConfiguration configuration = EXTRACT_CONFIGURATION.setProjectId(TEST_PROJECT_ID);
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getSourceTable().getProject());
        ExtractJobConfiguration modelConfiguration = EXTRACT_CONFIGURATION_MODEL.setProjectId(TEST_PROJECT_ID);
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)modelConfiguration.getSourceModel().getProject());
    }

    @Test
    public void testSetProjectIdDoNotOverride() {
        ExtractJobConfiguration configuration = EXTRACT_CONFIGURATION.toBuilder().setSourceTable(TABLE_ID.setProjectId(TEST_PROJECT_ID)).build().setProjectId("do-not-update");
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getSourceTable().getProject());
        ExtractJobConfiguration modelConfiguration = EXTRACT_CONFIGURATION_MODEL.toBuilder().setSourceModel(MODEL_ID.setProjectId(TEST_PROJECT_ID)).build().setProjectId("do-not-update");
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)modelConfiguration.getSourceModel().getProject());
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)JobConfiguration.Type.EXTRACT, (Object)EXTRACT_CONFIGURATION.getType());
        Assert.assertEquals((Object)JobConfiguration.Type.EXTRACT, (Object)EXTRACT_CONFIGURATION_ONE_URI.getType());
        Assert.assertEquals((Object)JobConfiguration.Type.EXTRACT, (Object)EXTRACT_CONFIGURATION_AVRO.getType());
        Assert.assertEquals((Object)JobConfiguration.Type.EXTRACT, (Object)EXTRACT_CONFIGURATION_MODEL.getType());
    }

    private void compareExtractJobConfiguration(ExtractJobConfiguration expected, ExtractJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getSourceTable(), (Object)value.getSourceTable());
        Assert.assertEquals((Object)expected.getSourceModel(), (Object)value.getSourceModel());
        Assert.assertEquals((Object)expected.getDestinationUris(), (Object)value.getDestinationUris());
        Assert.assertEquals((Object)expected.getCompression(), (Object)value.getCompression());
        Assert.assertEquals((Object)expected.printHeader(), (Object)value.printHeader());
        Assert.assertEquals((Object)expected.getFieldDelimiter(), (Object)value.getFieldDelimiter());
        Assert.assertEquals((Object)expected.getFormat(), (Object)value.getFormat());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getJobTimeoutMs(), (Object)value.getJobTimeoutMs());
    }
}

