/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FieldListTest {
    private static final String FIELD_NAME1 = "StringField";
    private static final String FIELD_NAME2 = "IntegerField";
    private static final String FIELD_NAME3 = "RecordField";
    private static final String FIELD_NAME_CASE_INSENSITIVE1 = "stringfield";
    private static final String FIELD_NAME_CASE_INSENSITIVE2 = "integerfield";
    private static final String FIELD_NAME_CASE_INSENSITIVE3 = "recordfield";
    private static final String FIELD_NAME_CASE_INSENSITIVE4 = "stRingfiEld";
    private static final String FIELD_NAME_CASE_INSENSITIVE5 = "inTeGerField";
    private static final String FIELD_NAME_CASE_INSENSITIVE6 = "recOrdfieLd";
    private static final String FIELD_NAME4 = "NonExistentField";
    private static final LegacySQLTypeName FIELD_TYPE1 = LegacySQLTypeName.STRING;
    private static final LegacySQLTypeName FIELD_TYPE2 = LegacySQLTypeName.INTEGER;
    private static final LegacySQLTypeName FIELD_TYPE3 = LegacySQLTypeName.RECORD;
    private static final Field.Mode FIELD_MODE1 = Field.Mode.NULLABLE;
    private static final Field.Mode FIELD_MODE2 = Field.Mode.REPEATED;
    private static final Field.Mode FIELD_MODE3 = Field.Mode.REQUIRED;
    private static final String FIELD_DESCRIPTION1 = "FieldDescription1";
    private static final String FIELD_DESCRIPTION2 = "FieldDescription2";
    private static final String FIELD_DESCRIPTION3 = "FieldDescription3";
    private final Field fieldSchema1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)FIELD_TYPE1, (Field[])new Field[0]).setMode(FIELD_MODE1).setDescription("FieldDescription1").build();
    private final Field fieldSchema2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)FIELD_TYPE2, (Field[])new Field[0]).setMode(FIELD_MODE2).setDescription("FieldDescription2").build();
    private final Field fieldSchema3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)FIELD_TYPE3, (Field[])new Field[]{this.fieldSchema1, this.fieldSchema2}).setMode(FIELD_MODE3).setDescription("FieldDescription3").build();
    private final FieldList fieldsSchema = FieldList.of((Field[])new Field[]{this.fieldSchema1, this.fieldSchema2, this.fieldSchema3});

    @Test
    public void testGetByName() {
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldsSchema.get(FIELD_NAME1));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldsSchema.get(FIELD_NAME2));
        Assert.assertEquals((Object)this.fieldSchema3, (Object)this.fieldsSchema.get(FIELD_NAME3));
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldsSchema.get(FIELD_NAME_CASE_INSENSITIVE1));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldsSchema.get(FIELD_NAME_CASE_INSENSITIVE2));
        Assert.assertEquals((Object)this.fieldSchema3, (Object)this.fieldsSchema.get(FIELD_NAME_CASE_INSENSITIVE3));
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldsSchema.get(FIELD_NAME_CASE_INSENSITIVE4));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldsSchema.get(FIELD_NAME_CASE_INSENSITIVE5));
        Assert.assertEquals((Object)this.fieldSchema3, (Object)this.fieldsSchema.get(FIELD_NAME_CASE_INSENSITIVE6));
        Assert.assertEquals((long)3L, (long)this.fieldsSchema.size());
        IllegalArgumentException exception = null;
        try {
            this.fieldsSchema.get(FIELD_NAME4);
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
    }

    @Test
    public void testGetByIndex() {
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldsSchema.get(0));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldsSchema.get(1));
        Assert.assertEquals((Object)this.fieldSchema3, (Object)this.fieldsSchema.get(2));
        Assert.assertEquals((long)3L, (long)this.fieldsSchema.size());
        IndexOutOfBoundsException exception = null;
        try {
            this.fieldsSchema.get(4);
        }
        catch (IndexOutOfBoundsException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
    }

    @Test
    public void testGetRecordSchema() {
        Assert.assertEquals((long)2L, (long)this.fieldSchema3.getSubFields().size());
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldSchema3.getSubFields().get(FIELD_NAME1));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldSchema3.getSubFields().get(FIELD_NAME2));
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldSchema3.getSubFields().get(FIELD_NAME_CASE_INSENSITIVE1));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldSchema3.getSubFields().get(FIELD_NAME_CASE_INSENSITIVE2));
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldSchema3.getSubFields().get(FIELD_NAME_CASE_INSENSITIVE4));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldSchema3.getSubFields().get(FIELD_NAME_CASE_INSENSITIVE5));
        Assert.assertEquals((long)0L, (long)this.fieldSchema3.getSubFields().getIndex(FIELD_NAME1));
        Assert.assertEquals((long)1L, (long)this.fieldSchema3.getSubFields().getIndex(FIELD_NAME2));
        Assert.assertEquals((long)0L, (long)this.fieldSchema3.getSubFields().getIndex(FIELD_NAME_CASE_INSENSITIVE1));
        Assert.assertEquals((long)1L, (long)this.fieldSchema3.getSubFields().getIndex(FIELD_NAME_CASE_INSENSITIVE2));
        Assert.assertEquals((long)0L, (long)this.fieldSchema3.getSubFields().getIndex(FIELD_NAME_CASE_INSENSITIVE4));
        Assert.assertEquals((long)1L, (long)this.fieldSchema3.getSubFields().getIndex(FIELD_NAME_CASE_INSENSITIVE5));
        Assert.assertEquals((Object)this.fieldSchema1, (Object)this.fieldSchema3.getSubFields().get(0));
        Assert.assertEquals((Object)this.fieldSchema2, (Object)this.fieldSchema3.getSubFields().get(1));
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertEquals((Object)this.fieldsSchema, (Object)FieldList.of((Field[])new Field[]{this.fieldSchema1, this.fieldSchema2, this.fieldSchema3}));
        Assert.assertNotEquals((Object)this.fieldsSchema, (Object)FieldList.of((Field[])new Field[]{this.fieldSchema1, this.fieldSchema3}));
        Assert.assertEquals((Object)this.fieldsSchema, (Object)FieldList.fromPb((List)this.fieldsSchema.toPb()));
    }
}

