/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class FieldTest {
    private static final String FIELD_NAME1 = "StringField";
    private static final String FIELD_NAME2 = "IntegerField";
    private static final String FIELD_NAME3 = "RecordField";
    private static final String FIELD_NAME4 = "NullModeField";
    private static final String FIELD_NAME5 = "NullModeField2";
    private static final LegacySQLTypeName FIELD_TYPE1 = LegacySQLTypeName.STRING;
    private static final LegacySQLTypeName FIELD_TYPE2 = LegacySQLTypeName.INTEGER;
    private static final StandardSQLTypeName FIELD_TYPE1_STANDARD = StandardSQLTypeName.STRING;
    private static final Field.Mode FIELD_MODE1 = Field.Mode.NULLABLE;
    private static final Field.Mode FIELD_MODE2 = Field.Mode.REPEATED;
    private static final Field.Mode FIELD_MODE3 = Field.Mode.REQUIRED;
    private static final String FIELD_DESCRIPTION1 = "FieldDescription1";
    private static final String FIELD_DESCRIPTION2 = "FieldDescription2";
    private static final String FIELD_DESCRIPTION3 = "FieldDescription3";
    private static final String FIELD_DEFAULT_VALUE_EXPRESSION1 = "This is default value for this field";
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)FIELD_TYPE1, (Field[])new Field[0]).setMode(FIELD_MODE1).setDescription("FieldDescription1").setDefaultValueExpression("This is default value for this field").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)FIELD_TYPE2, (Field[])new Field[0]).setMode(FIELD_MODE2).setDescription("FieldDescription2").build();
    private static final LegacySQLTypeName FIELD_TYPE3 = LegacySQLTypeName.RECORD;
    private static final StandardSQLTypeName FIELD_TYPE3_STANDARD = StandardSQLTypeName.STRUCT;
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)FIELD_TYPE3, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(FIELD_MODE3).setDescription("FieldDescription3").build();
    private static final Field STANDARD_FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(FIELD_MODE1).setDescription("FieldDescription1").setDefaultValueExpression("This is default value for this field").build();
    private static final Field STANDARD_FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(FIELD_MODE2).setDescription("FieldDescription2").build();
    private static final Field STANDARD_FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{STANDARD_FIELD_SCHEMA1, STANDARD_FIELD_SCHEMA2}).setMode(FIELD_MODE3).setDescription("FieldDescription3").build();
    private static final Field STANDARD_FIELD_SCHEMA4 = Field.newBuilder((String)"NullModeField", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(null).build();
    private static final Field STANDARD_FIELD_SCHEMA5 = Field.newBuilder((String)"NullModeField2", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();

    @Test
    public void testToBuilder() {
        this.compareFieldSchemas(FIELD_SCHEMA1, FIELD_SCHEMA1.toBuilder().build());
        this.compareFieldSchemas(FIELD_SCHEMA2, FIELD_SCHEMA2.toBuilder().build());
        this.compareFieldSchemas(FIELD_SCHEMA3, FIELD_SCHEMA3.toBuilder().build());
        Field field = FIELD_SCHEMA1.toBuilder().setDescription("New Description").build();
        Assert.assertEquals((Object)"New Description", (Object)field.getDescription());
        field = field.toBuilder().setDescription(FIELD_DESCRIPTION1).build();
        this.compareFieldSchemas(FIELD_SCHEMA1, field);
    }

    @Test
    public void testToBuilderWithStandardSQLTypeName() {
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA1, STANDARD_FIELD_SCHEMA1.toBuilder().build());
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA2, STANDARD_FIELD_SCHEMA2.toBuilder().build());
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA3, STANDARD_FIELD_SCHEMA3.toBuilder().build());
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA4, STANDARD_FIELD_SCHEMA4.toBuilder().build());
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA5, STANDARD_FIELD_SCHEMA5.toBuilder().build());
        Field field = STANDARD_FIELD_SCHEMA1.toBuilder().setDescription("New Description").build();
        Assert.assertEquals((Object)"New Description", (Object)field.getDescription());
        field = field.toBuilder().setDescription(FIELD_DESCRIPTION1).build();
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA1, field);
    }

    @Test
    public void testToBuilderIncomplete() {
        Field field = Field.of((String)FIELD_NAME1, (LegacySQLTypeName)FIELD_TYPE1, (Field[])new Field[0]);
        this.compareFieldSchemas(field, field.toBuilder().build());
        field = Field.of((String)FIELD_NAME2, (LegacySQLTypeName)FIELD_TYPE3, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2});
        this.compareFieldSchemas(field, field.toBuilder().build());
    }

    @Test
    public void testToBuilderIncompleteWithStandardSQLTypeName() {
        Field field = Field.of((String)FIELD_NAME1, (LegacySQLTypeName)FIELD_TYPE1, (Field[])new Field[0]);
        this.compareFieldSchemas(field, field.toBuilder().build());
        field = Field.of((String)FIELD_NAME2, (LegacySQLTypeName)FIELD_TYPE3, (Field[])new Field[]{STANDARD_FIELD_SCHEMA1, STANDARD_FIELD_SCHEMA2});
        this.compareFieldSchemas(field, field.toBuilder().build());
    }

    @Test
    public void testToBuilderIncompleteStandard() {
        Field field = Field.of((String)FIELD_NAME1, (StandardSQLTypeName)FIELD_TYPE1_STANDARD, (Field[])new Field[0]);
        this.compareFieldSchemas(field, field.toBuilder().build());
        field = Field.of((String)FIELD_NAME2, (StandardSQLTypeName)FIELD_TYPE3_STANDARD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2});
        this.compareFieldSchemas(field, field.toBuilder().build());
    }

    @Test
    public void testToBuilderIncompleteStandardWithStandardSQLTypeName() {
        Field field = Field.of((String)FIELD_NAME1, (StandardSQLTypeName)FIELD_TYPE1_STANDARD, (Field[])new Field[0]);
        this.compareFieldSchemas(field, field.toBuilder().build());
        field = Field.of((String)FIELD_NAME2, (StandardSQLTypeName)FIELD_TYPE3_STANDARD, (Field[])new Field[]{STANDARD_FIELD_SCHEMA1, STANDARD_FIELD_SCHEMA2});
        this.compareFieldSchemas(field, field.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)FIELD_NAME1, (Object)FIELD_SCHEMA1.getName());
        Assert.assertEquals((Object)FIELD_TYPE1, (Object)FIELD_SCHEMA1.getType());
        Assert.assertEquals((Object)FIELD_MODE1, (Object)FIELD_SCHEMA1.getMode());
        Assert.assertEquals((Object)FIELD_DESCRIPTION1, (Object)FIELD_SCHEMA1.getDescription());
        Assert.assertEquals((Object)FIELD_DEFAULT_VALUE_EXPRESSION1, (Object)FIELD_SCHEMA1.getDefaultValueExpression());
        Assert.assertEquals(null, (Object)FIELD_SCHEMA1.getSubFields());
        Assert.assertEquals((Object)FIELD_NAME3, (Object)FIELD_SCHEMA3.getName());
        Assert.assertEquals((Object)FIELD_TYPE3, (Object)FIELD_SCHEMA3.getType());
        Assert.assertEquals((Object)FIELD_MODE3, (Object)FIELD_SCHEMA3.getMode());
        Assert.assertEquals((Object)FIELD_DESCRIPTION3, (Object)FIELD_SCHEMA3.getDescription());
        Assert.assertEquals((Object)FieldList.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}), (Object)FIELD_SCHEMA3.getSubFields());
    }

    @Test
    public void testBuilderWithStandardSQLTypeName() {
        Assert.assertEquals((Object)FIELD_NAME1, (Object)STANDARD_FIELD_SCHEMA1.getName());
        Assert.assertEquals((Object)FIELD_TYPE1, (Object)STANDARD_FIELD_SCHEMA1.getType());
        Assert.assertEquals((Object)FIELD_MODE1, (Object)STANDARD_FIELD_SCHEMA1.getMode());
        Assert.assertEquals((Object)FIELD_DESCRIPTION1, (Object)STANDARD_FIELD_SCHEMA1.getDescription());
        Assert.assertEquals((Object)FIELD_DEFAULT_VALUE_EXPRESSION1, (Object)FIELD_SCHEMA1.getDefaultValueExpression());
        Assert.assertEquals(null, (Object)STANDARD_FIELD_SCHEMA1.getSubFields());
        Assert.assertEquals((Object)FIELD_NAME3, (Object)STANDARD_FIELD_SCHEMA3.getName());
        Assert.assertEquals((Object)FIELD_TYPE3, (Object)STANDARD_FIELD_SCHEMA3.getType());
        Assert.assertEquals((Object)FIELD_MODE3, (Object)STANDARD_FIELD_SCHEMA3.getMode());
        Assert.assertEquals((Object)FIELD_DESCRIPTION3, (Object)STANDARD_FIELD_SCHEMA3.getDescription());
        Assert.assertEquals(null, (Object)STANDARD_FIELD_SCHEMA4.getMode());
        Assert.assertEquals(null, (Object)STANDARD_FIELD_SCHEMA5.getMode());
        Assert.assertEquals((Object)FieldList.of((Field[])new Field[]{STANDARD_FIELD_SCHEMA1, STANDARD_FIELD_SCHEMA2}), (Object)STANDARD_FIELD_SCHEMA3.getSubFields());
    }

    @Test
    public void testToAndFromPb() {
        this.compareFieldSchemas(FIELD_SCHEMA1, Field.fromPb((TableFieldSchema)FIELD_SCHEMA1.toPb()));
        this.compareFieldSchemas(FIELD_SCHEMA2, Field.fromPb((TableFieldSchema)FIELD_SCHEMA2.toPb()));
        this.compareFieldSchemas(FIELD_SCHEMA3, Field.fromPb((TableFieldSchema)FIELD_SCHEMA3.toPb()));
        Field field = Field.newBuilder((String)FIELD_NAME1, (LegacySQLTypeName)FIELD_TYPE1, (Field[])new Field[0]).build();
        this.compareFieldSchemas(field, Field.fromPb((TableFieldSchema)field.toPb()));
    }

    @Test
    public void testToAndFromPbWithStandardSQLTypeName() {
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA1, Field.fromPb((TableFieldSchema)STANDARD_FIELD_SCHEMA1.toPb()));
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA2, Field.fromPb((TableFieldSchema)STANDARD_FIELD_SCHEMA2.toPb()));
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA3, Field.fromPb((TableFieldSchema)STANDARD_FIELD_SCHEMA3.toPb()));
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA4, Field.fromPb((TableFieldSchema)STANDARD_FIELD_SCHEMA4.toPb()));
        this.compareFieldSchemas(STANDARD_FIELD_SCHEMA5, Field.fromPb((TableFieldSchema)STANDARD_FIELD_SCHEMA5.toPb()));
        Field field = Field.newBuilder((String)FIELD_NAME1, (LegacySQLTypeName)FIELD_TYPE1, (Field[])new Field[0]).build();
        this.compareFieldSchemas(field, Field.fromPb((TableFieldSchema)field.toPb()));
    }

    @Test
    public void testSubFieldWithClonedType() throws Exception {
        LegacySQLTypeName record = LegacySQLTypeName.RECORD;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(record);
        oos.flush();
        oos.close();
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(is);
        LegacySQLTypeName clonedRecord = (LegacySQLTypeName)ois.readObject();
        ois.close();
        Field.of((String)"field", (LegacySQLTypeName)clonedRecord, (Field[])new Field[]{Field.of((String)"subfield", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0])});
    }

    private void compareFieldSchemas(Field expected, Field value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getMode(), (Object)value.getMode());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getSubFields(), (Object)value.getSubFields());
    }
}

