/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableCell;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class FieldValueListTest {
    private static final byte[] BYTES = new byte[]{13, 14, 10, 13};
    private static final String BYTES_BASE64 = BaseEncoding.base64().encode(BYTES);
    private static final TableCell booleanPb = new TableCell().setV((Object)"false");
    private final FieldList schema = FieldList.of((Field[])new Field[]{Field.of((String)"first", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]), Field.of((String)"second", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]), Field.of((String)"third", (LegacySQLTypeName)LegacySQLTypeName.FLOAT, (Field[])new Field[0]), Field.of((String)"fourth", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)"fifth", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]), Field.of((String)"sixth", (LegacySQLTypeName)LegacySQLTypeName.BYTES, (Field[])new Field[0]), Field.of((String)"seventh", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)"eight", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]), Field.of((String)"ninth", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.of((String)"first", (LegacySQLTypeName)LegacySQLTypeName.FLOAT, (Field[])new Field[0]), Field.of((String)"second", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0])}), Field.of((String)"tenth", (LegacySQLTypeName)LegacySQLTypeName.NUMERIC, (Field[])new Field[0]), Field.of((String)"eleventh", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0])});
    private final FieldList schemaLosslessTimestamp = FieldList.of((Field[])new Field[]{Field.of((String)"first", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]), Field.of((String)"second", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]), Field.of((String)"third", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0])});
    private final Map<String, String> integerPb = ImmutableMap.of((Object)"v", (Object)"1");
    private final Map<String, String> floatPb = ImmutableMap.of((Object)"v", (Object)"1.5");
    private final Map<String, String> stringPb = ImmutableMap.of((Object)"v", (Object)"string");
    private final Map<String, String> timestampPb = ImmutableMap.of((Object)"v", (Object)"42");
    private final Map<String, String> bytesPb = ImmutableMap.of((Object)"v", (Object)BYTES_BASE64);
    private final Map<String, String> nullPb = ImmutableMap.of((Object)"v", (Object)((String)Data.nullOf(String.class)));
    private final Map<String, Object> repeatedPb = ImmutableMap.of((Object)"v", (Object)ImmutableList.of(this.integerPb, this.integerPb));
    private final Map<String, Object> recordPb = ImmutableMap.of((Object)"f", (Object)ImmutableList.of(this.floatPb, this.timestampPb));
    private final Map<String, String> numericPb = ImmutableMap.of((Object)"v", (Object)"123456789.123456789");
    private final Map<String, String> bigNumericPb = ImmutableMap.of((Object)"v", (Object)"99999999999999999999999999999999999999.99999999999999999999999999999999999999");
    private final FieldValue booleanFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"false");
    private final FieldValue booleanLosslessTimestampFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"false", (Boolean)true);
    private final FieldValue integerFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"1");
    private final FieldValue integerLosslessTimestampFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"1", (Boolean)true);
    private final FieldValue floatFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"1.5");
    private final FieldValue stringFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"string");
    private final FieldValue timestampFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"42");
    private final FieldValue losslessTimestampFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"42", (Boolean)true);
    private final FieldValue bytesFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)BYTES_BASE64);
    private final FieldValue nullFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, null);
    private final FieldValue repeatedFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.REPEATED, (Object)FieldValueList.of((List)ImmutableList.of((Object)this.integerFv, (Object)this.integerFv), (Field[])new Field[0]));
    private final FieldValue recordFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.RECORD, (Object)FieldValueList.of((List)ImmutableList.of((Object)this.floatFv, (Object)this.timestampFv), (FieldList)this.schema.get("ninth").getSubFields()));
    private final FieldValue numericFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"123456789.123456789");
    private final FieldValue bigNumericFv = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"99999999999999999999999999999999999999.99999999999999999999999999999999999999");
    private final List<?> fieldValuesPb = ImmutableList.of((Object)booleanPb, this.integerPb, this.floatPb, this.stringPb, this.timestampPb, this.bytesPb, this.nullPb, this.repeatedPb, this.recordPb, this.numericPb, this.bigNumericPb);
    private final FieldValueList fieldValues = FieldValueList.of((List)ImmutableList.of((Object)this.booleanFv, (Object)this.integerFv, (Object)this.floatFv, (Object)this.stringFv, (Object)this.timestampFv, (Object)this.bytesFv, (Object)this.nullFv, (Object)this.repeatedFv, (Object)this.recordFv, (Object)this.numericFv, (Object)this.bigNumericFv), (FieldList)this.schema);
    private final List<?> fieldValuesLosslessTimestampPb = ImmutableList.of((Object)booleanPb, this.integerPb, this.timestampPb);
    private final FieldValueList fieldValuesLosslessTimestamp = FieldValueList.of((List)ImmutableList.of((Object)this.booleanLosslessTimestampFv, (Object)this.integerLosslessTimestampFv, (Object)this.losslessTimestampFv), (FieldList)this.schemaLosslessTimestamp);

    @Test
    public void testFromPb() {
        Assert.assertEquals((Object)this.fieldValues, (Object)FieldValueList.fromPb(this.fieldValuesPb, (FieldList)this.schema));
        Assert.assertEquals((Object)this.fieldValues, (Object)FieldValueList.fromPb(this.fieldValuesPb, null));
        Assert.assertNotEquals((Object)this.fieldValues, (Object)FieldValueList.fromPb(this.fieldValuesPb, null, (Boolean)true));
        Assert.assertEquals((Object)this.fieldValuesLosslessTimestamp, (Object)FieldValueList.fromPb(this.fieldValuesLosslessTimestampPb, null, (Boolean)true));
    }

    @Test
    public void testGetByIndex() {
        Assert.assertEquals((long)11L, (long)this.fieldValues.size());
        Assert.assertEquals((Object)this.booleanFv, (Object)this.fieldValues.get(0));
        Assert.assertEquals((Object)this.integerFv, (Object)this.fieldValues.get(1));
        Assert.assertEquals((Object)this.floatFv, (Object)this.fieldValues.get(2));
        Assert.assertEquals((Object)this.stringFv, (Object)this.fieldValues.get(3));
        Assert.assertEquals((Object)this.timestampFv, (Object)this.fieldValues.get(4));
        Assert.assertEquals((Object)this.bytesFv, (Object)this.fieldValues.get(5));
        Assert.assertEquals((Object)this.nullFv, (Object)this.fieldValues.get(6));
        Assert.assertEquals((Object)this.repeatedFv, (Object)this.fieldValues.get(7));
        Assert.assertEquals((long)2L, (long)this.fieldValues.get(7).getRepeatedValue().size());
        Assert.assertEquals((Object)this.integerFv, this.fieldValues.get(7).getRepeatedValue().get(0));
        Assert.assertEquals((Object)this.integerFv, this.fieldValues.get(7).getRepeatedValue().get(1));
        Assert.assertEquals((Object)this.recordFv, (Object)this.fieldValues.get(8));
        Assert.assertEquals((long)2L, (long)this.fieldValues.get(8).getRecordValue().size());
        Assert.assertEquals((Object)this.floatFv, (Object)this.fieldValues.get(8).getRecordValue().get(0));
        Assert.assertEquals((Object)this.timestampFv, (Object)this.fieldValues.get(8).getRecordValue().get(1));
        Assert.assertEquals((Object)this.numericFv, (Object)this.fieldValues.get(9));
        Assert.assertEquals((Object)this.bigNumericFv, (Object)this.fieldValues.get(10));
    }

    @Test
    public void testGetByName() {
        Assert.assertEquals((long)11L, (long)this.fieldValues.size());
        Assert.assertEquals((Object)this.booleanFv, (Object)this.fieldValues.get("first"));
        Assert.assertEquals((Object)this.integerFv, (Object)this.fieldValues.get("second"));
        Assert.assertEquals((Object)this.floatFv, (Object)this.fieldValues.get("third"));
        Assert.assertEquals((Object)this.stringFv, (Object)this.fieldValues.get("fourth"));
        Assert.assertEquals((Object)this.timestampFv, (Object)this.fieldValues.get("fifth"));
        Assert.assertEquals((Object)this.bytesFv, (Object)this.fieldValues.get("sixth"));
        Assert.assertEquals((Object)this.nullFv, (Object)this.fieldValues.get("seventh"));
        Assert.assertEquals((Object)this.repeatedFv, (Object)this.fieldValues.get("eight"));
        Assert.assertEquals((long)2L, (long)this.fieldValues.get("eight").getRepeatedValue().size());
        Assert.assertEquals((Object)this.integerFv, this.fieldValues.get("eight").getRepeatedValue().get(0));
        Assert.assertEquals((Object)this.integerFv, this.fieldValues.get("eight").getRepeatedValue().get(1));
        Assert.assertEquals((Object)this.recordFv, (Object)this.fieldValues.get("ninth"));
        Assert.assertEquals((long)2L, (long)this.fieldValues.get("ninth").getRecordValue().size());
        Assert.assertEquals((Object)this.floatFv, (Object)this.fieldValues.get("ninth").getRecordValue().get("first"));
        Assert.assertEquals((Object)this.timestampFv, (Object)this.fieldValues.get("ninth").getRecordValue().get("second"));
        Assert.assertEquals((Object)this.numericFv, (Object)this.fieldValues.get("tenth"));
        Assert.assertEquals((Object)this.bigNumericFv, (Object)this.fieldValues.get("eleventh"));
    }

    @Test
    public void testNullSchema() {
        FieldValueList fieldValuesNoSchema = FieldValueList.of((List)ImmutableList.of((Object)this.booleanFv, (Object)this.integerFv, (Object)this.floatFv, (Object)this.stringFv, (Object)this.timestampFv, (Object)this.bytesFv, (Object)this.nullFv, (Object)this.repeatedFv, (Object)this.recordFv, (Object)this.numericFv, (Object)this.bigNumericFv), (Field[])new Field[0]);
        Assert.assertEquals((Object)this.fieldValues, (Object)fieldValuesNoSchema);
        UnsupportedOperationException exception = null;
        try {
            fieldValuesNoSchema.get("first");
        }
        catch (UnsupportedOperationException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
    }

    @Test
    public void testGetNonExistentField() {
        IllegalArgumentException exception = null;
        try {
            this.fieldValues.get("nonexistent");
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
    }
}

