/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableCell;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.Range;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.threeten.extra.PeriodDuration;

public class FieldValueTest {
    private static final byte[] BYTES = new byte[]{13, 14, 10, 13};
    private static final String BYTES_BASE64 = BaseEncoding.base64().encode(BYTES);
    private static final TableCell BOOLEAN_FIELD = new TableCell().setV((Object)"false");
    private static final Map<String, String> INTEGER_FIELD = ImmutableMap.of((Object)"v", (Object)"1");
    private static final Map<String, String> FLOAT_FIELD = ImmutableMap.of((Object)"v", (Object)"1.5");
    private static final Map<String, String> GEOGRAPHY_FIELD = ImmutableMap.of((Object)"v", (Object)"POINT(-122.350220 47.649154)");
    private static final Map<String, String> NUMERIC_FIELD = ImmutableMap.of((Object)"v", (Object)"123456789.123456789");
    private static final Map<String, String> STRING_FIELD = ImmutableMap.of((Object)"v", (Object)"string");
    private static final Map<String, String> TIMESTAMP_FIELD = ImmutableMap.of((Object)"v", (Object)"42");
    private static final Map<String, String> INTERVAL_FIELD_1 = ImmutableMap.of((Object)"v", (Object)"P3Y2M1DT12H34M56.789S");
    private static final Map<String, String> INTERVAL_FIELD_2 = ImmutableMap.of((Object)"v", (Object)"3-2 1 12:34:56.789");
    private static final Map<String, String> BYTES_FIELD = ImmutableMap.of((Object)"v", (Object)BYTES_BASE64);
    private static final Map<String, String> NULL_FIELD = ImmutableMap.of((Object)"v", (Object)((String)Data.nullOf(String.class)));
    private static final Map<String, String> RANGE_FIELD = ImmutableMap.of((Object)"v", (Object)"[start, end)");
    private static final Map<String, Object> REPEATED_FIELD = ImmutableMap.of((Object)"v", (Object)ImmutableList.of(INTEGER_FIELD, INTEGER_FIELD));
    private static final Map<String, Object> RECORD_FIELD = ImmutableMap.of((Object)"f", (Object)ImmutableList.of(FLOAT_FIELD, TIMESTAMP_FIELD));

    @Test
    public void testFromPb() {
        FieldValue value = FieldValue.fromPb((Object)BOOLEAN_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertFalse((boolean)value.getBooleanValue());
        value = FieldValue.fromPb(INTEGER_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((long)1L, (long)value.getLongValue());
        value = FieldValue.fromPb(FLOAT_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((double)1.5, (double)value.getDoubleValue(), (double)0.0);
        value = FieldValue.fromPb(GEOGRAPHY_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((Object)"POINT(-122.350220 47.649154)", (Object)value.getStringValue());
        Assert.assertEquals((Object)"POINT(-122.350220 47.649154)", (Object)value.getStringValueOrDefault(null));
        value = FieldValue.fromPb(NUMERIC_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((Object)new BigDecimal("123456789.123456789"), (Object)value.getNumericValue());
        value = FieldValue.fromPb(STRING_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((Object)"string", (Object)value.getStringValue());
        Assert.assertEquals((Object)"string", (Object)value.getStringValueOrDefault(null));
        value = FieldValue.fromPb(TIMESTAMP_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((long)42000000L, (long)value.getTimestampValue());
        value = FieldValue.fromPb(INTERVAL_FIELD_1);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        PeriodDuration periodDuration = PeriodDuration.of((Period)Period.of(3, 2, 1), (Duration)Duration.parse("PT12H34M56.789S"));
        Assert.assertEquals((Object)periodDuration, (Object)value.getPeriodDuration());
        Assert.assertEquals((Object)"P3Y2M1DT12H34M56.789S", (Object)value.getStringValue());
        Assert.assertEquals((Object)"P3Y2M1DT12H34M56.789S", (Object)value.getStringValueOrDefault(null));
        value = FieldValue.fromPb(INTERVAL_FIELD_2);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        periodDuration = PeriodDuration.of((Period)Period.of(3, 2, 1), (Duration)Duration.parse("PT12H34M56.789S"));
        Assert.assertEquals((Object)periodDuration, (Object)value.getPeriodDuration());
        Assert.assertEquals((Object)"3-2 1 12:34:56.789", (Object)value.getStringValue());
        Assert.assertEquals((Object)"3-2 1 12:34:56.789", (Object)value.getStringValueOrDefault(null));
        value = FieldValue.fromPb(BYTES_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertArrayEquals((byte[])BYTES, (byte[])value.getBytesValue());
        value = FieldValue.fromPb(NULL_FIELD);
        Assert.assertNull((Object)value.getValue());
        value = FieldValue.fromPb(RANGE_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)value.getAttribute());
        Assert.assertEquals((Object)Range.of((String)RANGE_FIELD.get("v")), (Object)value.getRangeValue());
        value = FieldValue.fromPb(REPEATED_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)value.getAttribute());
        Assert.assertEquals((Object)FieldValue.fromPb(INTEGER_FIELD), value.getRepeatedValue().get(0));
        Assert.assertEquals((Object)FieldValue.fromPb(INTEGER_FIELD), value.getRepeatedValue().get(1));
        value = FieldValue.fromPb(RECORD_FIELD);
        Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)value.getAttribute());
        Assert.assertEquals((Object)FieldValue.fromPb(FLOAT_FIELD), value.getRepeatedValue().get(0));
        Assert.assertEquals((Object)FieldValue.fromPb(TIMESTAMP_FIELD), value.getRepeatedValue().get(1));
        value = FieldValue.fromPb(NULL_FIELD);
        Assert.assertTrue((boolean)value.isNull());
        Assert.assertEquals(null, (Object)value.getStringValueOrDefault(null));
        Assert.assertEquals((Object)"defaultValue", (Object)value.getStringValueOrDefault("defaultValue"));
    }

    @Test
    public void testTimestamp() {
        FieldValue fieldValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"-1.9954383398377106E10");
        long received = fieldValue.getTimestampValue();
        long expected = -19954383398377106L;
        Assert.assertEquals((long)expected, (long)received);
    }

    @Test
    public void testInt64Timestamp() {
        FieldValue lossyFieldValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"1.9954383398377106E10");
        long lossy = lossyFieldValue.getTimestampValue();
        FieldValue losslessFieldValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"19954383398377106", (Boolean)true);
        long lossless = losslessFieldValue.getTimestampValue();
        Assert.assertEquals((long)lossy, (long)lossless);
        FieldValue fieldValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"19954383398377106", (Boolean)true);
        long received = fieldValue.getTimestampValue();
        long expected = 19954383398377106L;
        Assert.assertEquals((long)expected, (long)received);
    }

    @Test
    public void testEquals() {
        FieldValue booleanValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"false");
        Assert.assertEquals((Object)booleanValue, (Object)FieldValue.fromPb((Object)BOOLEAN_FIELD));
        Assert.assertEquals((long)booleanValue.hashCode(), (long)FieldValue.fromPb((Object)BOOLEAN_FIELD).hashCode());
        FieldValue integerValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"1");
        Assert.assertEquals((Object)integerValue, (Object)FieldValue.fromPb(INTEGER_FIELD));
        Assert.assertEquals((long)integerValue.hashCode(), (long)FieldValue.fromPb(INTEGER_FIELD).hashCode());
        FieldValue floatValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"1.5");
        Assert.assertEquals((Object)floatValue, (Object)FieldValue.fromPb(FLOAT_FIELD));
        Assert.assertEquals((long)floatValue.hashCode(), (long)FieldValue.fromPb(FLOAT_FIELD).hashCode());
        FieldValue geographyValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"POINT(-122.350220 47.649154)");
        Assert.assertEquals((Object)geographyValue, (Object)FieldValue.fromPb(GEOGRAPHY_FIELD));
        Assert.assertEquals((long)geographyValue.hashCode(), (long)FieldValue.fromPb(GEOGRAPHY_FIELD).hashCode());
        FieldValue numericValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"123456789.123456789");
        Assert.assertEquals((Object)numericValue, (Object)FieldValue.fromPb(NUMERIC_FIELD));
        Assert.assertEquals((long)numericValue.hashCode(), (long)FieldValue.fromPb(NUMERIC_FIELD).hashCode());
        FieldValue stringValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"string");
        Assert.assertEquals((Object)stringValue, (Object)FieldValue.fromPb(STRING_FIELD));
        Assert.assertEquals((long)stringValue.hashCode(), (long)FieldValue.fromPb(STRING_FIELD).hashCode());
        FieldValue timestampValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"42");
        Assert.assertEquals((Object)timestampValue, (Object)FieldValue.fromPb(TIMESTAMP_FIELD));
        Assert.assertEquals((long)timestampValue.hashCode(), (long)FieldValue.fromPb(TIMESTAMP_FIELD).hashCode());
        FieldValue bytesValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)BYTES_BASE64);
        Assert.assertEquals((Object)bytesValue, (Object)FieldValue.fromPb(BYTES_FIELD));
        Assert.assertEquals((long)bytesValue.hashCode(), (long)FieldValue.fromPb(BYTES_FIELD).hashCode());
        FieldValue nullValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, null);
        Assert.assertEquals((Object)nullValue, (Object)FieldValue.fromPb(NULL_FIELD));
        Assert.assertEquals((long)nullValue.hashCode(), (long)FieldValue.fromPb(NULL_FIELD).hashCode());
        FieldValue rangeValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"[start, end)");
        Assert.assertEquals((Object)rangeValue, (Object)FieldValue.fromPb(RANGE_FIELD));
        Assert.assertEquals((long)rangeValue.hashCode(), (long)FieldValue.fromPb(RANGE_FIELD).hashCode());
        FieldValue repeatedValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.REPEATED, (Object)ImmutableList.of((Object)integerValue, (Object)integerValue));
        Assert.assertEquals((Object)repeatedValue, (Object)FieldValue.fromPb(REPEATED_FIELD));
        Assert.assertEquals((long)repeatedValue.hashCode(), (long)FieldValue.fromPb(REPEATED_FIELD).hashCode());
        FieldValue recordValue = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.RECORD, (Object)ImmutableList.of((Object)floatValue, (Object)timestampValue));
        Assert.assertEquals((Object)recordValue, (Object)FieldValue.fromPb(RECORD_FIELD));
        Assert.assertEquals((long)recordValue.hashCode(), (long)FieldValue.fromPb(RECORD_FIELD).hashCode());
    }

    @Test
    public void testParseCanonicalInterval() {
        LinkedHashMap<String, PeriodDuration> intervalToPeriodDuration = new LinkedHashMap<String, PeriodDuration>();
        intervalToPeriodDuration.put("125-7 -19 -0:24:12.001", PeriodDuration.parse((CharSequence)"P125Y7M-19DT0H-24M-12.001S"));
        intervalToPeriodDuration.put("-15-6 23 23:14:05", PeriodDuration.parse((CharSequence)"P-15Y-6M23DT23H14M5S"));
        intervalToPeriodDuration.put("06-01 06 01:01:00.123456", PeriodDuration.parse((CharSequence)"P6Y1M6DT1H1M0.123456S"));
        intervalToPeriodDuration.put("-0-0 -0 -0:0:0", PeriodDuration.parse((CharSequence)"P0Y0M0DT0H0M0S"));
        intervalToPeriodDuration.put("-99999-99999 9999 999:999:999.999999999", PeriodDuration.parse((CharSequence)"P-99999Y-99999M9999DT999H999M999.999999999S"));
        for (Map.Entry entry : intervalToPeriodDuration.entrySet()) {
            Assert.assertEquals((Object)FieldValue.parseCanonicalInterval((String)((String)entry.getKey())), entry.getValue());
            System.out.println(FieldValue.parseCanonicalInterval((String)((String)entry.getKey())));
        }
    }
}

