/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableConstraints;
import com.google.cloud.bigquery.ColumnReference;
import com.google.cloud.bigquery.ForeignKey;
import com.google.cloud.bigquery.TableId;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class ForeignKeyTest {
    private static final TableId TABLE_ID = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final ColumnReference COLUMN_REFERENCE = ColumnReference.newBuilder().setReferencingColumn("column1").setReferencedColumn("column2").build();
    private static final ForeignKey FOREIGN_KEY = ForeignKey.newBuilder().setName("foreign_key").setReferencedTable(TABLE_ID).setColumnReferences(Collections.singletonList(COLUMN_REFERENCE)).build();

    @Test
    public void testToBuilder() {
        this.compareForeignKeyDefinition(FOREIGN_KEY, FOREIGN_KEY.toBuilder().build());
        TableId referencedTable = TableId.of((String)"project1", (String)"dataset1", (String)"table1");
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>();
        columnReferences.add(ColumnReference.newBuilder().setReferencingColumn("from").setReferencedColumn("to").build());
        columnReferences.add(ColumnReference.newBuilder().setReferencingColumn("from2").setReferencedColumn("to2").build());
        ForeignKey foreignKey = FOREIGN_KEY.toBuilder().setName("test").setReferencedTable(referencedTable).setColumnReferences(columnReferences).build();
        Assert.assertEquals((Object)"test", (Object)foreignKey.getName());
        Assert.assertEquals((Object)referencedTable, (Object)foreignKey.getReferencedTable());
        Assert.assertEquals(columnReferences, (Object)foreignKey.getColumnReferences());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"foreign_key", (Object)FOREIGN_KEY.getName());
        Assert.assertEquals((Object)TABLE_ID, (Object)FOREIGN_KEY.getReferencedTable());
        Assert.assertEquals(Collections.singletonList(COLUMN_REFERENCE), (Object)FOREIGN_KEY.getColumnReferences());
        ForeignKey foreignKey = FOREIGN_KEY.newBuilder().setName("foreign_key").setReferencedTable(TABLE_ID).setColumnReferences(Collections.singletonList(COLUMN_REFERENCE)).build();
        Assert.assertEquals((Object)FOREIGN_KEY, (Object)foreignKey);
    }

    @Test
    public void testToAndFromPb() {
        ForeignKey foreignKey = FOREIGN_KEY.toBuilder().build();
        Assert.assertTrue((boolean)(ForeignKey.fromPb((TableConstraints.ForeignKeys)foreignKey.toPb()) instanceof ForeignKey));
        this.compareForeignKeyDefinition(foreignKey, ForeignKey.fromPb((TableConstraints.ForeignKeys)foreignKey.toPb()));
    }

    private void compareForeignKeyDefinition(ForeignKey expected, ForeignKey value) {
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getReferencedTable(), (Object)value.getReferencedTable());
        Assert.assertEquals((Object)expected.getColumnReferences(), (Object)value.getColumnReferences());
    }
}

