/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.GoogleSheetsOptions;
import com.google.common.truth.Truth;
import org.junit.Test;

public class GoogleSheetsOptionsTest {
    private static final long SKIP_LEADING_ROWS = 42L;
    private static final String RANGE = "sheet1!A1:B20";
    private static final GoogleSheetsOptions GOOGLE_SHEETS_OPTIONS = GoogleSheetsOptions.newBuilder().setSkipLeadingRows(42L).build();
    private static final GoogleSheetsOptions GOOGLE_SHEETS_OPTIONS_RANGE = GoogleSheetsOptions.newBuilder().setSkipLeadingRows(42L).setRange("sheet1!A1:B20").build();

    @Test
    public void testToBuilder() {
        this.compareGoogleSheetsOptions(GOOGLE_SHEETS_OPTIONS, GOOGLE_SHEETS_OPTIONS.toBuilder().build());
        GoogleSheetsOptions googleSheetsOptions = GOOGLE_SHEETS_OPTIONS.toBuilder().setSkipLeadingRows(123L).build();
        Truth.assertThat((Long)googleSheetsOptions.getSkipLeadingRows()).isEqualTo((Object)123);
        googleSheetsOptions = googleSheetsOptions.toBuilder().setSkipLeadingRows(42L).build();
        this.compareGoogleSheetsOptions(GOOGLE_SHEETS_OPTIONS, googleSheetsOptions);
        this.compareGoogleSheetsOptions(GOOGLE_SHEETS_OPTIONS_RANGE, GOOGLE_SHEETS_OPTIONS_RANGE.toBuilder().build());
        GoogleSheetsOptions googleSheetsOptionsRange = GOOGLE_SHEETS_OPTIONS_RANGE.toBuilder().setSkipLeadingRows(123L).setRange("sheet1!A1:A100").build();
        Truth.assertThat((Long)googleSheetsOptionsRange.getSkipLeadingRows()).isEqualTo((Object)123);
        Truth.assertThat((String)googleSheetsOptionsRange.getRange()).isEqualTo((Object)"sheet1!A1:A100");
        googleSheetsOptionsRange = googleSheetsOptionsRange.toBuilder().setSkipLeadingRows(42L).setRange(RANGE).build();
        this.compareGoogleSheetsOptions(GOOGLE_SHEETS_OPTIONS_RANGE, googleSheetsOptionsRange);
    }

    @Test
    public void testToBuilderIncomplete() {
        GoogleSheetsOptions googleSheetsOptions = GoogleSheetsOptions.newBuilder().build();
        Truth.assertThat((Object)googleSheetsOptions.toBuilder().build()).isEqualTo((Object)googleSheetsOptions);
    }

    @Test
    public void testBuilder() {
        Truth.assertThat((String)GOOGLE_SHEETS_OPTIONS.getType()).isEqualTo((Object)"GOOGLE_SHEETS");
        Truth.assertThat((Long)GOOGLE_SHEETS_OPTIONS.getSkipLeadingRows()).isEqualTo((Object)42L);
        Truth.assertThat((String)GOOGLE_SHEETS_OPTIONS_RANGE.getType()).isEqualTo((Object)"GOOGLE_SHEETS");
        Truth.assertThat((Long)GOOGLE_SHEETS_OPTIONS_RANGE.getSkipLeadingRows()).isEqualTo((Object)42L);
        Truth.assertThat((String)GOOGLE_SHEETS_OPTIONS_RANGE.getRange()).isEqualTo((Object)RANGE);
    }

    @Test
    public void testToAndFromPb() {
        this.compareGoogleSheetsOptions(GOOGLE_SHEETS_OPTIONS, GoogleSheetsOptions.fromPb((com.google.api.services.bigquery.model.GoogleSheetsOptions)GOOGLE_SHEETS_OPTIONS.toPb()));
        GoogleSheetsOptions googleSheetsOptions = GoogleSheetsOptions.newBuilder().build();
        this.compareGoogleSheetsOptions(googleSheetsOptions, GoogleSheetsOptions.fromPb((com.google.api.services.bigquery.model.GoogleSheetsOptions)googleSheetsOptions.toPb()));
        this.compareGoogleSheetsOptions(GOOGLE_SHEETS_OPTIONS_RANGE, GoogleSheetsOptions.fromPb((com.google.api.services.bigquery.model.GoogleSheetsOptions)GOOGLE_SHEETS_OPTIONS_RANGE.toPb()));
        GoogleSheetsOptions googleSheetsOptionsRange = GoogleSheetsOptions.newBuilder().build();
        this.compareGoogleSheetsOptions(googleSheetsOptionsRange, GoogleSheetsOptions.fromPb((com.google.api.services.bigquery.model.GoogleSheetsOptions)googleSheetsOptionsRange.toPb()));
    }

    private void compareGoogleSheetsOptions(GoogleSheetsOptions expected, GoogleSheetsOptions value) {
        Truth.assertThat((Object)value).isEqualTo((Object)expected);
        Truth.assertThat((Long)value.getSkipLeadingRows()).isEqualTo((Object)expected.getSkipLeadingRows());
        Truth.assertThat((String)value.getRange()).isEqualTo((Object)expected.getRange());
    }
}

