/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public class HivePartitioningOptionsTest {
    private static final String MODE = "STRING";
    private static final String SOURCE_URI_PREFIX = "gs://bucket/path_to_table";
    private static final Boolean REQUIRE_PARTITION_FILTER = true;
    private static final List<String> FIELDS = Arrays.asList("FIELD1", "FIELD2");
    private static final HivePartitioningOptions HIVE_PARTITIONING_OPTIONS = HivePartitioningOptions.newBuilder().setMode("STRING").setRequirePartitionFilter(REQUIRE_PARTITION_FILTER).setSourceUriPrefix("gs://bucket/path_to_table").setFields(FIELDS).build();

    @Test
    public void testToBuilder() {
        this.compareHivePartitioningOptions(HIVE_PARTITIONING_OPTIONS, HIVE_PARTITIONING_OPTIONS.toBuilder().build());
        HivePartitioningOptions options = HIVE_PARTITIONING_OPTIONS.toBuilder().setMode("AUTO").build();
        Truth.assertThat((String)options.getMode()).isEqualTo((Object)"AUTO");
        options = HIVE_PARTITIONING_OPTIONS.toBuilder().setMode(MODE).build();
        this.compareHivePartitioningOptions(HIVE_PARTITIONING_OPTIONS, options);
    }

    @Test
    public void testToBuilderIncomplete() {
        HivePartitioningOptions options = HivePartitioningOptions.newBuilder().build();
        this.compareHivePartitioningOptions(options, options.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Truth.assertThat((String)HIVE_PARTITIONING_OPTIONS.getMode()).isEqualTo((Object)MODE);
        Truth.assertThat((Boolean)HIVE_PARTITIONING_OPTIONS.getRequirePartitionFilter()).isEqualTo((Object)REQUIRE_PARTITION_FILTER);
        Truth.assertThat((String)HIVE_PARTITIONING_OPTIONS.getSourceUriPrefix()).isEqualTo((Object)SOURCE_URI_PREFIX);
    }

    @Test
    public void testToAndFromPb() {
        this.compareHivePartitioningOptions(HIVE_PARTITIONING_OPTIONS, HivePartitioningOptions.fromPb((com.google.api.services.bigquery.model.HivePartitioningOptions)HIVE_PARTITIONING_OPTIONS.toPb()));
    }

    private void compareHivePartitioningOptions(HivePartitioningOptions expected, HivePartitioningOptions value) {
        Truth.assertThat((String)value.getMode()).isEqualTo((Object)expected.getMode());
        Truth.assertThat((Boolean)value.getRequirePartitionFilter()).isEqualTo((Object)expected.getRequirePartitionFilter());
        Truth.assertThat((String)value.getSourceUriPrefix()).isEqualTo((Object)expected.getSourceUriPrefix());
        Truth.assertThat((String)value.toString()).isEqualTo((Object)expected.toString());
        Truth.assertThat((Integer)value.hashCode()).isEqualTo((Object)expected.hashCode());
    }
}

