/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class InsertAllRequestTest {
    private static final Map<String, Object> CONTENT1 = ImmutableMap.of((Object)"key", (Object)"val1");
    private static final Map<String, Object> CONTENT2 = ImmutableMap.of((Object)"key", (Object)"val2");
    private static final List<InsertAllRequest.RowToInsert> ROWS = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of(CONTENT1), (Object)InsertAllRequest.RowToInsert.of(CONTENT2));
    private static final List<InsertAllRequest.RowToInsert> ROWS_WITH_ID = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of((String)"id1", CONTENT1), (Object)InsertAllRequest.RowToInsert.of((String)"id2", CONTENT2));
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[0]);
    private static final TableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
    private static final TableInfo TABLE_INFO = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
    private static final boolean SKIP_INVALID_ROWS = true;
    private static final boolean IGNORE_UNKNOWN_VALUES = false;
    private static final String TEMPLATE_SUFFIX = "templateSuffix";
    private static final InsertAllRequest INSERT_ALL_REQUEST1 = InsertAllRequest.newBuilder((TableId)TABLE_ID).addRow(CONTENT1).addRow(CONTENT2).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST2 = InsertAllRequest.newBuilder((TableId)TABLE_ID).setRows(ROWS).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST3 = InsertAllRequest.newBuilder((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable()).setRows(ROWS_WITH_ID).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST4 = InsertAllRequest.newBuilder((TableId)TABLE_ID, ROWS).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST5 = InsertAllRequest.newBuilder((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable(), ROWS_WITH_ID).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST6 = InsertAllRequest.newBuilder((TableId)TABLE_ID, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)}).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST7 = InsertAllRequest.newBuilder((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable(), (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS_WITH_ID.get(0), ROWS_WITH_ID.get(1)}).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST8 = InsertAllRequest.newBuilder((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable()).addRow("id1", CONTENT1).addRow("id2", CONTENT2).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST9 = InsertAllRequest.newBuilder((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[0]).addRow("id1", CONTENT1).addRow("id2", CONTENT2).setIgnoreUnknownValues(false).setSkipInvalidRows(true).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST10 = InsertAllRequest.newBuilder((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[0]).addRow("id1", CONTENT1).addRow("id2", CONTENT2).setIgnoreUnknownValues(true).setSkipInvalidRows(false).build();
    private static final InsertAllRequest INSERT_ALL_REQUEST11 = InsertAllRequest.newBuilder((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[0]).addRow("id1", CONTENT1).addRow("id2", CONTENT2).setIgnoreUnknownValues(true).setSkipInvalidRows(false).setTemplateSuffix("templateSuffix").build();

    @Test
    public void testBuilder() {
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST1.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST2.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST3.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST4.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST5.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST6.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST7.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST8.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST9.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST10.getTable());
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)INSERT_ALL_REQUEST11.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)INSERT_ALL_REQUEST1.getRows());
        Truth.assertThat(ROWS).isEqualTo((Object)INSERT_ALL_REQUEST2.getRows());
        Truth.assertThat(ROWS).isEqualTo((Object)INSERT_ALL_REQUEST4.getRows());
        Truth.assertThat(ROWS).isEqualTo((Object)INSERT_ALL_REQUEST6.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST3.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST5.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST7.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST8.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST9.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST10.getRows());
        Truth.assertThat(ROWS_WITH_ID).isEqualTo((Object)INSERT_ALL_REQUEST11.getRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST1.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST2.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST3.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST4.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST5.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST6.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST7.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST8.skipInvalidRows());
        Truth.assertThat((Boolean)true).isEqualTo((Object)INSERT_ALL_REQUEST9.skipInvalidRows());
        Truth.assertThat((Boolean)INSERT_ALL_REQUEST10.skipInvalidRows()).isFalse();
        Truth.assertThat((Boolean)INSERT_ALL_REQUEST11.skipInvalidRows()).isFalse();
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST1.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST2.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST3.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST4.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST5.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST6.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST7.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST8.ignoreUnknownValues());
        Truth.assertThat((Boolean)false).isEqualTo((Object)INSERT_ALL_REQUEST9.ignoreUnknownValues());
        Truth.assertThat((Boolean)INSERT_ALL_REQUEST10.ignoreUnknownValues()).isTrue();
        Truth.assertThat((Boolean)INSERT_ALL_REQUEST11.ignoreUnknownValues()).isTrue();
        Truth.assertThat((String)INSERT_ALL_REQUEST1.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST2.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST3.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST4.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST5.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST6.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST7.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST8.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST9.getTemplateSuffix()).isNull();
        Truth.assertThat((String)INSERT_ALL_REQUEST10.getTemplateSuffix()).isNull();
        Truth.assertThat((String)TEMPLATE_SUFFIX).isEqualTo((Object)INSERT_ALL_REQUEST11.getTemplateSuffix());
    }

    @Test
    public void testOf() {
        InsertAllRequest request = InsertAllRequest.of((TableId)TABLE_ID, ROWS);
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
        request = InsertAllRequest.of((TableInfo)TABLE_INFO, ROWS);
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
        request = InsertAllRequest.of((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable(), ROWS);
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
        request = InsertAllRequest.of((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable(), ROWS);
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
        request = InsertAllRequest.of((TableId)TABLE_ID, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)});
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
        request = InsertAllRequest.of((TableInfo)TABLE_INFO, (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)});
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
        request = InsertAllRequest.of((String)TABLE_ID.getDataset(), (String)TABLE_ID.getTable(), (InsertAllRequest.RowToInsert[])new InsertAllRequest.RowToInsert[]{ROWS.get(0), ROWS.get(1)});
        Truth.assertThat((Object)TABLE_ID).isEqualTo((Object)request.getTable());
        Truth.assertThat(ROWS).isEqualTo((Object)request.getRows());
    }

    @Test
    public void testEquals() {
        this.compareInsertAllRequest(INSERT_ALL_REQUEST1, INSERT_ALL_REQUEST2);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST2, INSERT_ALL_REQUEST4);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST3, INSERT_ALL_REQUEST5);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST4, INSERT_ALL_REQUEST6);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST5, INSERT_ALL_REQUEST7);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST7, INSERT_ALL_REQUEST8);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST8, INSERT_ALL_REQUEST9);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST10, INSERT_ALL_REQUEST10);
        this.compareInsertAllRequest(INSERT_ALL_REQUEST11, INSERT_ALL_REQUEST11);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testImmutable() {
        InsertAllRequest.RowToInsert row = InsertAllRequest.RowToInsert.of(new HashMap());
        row.getContent().put("zip", "zap");
    }

    @Test
    public void testNullOK() {
        InsertAllRequest.RowToInsert row = InsertAllRequest.RowToInsert.of(Collections.singletonMap("foo", null));
        Truth.assertThat((Map)row.getContent()).containsExactly((Object)"foo", null, new Object[0]);
    }

    private void compareInsertAllRequest(InsertAllRequest expected, InsertAllRequest value) {
        Truth.assertThat((Object)expected).isEqualTo((Object)value);
        Truth.assertThat((String)expected.toString()).isEqualTo((Object)value.toString());
        Truth.assertThat((Integer)expected.hashCode()).isEqualTo((Object)value.hashCode());
        Truth.assertThat((Object)expected.getTable()).isEqualTo((Object)value.getTable());
        Truth.assertThat((Iterable)expected.getRows()).isEqualTo((Object)value.getRows());
        Truth.assertThat((Boolean)expected.ignoreUnknownValues()).isEqualTo((Object)value.ignoreUnknownValues());
        Truth.assertThat((Boolean)expected.skipInvalidRows()).isEqualTo((Object)value.skipInvalidRows());
        Truth.assertThat((String)expected.getTemplateSuffix()).isEqualTo((Object)value.getTemplateSuffix());
    }
}

