/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobReference;
import com.google.cloud.bigquery.JobId;
import org.junit.Assert;
import org.junit.Test;

public class JobIdTest {
    private static final JobId JOB = JobId.of((String)"job");
    private static final JobId JOB_COMPLETE = JobId.of((String)"project", (String)"job");

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)JOB.getProject());
        Assert.assertEquals((Object)"job", (Object)JOB.getJob());
        Assert.assertEquals((Object)"project", (Object)JOB_COMPLETE.getProject());
        Assert.assertEquals((Object)"job", (Object)JOB_COMPLETE.getJob());
    }

    @Test
    public void testEquals() {
        this.compareJobs(JOB, JobId.of((String)"job"));
        this.compareJobs(JOB_COMPLETE, JobId.of((String)"project", (String)"job"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareJobs(JOB, JobId.fromPb((JobReference)JOB.toPb()));
        this.compareJobs(JOB_COMPLETE, JobId.fromPb((JobReference)JOB_COMPLETE.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)JOB_COMPLETE, (Object)JOB.setProjectId("project"));
    }

    private void compareJobs(JobId expected, JobId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getProject(), (Object)value.getProject());
        Assert.assertEquals((Object)expected.getJob(), (Object)value.getJob());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

