/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JobInfoTest {
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "id";
    private static final String SELF_LINK = "selfLink";
    private static final String EMAIL = "email";
    private static final JobId JOB_ID = JobId.of((String)"job");
    private static final JobStatus JOB_STATUS = new JobStatus(JobStatus.State.DONE);
    private static final JobStatistics.CopyStatistics COPY_JOB_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
    private static final JobStatistics.ExtractStatistics EXTRACT_JOB_STATISTICS = ((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)JobStatistics.ExtractStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).setDestinationUriFileCounts((List)ImmutableList.of((Object)42L)).build();
    private static final JobStatistics.LoadStatistics LOAD_JOB_STATISTICS = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).setInputFiles(Long.valueOf(42L)).setOutputBytes(Long.valueOf(1024L)).setInputBytes(Long.valueOf(2048L)).setOutputRows(Long.valueOf(24L)).build();
    private static final JobStatistics.QueryStatistics QUERY_JOB_STATISTICS = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).setTotalBytesProcessed(Long.valueOf(2048L)).setTotalBytesBilled(Long.valueOf(1024L)).setCacheHit(Boolean.valueOf(false)).setBillingTier(Integer.valueOf(42)).build();
    private static final TableId SOURCE_TABLE = TableId.of((String)"dataset", (String)"sourceTable");
    private static final TableId DESTINATION_TABLE = TableId.of((String)"dataset", (String)"destinationTable");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final CopyJobConfiguration COPY_CONFIGURATION = CopyJobConfiguration.newBuilder((TableId)DESTINATION_TABLE, (TableId)SOURCE_TABLE).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).build();
    private static final List<String> DESTINATION_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final String FIELD_DELIMITER = ",";
    private static final String FORMAT = "CSV";
    private static final Boolean PRINT_HEADER = true;
    private static final String COMPRESSION = "GZIP";
    private static final ExtractJobConfiguration EXTRACT_CONFIGURATION = ExtractJobConfiguration.newBuilder((TableId)TABLE_ID, DESTINATION_URIS).setPrintHeader(PRINT_HEADER).setFieldDelimiter(",").setCompression("GZIP").setFormat("CSV").build();
    private static final List<String> PROJECTION_FIELDS = ImmutableList.of((Object)"field1", (Object)"field2");
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().build();
    private static final List<JobInfo.SchemaUpdateOption> SCHEMA_UPDATE_OPTIONS = ImmutableList.of((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
    private static final ExternalTableDefinition TABLE_CONFIGURATION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setCompression("GZIP").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).build();
    private static final LoadJobConfiguration LOAD_CONFIGURATION = LoadJobConfiguration.newBuilder((TableId)TABLE_ID, SOURCE_URIS).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setFormatOptions((FormatOptions)CSV_OPTIONS).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).build();
    private static final String QUERY = "BigQuery SQL";
    private static final Map<String, ExternalTableDefinition> TABLE_DEFINITIONS = ImmutableMap.of((Object)"tableName", (Object)TABLE_CONFIGURATION);
    private static final QueryJobConfiguration.Priority PRIORITY = QueryJobConfiguration.Priority.BATCH;
    private static final boolean ALLOW_LARGE_RESULTS = true;
    private static final boolean USE_QUERY_CACHE = false;
    private static final boolean FLATTEN_RESULTS = true;
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final QueryJobConfiguration QUERY_CONFIGURATION = QueryJobConfiguration.newBuilder((String)"BigQuery SQL").setUseQueryCache(Boolean.valueOf(false)).setTableDefinitions(TABLE_DEFINITIONS).setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition(CREATE_DISPOSITION).setDefaultDataset(DATASET_ID).setDestinationTable(TABLE_ID).setWriteDisposition(WRITE_DISPOSITION).setPriority(PRIORITY).setFlattenResults(Boolean.valueOf(true)).setUserDefinedFunctions(USER_DEFINED_FUNCTIONS).setDryRun(Boolean.valueOf(true)).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).build();
    private static final JobInfo COPY_JOB = JobInfo.newBuilder((JobConfiguration)COPY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)COPY_JOB_STATISTICS).setJobId(JOB_ID).setEtag("etag").setGeneratedId("id").setSelfLink("selfLink").setUserEmail("email").setStatus(JOB_STATUS).build();
    private static final JobInfo EXTRACT_JOB = JobInfo.newBuilder((JobConfiguration)EXTRACT_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)EXTRACT_JOB_STATISTICS).setJobId(JOB_ID).setEtag("etag").setGeneratedId("id").setSelfLink("selfLink").setUserEmail("email").setStatus(JOB_STATUS).build();
    private static final JobInfo LOAD_JOB = JobInfo.newBuilder((JobConfiguration)LOAD_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)LOAD_JOB_STATISTICS).setJobId(JOB_ID).setEtag("etag").setGeneratedId("id").setSelfLink("selfLink").setUserEmail("email").setStatus(JOB_STATUS).build();
    private static final JobInfo QUERY_JOB = JobInfo.newBuilder((JobConfiguration)QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)QUERY_JOB_STATISTICS).setJobId(JOB_ID).setEtag("etag").setGeneratedId("id").setSelfLink("selfLink").setUserEmail("email").setStatus(JOB_STATUS).build();

    @Test
    public void testToBuilder() {
        this.compareJobInfo(COPY_JOB, COPY_JOB.toBuilder().build());
        this.compareJobInfo(EXTRACT_JOB, EXTRACT_JOB.toBuilder().build());
        this.compareJobInfo(LOAD_JOB, LOAD_JOB.toBuilder().build());
        this.compareJobInfo(QUERY_JOB, QUERY_JOB.toBuilder().build());
        JobInfo job = COPY_JOB.toBuilder().setUserEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.getUserEmail());
        job = job.toBuilder().setUserEmail(EMAIL).build();
        this.compareJobInfo(COPY_JOB, job);
        job = EXTRACT_JOB.toBuilder().setUserEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.getUserEmail());
        job = job.toBuilder().setUserEmail(EMAIL).build();
        this.compareJobInfo(EXTRACT_JOB, job);
        job = LOAD_JOB.toBuilder().setUserEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.getUserEmail());
        job = job.toBuilder().setUserEmail(EMAIL).build();
        this.compareJobInfo(LOAD_JOB, job);
        job = QUERY_JOB.toBuilder().setUserEmail("newEmail").build();
        Assert.assertEquals((Object)"newEmail", (Object)job.getUserEmail());
        job = job.toBuilder().setUserEmail(EMAIL).build();
        this.compareJobInfo(QUERY_JOB, job);
    }

    @Test
    public void testOf() {
        JobInfo job = JobInfo.of((JobConfiguration)COPY_CONFIGURATION);
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobConfiguration)EXTRACT_CONFIGURATION);
        Assert.assertEquals((Object)EXTRACT_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobConfiguration)LOAD_CONFIGURATION);
        Assert.assertEquals((Object)LOAD_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobConfiguration)QUERY_CONFIGURATION);
        Assert.assertEquals((Object)QUERY_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)COPY_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.getJobId());
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)EXTRACT_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.getJobId());
        Assert.assertEquals((Object)EXTRACT_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)LOAD_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.getJobId());
        Assert.assertEquals((Object)LOAD_CONFIGURATION, (Object)job.getConfiguration());
        job = JobInfo.of((JobId)JOB_ID, (JobConfiguration)QUERY_CONFIGURATION);
        Assert.assertEquals((Object)JOB_ID, (Object)job.getJobId());
        Assert.assertEquals((Object)QUERY_CONFIGURATION, (Object)job.getConfiguration());
    }

    @Test
    public void testToBuilderIncomplete() {
        JobInfo job = JobInfo.of((JobConfiguration)COPY_CONFIGURATION);
        this.compareJobInfo(job, job.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ETAG, (Object)COPY_JOB.getEtag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)COPY_JOB.getGeneratedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)COPY_JOB.getSelfLink());
        Assert.assertEquals((Object)EMAIL, (Object)COPY_JOB.getUserEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)COPY_JOB.getJobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)COPY_JOB.getStatus());
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)COPY_JOB.getConfiguration());
        Assert.assertEquals((Object)COPY_JOB_STATISTICS, (Object)COPY_JOB.getStatistics());
        Assert.assertEquals((Object)ETAG, (Object)EXTRACT_JOB.getEtag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)EXTRACT_JOB.getGeneratedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)EXTRACT_JOB.getSelfLink());
        Assert.assertEquals((Object)EMAIL, (Object)EXTRACT_JOB.getUserEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)EXTRACT_JOB.getJobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)EXTRACT_JOB.getStatus());
        Assert.assertEquals((Object)EXTRACT_CONFIGURATION, (Object)EXTRACT_JOB.getConfiguration());
        Assert.assertEquals((Object)EXTRACT_JOB_STATISTICS, (Object)EXTRACT_JOB.getStatistics());
        Assert.assertEquals((Object)ETAG, (Object)LOAD_JOB.getEtag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)LOAD_JOB.getGeneratedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)LOAD_JOB.getSelfLink());
        Assert.assertEquals((Object)EMAIL, (Object)LOAD_JOB.getUserEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)LOAD_JOB.getJobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)LOAD_JOB.getStatus());
        Assert.assertEquals((Object)LOAD_CONFIGURATION, (Object)LOAD_JOB.getConfiguration());
        Assert.assertEquals((Object)LOAD_JOB_STATISTICS, (Object)LOAD_JOB.getStatistics());
        Assert.assertEquals((Object)ETAG, (Object)QUERY_JOB.getEtag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)QUERY_JOB.getGeneratedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)QUERY_JOB.getSelfLink());
        Assert.assertEquals((Object)EMAIL, (Object)QUERY_JOB.getUserEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)QUERY_JOB.getJobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)QUERY_JOB.getStatus());
        Assert.assertEquals((Object)QUERY_CONFIGURATION, (Object)QUERY_JOB.getConfiguration());
        Assert.assertEquals((Object)QUERY_JOB_STATISTICS, (Object)QUERY_JOB.getStatistics());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)COPY_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNull((Object)COPY_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNull((Object)COPY_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNull((Object)COPY_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)COPY_JOB_STATISTICS, (Object)JobStatistics.fromPb((Job)COPY_JOB.toPb()));
        this.compareJobInfo(COPY_JOB, JobInfo.fromPb((Job)COPY_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)COPY_JOB.toPb()).getConfiguration() instanceof CopyJobConfiguration));
        Assert.assertNull((Object)EXTRACT_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNotNull((Object)EXTRACT_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNull((Object)EXTRACT_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNull((Object)EXTRACT_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)EXTRACT_JOB_STATISTICS, (Object)JobStatistics.fromPb((Job)EXTRACT_JOB.toPb()));
        this.compareJobInfo(EXTRACT_JOB, JobInfo.fromPb((Job)EXTRACT_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)EXTRACT_JOB.toPb()).getConfiguration() instanceof ExtractJobConfiguration));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)EXTRACT_JOB.toPb()).getStatistics() instanceof JobStatistics.ExtractStatistics));
        Assert.assertNull((Object)LOAD_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNull((Object)LOAD_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNotNull((Object)LOAD_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNull((Object)LOAD_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)LOAD_JOB_STATISTICS, (Object)JobStatistics.fromPb((Job)LOAD_JOB.toPb()));
        this.compareJobInfo(LOAD_JOB, JobInfo.fromPb((Job)LOAD_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)LOAD_JOB.toPb()).getConfiguration() instanceof LoadJobConfiguration));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)LOAD_JOB.toPb()).getStatistics() instanceof JobStatistics.LoadStatistics));
        Assert.assertNull((Object)QUERY_JOB.toPb().getConfiguration().getCopy());
        Assert.assertNull((Object)QUERY_JOB.toPb().getConfiguration().getExtract());
        Assert.assertNull((Object)QUERY_JOB.toPb().getConfiguration().getLoad());
        Assert.assertNotNull((Object)QUERY_JOB.toPb().getConfiguration().getQuery());
        Assert.assertEquals((Object)QUERY_JOB_STATISTICS, (Object)JobStatistics.fromPb((Job)QUERY_JOB.toPb()));
        this.compareJobInfo(QUERY_JOB, JobInfo.fromPb((Job)QUERY_JOB.toPb()));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)QUERY_JOB.toPb()).getConfiguration() instanceof QueryJobConfiguration));
        Assert.assertTrue((boolean)(JobInfo.fromPb((Job)QUERY_JOB.toPb()).getStatistics() instanceof JobStatistics.QueryStatistics));
    }

    @Test
    public void testSetProjectId() {
        JobInfo jobInfo = COPY_JOB.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)jobInfo.getJobId().getProject());
        CopyJobConfiguration copyConfiguration = (CopyJobConfiguration)jobInfo.getConfiguration();
        Assert.assertEquals((Object)"p", (Object)copyConfiguration.getDestinationTable().getProject());
        for (TableId sourceTable : copyConfiguration.getSourceTables()) {
            Assert.assertEquals((Object)"p", (Object)sourceTable.getProject());
        }
        jobInfo = EXTRACT_JOB.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)jobInfo.getJobId().getProject());
        ExtractJobConfiguration extractConfiguration = (ExtractJobConfiguration)jobInfo.getConfiguration();
        Assert.assertEquals((Object)"p", (Object)extractConfiguration.getSourceTable().getProject());
        jobInfo = LOAD_JOB.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)jobInfo.getJobId().getProject());
        LoadJobConfiguration loadConfiguration = (LoadJobConfiguration)jobInfo.getConfiguration();
        Assert.assertEquals((Object)"p", (Object)loadConfiguration.getDestinationTable().getProject());
        jobInfo = QUERY_JOB.setProjectId("p");
        Assert.assertEquals((Object)"p", (Object)jobInfo.getJobId().getProject());
        QueryJobConfiguration queryConfiguration = (QueryJobConfiguration)jobInfo.getConfiguration();
        Assert.assertEquals((Object)"p", (Object)queryConfiguration.getDefaultDataset().getProject());
        Assert.assertEquals((Object)"p", (Object)queryConfiguration.getDestinationTable().getProject());
    }

    private void compareJobInfo(JobInfo expected, JobInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getGeneratedId(), (Object)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getJobId(), (Object)value.getJobId());
        Assert.assertEquals((Object)expected.getSelfLink(), (Object)value.getSelfLink());
        Assert.assertEquals((Object)expected.getStatus(), (Object)value.getStatus());
        Assert.assertEquals((Object)expected.getStatistics(), (Object)value.getStatistics());
        Assert.assertEquals((Object)expected.getUserEmail(), (Object)value.getUserEmail());
        Assert.assertEquals((Object)expected.getConfiguration(), (Object)value.getConfiguration());
    }
}

