/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.ScriptStackFrame;
import com.google.api.services.bigquery.model.ScriptStatistics;
import com.google.api.services.bigquery.model.SessionInfo;
import com.google.api.services.bigquery.model.TransactionInfo;
import com.google.cloud.bigquery.BiEngineReason;
import com.google.cloud.bigquery.BiEngineStats;
import com.google.cloud.bigquery.DmlStats;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.MetadataCacheStats;
import com.google.cloud.bigquery.QueryStage;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.SearchStats;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableMetadataCacheUsage;
import com.google.cloud.bigquery.TimelineSample;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class JobStatisticsTest {
    private static final BiEngineReason BI_ENGINE_REASON = BiEngineReason.newBuilder().setMessage("Detected unsupported join type").setCode("UNSUPPORTED_SQL_TEXT").build();
    private static final BiEngineStats BI_ENGINE_STATS = BiEngineStats.newBuilder().setBiEngineReasons((List)ImmutableList.of((Object)BI_ENGINE_REASON)).setBiEngineMode("DISABLED").build();
    private static final Integer BILLING_TIER = 42;
    private static final Boolean CACHE_HIT = true;
    private static final String DDL_OPERATION_PERFORMED = "SKIP";
    private static final String EVALUATIONKIND_TYPE_STATEMENT = "STATEMENT";
    private static final String EVALUATIONKIND_TYPE_EXPRESSION = "EXPRESSION";
    private static final TableId DDL_TARGET_TABLE = TableId.of((String)"foo", (String)"bar", (String)"baz");
    private static final RoutineId DDL_TARGET_ROUTINE = RoutineId.of((String)"alpha", (String)"beta", (String)"gamma");
    private static final Long ESTIMATE_BYTES_PROCESSED = 101L;
    private static final Long NUM_DML_AFFECTED_ROWS = 88L;
    private static final Long DELETED_ROW_COUNT = 10L;
    private static final Long INSERTED_ROW_COUNT = 20L;
    private static final Long UPDATED_ROW_COUNT = 30L;
    private static final DmlStats DML_STATS = DmlStats.newBuilder().setDeletedRowCount(DELETED_ROW_COUNT).setInsertedRowCount(INSERTED_ROW_COUNT).setUpdatedRowCount(UPDATED_ROW_COUNT).build();
    private static final Long EXPORT_DATA_STATS_ROW_COUNT = 3L;
    private static final Long EXPORT_DATA_STATS_FILE_COUNT = 2L;
    private static final JobStatistics.QueryStatistics.ExportDataStats EXPORT_DATA_STATS = JobStatistics.QueryStatistics.ExportDataStats.newBuilder().setRowCount(EXPORT_DATA_STATS_ROW_COUNT).setFileCount(EXPORT_DATA_STATS_FILE_COUNT).build();
    private static final JobStatistics.QueryStatistics.StatementType STATEMENT_TYPE = JobStatistics.QueryStatistics.StatementType.SELECT;
    private static final Long TOTAL_BYTES_BILLED = 24L;
    private static final Long TOTAL_BYTES_PROCESSED = 42L;
    private static final Long TOTAL_PARTITION_PROCESSED = 63L;
    private static final Long TOTAL_SLOT_MS = 10202L;
    private static final Long INPUT_BYTES = 1L;
    private static final Long INPUT_FILES = 2L;
    private static final Long OUTPUT_BYTES = 3L;
    private static final Long OUTPUT_ROWS = 4L;
    private static final Long BAD_RECORDS = 1L;
    private static final List<TableId> REFERENCED_TABLES = ImmutableList.of((Object)TableId.of((String)"foo", (String)"bar", (String)"table1"), (Object)TableId.of((String)"foo", (String)"bar", (String)"table2"));
    private static final List<Long> FILE_COUNT = ImmutableList.of((Object)1L, (Object)2L, (Object)3L);
    private static final Long CREATION_TIME = 10L;
    private static final Long END_TIME = 20L;
    private static final Long START_TIME = 15L;
    private static final String NAME = "reservation-name";
    private static final Long SLOTMS = 12545L;
    private static final String TRANSACTION_ID = UUID.randomUUID().toString().substring(0, 8);
    private static final String SESSION_ID = UUID.randomUUID().toString().substring(0, 8);
    private static final Long COPIED_ROW = 1L;
    private static final Long COPIED_LOGICAL_BYTES = 2L;
    private static final JobStatistics.CopyStatistics COPY_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.newBuilder().setCreationTimestamp(CREATION_TIME)).setEndTime(END_TIME)).setStartTime(START_TIME)).setCopiedRows(COPIED_ROW.longValue()).setCopiedLogicalBytes(COPIED_LOGICAL_BYTES.longValue()).setTotalSlotMs(TOTAL_SLOT_MS)).build();
    private static final JobStatistics.ExtractStatistics EXTRACT_STATISTICS = ((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)JobStatistics.ExtractStatistics.newBuilder().setCreationTimestamp(CREATION_TIME)).setEndTime(END_TIME)).setStartTime(START_TIME)).setDestinationUriFileCounts(FILE_COUNT).setInputBytes(INPUT_BYTES).setTotalSlotMs(TOTAL_SLOT_MS)).build();
    private static final JobStatistics.LoadStatistics LOAD_STATISTICS = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.newBuilder().setCreationTimestamp(CREATION_TIME)).setEndTime(END_TIME)).setStartTime(START_TIME)).setInputBytes(INPUT_BYTES).setInputFiles(INPUT_FILES).setOutputBytes(OUTPUT_BYTES).setOutputRows(OUTPUT_ROWS).setBadRecords(BAD_RECORDS).setTotalSlotMs(TOTAL_SLOT_MS)).build();
    private static final JobStatistics.LoadStatistics LOAD_STATISTICS_INCOMPLETE = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.newBuilder().setCreationTimestamp(CREATION_TIME)).setEndTime(END_TIME)).setStartTime(START_TIME)).setInputBytes(INPUT_BYTES).setInputFiles(INPUT_FILES).setBadRecords(BAD_RECORDS).setTotalSlotMs(TOTAL_SLOT_MS)).build();
    private static final List<String> SUBSTEPS1 = ImmutableList.of((Object)"substep1", (Object)"substep2");
    private static final List<String> SUBSTEPS2 = ImmutableList.of((Object)"substep3", (Object)"substep4");
    private static final QueryStage.QueryStep QUERY_STEP1 = new QueryStage.QueryStep("KIND", SUBSTEPS1);
    private static final QueryStage.QueryStep QUERY_STEP2 = new QueryStage.QueryStep("KIND", SUBSTEPS2);
    private static final QueryStage QUERY_STAGE = QueryStage.newBuilder().setComputeRatioAvg(1.1).setComputeRatioMax(2.2).setGeneratedId(42L).setName("stage").setReadRatioAvg(3.3).setReadRatioMax(4.4).setRecordsRead(5L).setRecordsWritten(6L).setSteps((List)ImmutableList.of((Object)QUERY_STEP1, (Object)QUERY_STEP2)).setWaitRatioAvg(7.7).setWaitRatioMax(8.8).setWriteRatioAvg(9.9).setWriteRatioMax(10.1).build();
    private static final TimelineSample TIMELINE_SAMPLE1 = TimelineSample.newBuilder().setElapsedMs(Long.valueOf(1001L)).setActiveUnits(Long.valueOf(100L)).setCompletedUnits(Long.valueOf(200L)).setPendingUnits(Long.valueOf(50L)).setSlotMillis(Long.valueOf(12345L)).build();
    private static final TimelineSample TIMELINE_SAMPLE2 = TimelineSample.newBuilder().setElapsedMs(Long.valueOf(2002L)).setActiveUnits(Long.valueOf(48L)).setCompletedUnits(Long.valueOf(302L)).setPendingUnits(Long.valueOf(0L)).setSlotMillis(Long.valueOf(23456L)).build();
    private static final List<TimelineSample> TIMELINE = ImmutableList.of((Object)TIMELINE_SAMPLE1, (Object)TIMELINE_SAMPLE2);
    private static final List<QueryStage> QUERY_PLAN = ImmutableList.of((Object)QUERY_STAGE);
    private static final Schema SCHEMA = Schema.of((Field[])new Field[]{Field.of((String)"column", (LegacySQLTypeName)LegacySQLTypeName.DATETIME, (Field[])new Field[0])});
    private static final String UNUSED_INDEX_USAGE_MODE = "UNUSED";
    private static final SearchStats SEARCH_STATS = SearchStats.newBuilder().setIndexUsageMode("UNUSED").build();
    private static final MetadataCacheStats METADATA_CACHE_STATS = MetadataCacheStats.newBuilder().setTableMetadataCacheUsage((List)ImmutableList.of((Object)TableMetadataCacheUsage.newBuilder().setExplanation("test explanation").build())).build();
    private static final JobStatistics.QueryStatistics QUERY_STATISTICS = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(CREATION_TIME)).setEndTime(END_TIME)).setStartTime(START_TIME)).setBiEngineStats(BI_ENGINE_STATS).setBillingTier(BILLING_TIER).setCacheHit(CACHE_HIT).setDDLOperationPerformed("SKIP").setDDLTargetTable(DDL_TARGET_TABLE).setDDLTargetRoutine(DDL_TARGET_ROUTINE).setEstimatedBytesProcessed(ESTIMATE_BYTES_PROCESSED).setNumDmlAffectedRows(NUM_DML_AFFECTED_ROWS).setDmlStats(DML_STATS).setExportDataStats(EXPORT_DATA_STATS).setReferenceTables(REFERENCED_TABLES).setStatementType(STATEMENT_TYPE).setTotalBytesBilled(TOTAL_BYTES_BILLED).setTotalBytesProcessed(TOTAL_BYTES_PROCESSED).setTotalPartitionsProcessed(TOTAL_PARTITION_PROCESSED).setTotalSlotMs(TOTAL_SLOT_MS)).setQueryPlan(QUERY_PLAN).setTimeline(TIMELINE).setSchema(SCHEMA).setSearchStats(SEARCH_STATS).setMetadataCacheStats(METADATA_CACHE_STATS).build();
    private static final JobStatistics.QueryStatistics QUERY_STATISTICS_INCOMPLETE = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(CREATION_TIME)).setEndTime(END_TIME)).setStartTime(START_TIME)).setBillingTier(BILLING_TIER).setCacheHit(CACHE_HIT).setSearchStats(SEARCH_STATS).setMetadataCacheStats(METADATA_CACHE_STATS).build();
    private static final JobStatistics.ScriptStatistics.ScriptStackFrame STATEMENT_STACK_FRAME = JobStatistics.ScriptStatistics.ScriptStackFrame.newBuilder().setEndColumn(Integer.valueOf(2)).setEndLine(Integer.valueOf(16)).setProcedureId("test-procedureId").setStartColumn(Integer.valueOf(1)).setStartLine(Integer.valueOf(16)).setText("SELECT\n  name AS shakespeare_name\nFROM UNNEST(top_names) AS name\nWHERE name IN (\n  SELECT word\n  FROM `bigquery-public-data`.samples.shakespeare\n)").build();
    private static final JobStatistics.ScriptStatistics.ScriptStackFrame EXPRESSION_STACK_FRAME = JobStatistics.ScriptStatistics.ScriptStackFrame.newBuilder().setEndColumn(Integer.valueOf(2)).setEndLine(Integer.valueOf(8)).setProcedureId("test-procedureId").setStartColumn(Integer.valueOf(17)).setStartLine(Integer.valueOf(4)).setText("SELECT ARRAY_AGG(name ORDER BY number DESC LIMIT 100)\n  FROM `bigquery-public-data`.usa_names.usa_1910_current\n  WHERE year = 2017").build();
    private static final JobStatistics.ScriptStatistics STATEMENT_SCRIPT_STATISTICS = JobStatistics.ScriptStatistics.newBuilder().setEvaluationKind("STATEMENT").setStackFrames((List)ImmutableList.of((Object)STATEMENT_STACK_FRAME)).build();
    private static final JobStatistics.ScriptStatistics EXPRESSION_SCRIPT_STATISTICS = JobStatistics.ScriptStatistics.newBuilder().setEvaluationKind("EXPRESSION").setStackFrames((List)ImmutableList.of((Object)EXPRESSION_STACK_FRAME)).build();
    private static final JobStatistics.ReservationUsage RESERVATION_USAGE = JobStatistics.ReservationUsage.newBuilder().setName("reservation-name").setSlotMs(SLOTMS).build();
    private static final JobStatistics.TransactionInfo TRANSACTION_INFO = JobStatistics.TransactionInfo.newbuilder().setTransactionId(TRANSACTION_ID).build();
    private static final JobStatistics.SessionInfo SESSION_INFO = JobStatistics.SessionInfo.newBuilder().setSessionId(SESSION_ID).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)CREATION_TIME, (Object)EXTRACT_STATISTICS.getCreationTime());
        Assert.assertEquals((Object)START_TIME, (Object)EXTRACT_STATISTICS.getStartTime());
        Assert.assertEquals((Object)END_TIME, (Object)EXTRACT_STATISTICS.getEndTime());
        Assert.assertEquals((Object)TOTAL_SLOT_MS, (Object)EXTRACT_STATISTICS.getTotalSlotMs());
        Assert.assertEquals(FILE_COUNT, (Object)EXTRACT_STATISTICS.getDestinationUriFileCounts());
        Assert.assertEquals((Object)INPUT_BYTES, (Object)EXTRACT_STATISTICS.getInputBytes());
        Assert.assertEquals((Object)CREATION_TIME, (Object)COPY_STATISTICS.getCreationTime());
        Assert.assertEquals((Object)START_TIME, (Object)COPY_STATISTICS.getStartTime());
        Assert.assertEquals((Object)END_TIME, (Object)COPY_STATISTICS.getEndTime());
        Assert.assertEquals((Object)TOTAL_SLOT_MS, (Object)COPY_STATISTICS.getTotalSlotMs());
        Assert.assertEquals((Object)COPIED_LOGICAL_BYTES, (Object)COPY_STATISTICS.getCopiedLogicalBytes());
        Assert.assertEquals((Object)COPIED_ROW, (Object)COPY_STATISTICS.getCopiedRows());
        Assert.assertEquals((Object)CREATION_TIME, (Object)LOAD_STATISTICS.getCreationTime());
        Assert.assertEquals((Object)START_TIME, (Object)LOAD_STATISTICS.getStartTime());
        Assert.assertEquals((Object)END_TIME, (Object)LOAD_STATISTICS.getEndTime());
        Assert.assertEquals((Object)TOTAL_SLOT_MS, (Object)LOAD_STATISTICS.getTotalSlotMs());
        Assert.assertEquals((Object)INPUT_BYTES, (Object)LOAD_STATISTICS.getInputBytes());
        Assert.assertEquals((Object)INPUT_FILES, (Object)LOAD_STATISTICS.getInputFiles());
        Assert.assertEquals((Object)OUTPUT_BYTES, (Object)LOAD_STATISTICS.getOutputBytes());
        Assert.assertEquals((Object)OUTPUT_ROWS, (Object)LOAD_STATISTICS.getOutputRows());
        Assert.assertEquals((Object)BAD_RECORDS, (Object)LOAD_STATISTICS.getBadRecords());
        Assert.assertEquals((Object)CREATION_TIME, (Object)QUERY_STATISTICS.getCreationTime());
        Assert.assertEquals((Object)START_TIME, (Object)QUERY_STATISTICS.getStartTime());
        Assert.assertEquals((Object)END_TIME, (Object)QUERY_STATISTICS.getEndTime());
        Assert.assertEquals((Object)TOTAL_SLOT_MS, (Object)QUERY_STATISTICS.getTotalSlotMs());
        Assert.assertEquals((Object)BI_ENGINE_STATS, (Object)QUERY_STATISTICS.getBiEngineStats());
        Assert.assertEquals((Object)BILLING_TIER, (Object)QUERY_STATISTICS.getBillingTier());
        Assert.assertEquals((Object)CACHE_HIT, (Object)QUERY_STATISTICS.getCacheHit());
        Assert.assertEquals((Object)DDL_OPERATION_PERFORMED, (Object)QUERY_STATISTICS.getDdlOperationPerformed());
        Assert.assertEquals((Object)DDL_TARGET_TABLE, (Object)QUERY_STATISTICS.getDdlTargetTable());
        Assert.assertEquals((Object)DDL_TARGET_ROUTINE, (Object)QUERY_STATISTICS.getDdlTargetRoutine());
        Assert.assertEquals((Object)ESTIMATE_BYTES_PROCESSED, (Object)QUERY_STATISTICS.getEstimatedBytesProcessed());
        Assert.assertEquals((Object)NUM_DML_AFFECTED_ROWS, (Object)QUERY_STATISTICS.getNumDmlAffectedRows());
        Assert.assertEquals((Object)DML_STATS, (Object)QUERY_STATISTICS.getDmlStats());
        Assert.assertEquals((Object)EXPORT_DATA_STATS, (Object)QUERY_STATISTICS.getExportDataStats());
        Assert.assertEquals(REFERENCED_TABLES, (Object)QUERY_STATISTICS.getReferencedTables());
        Assert.assertEquals((Object)STATEMENT_TYPE, (Object)QUERY_STATISTICS.getStatementType());
        Assert.assertEquals((Object)TOTAL_BYTES_BILLED, (Object)QUERY_STATISTICS.getTotalBytesBilled());
        Assert.assertEquals((Object)TOTAL_BYTES_PROCESSED, (Object)QUERY_STATISTICS.getTotalBytesProcessed());
        Assert.assertEquals((Object)TOTAL_PARTITION_PROCESSED, (Object)QUERY_STATISTICS.getTotalPartitionsProcessed());
        Assert.assertEquals(QUERY_PLAN, (Object)QUERY_STATISTICS.getQueryPlan());
        Assert.assertEquals(TIMELINE, (Object)QUERY_STATISTICS.getTimeline());
        Assert.assertEquals((Object)CREATION_TIME, (Object)LOAD_STATISTICS_INCOMPLETE.getCreationTime());
        Assert.assertEquals((Object)START_TIME, (Object)LOAD_STATISTICS_INCOMPLETE.getStartTime());
        Assert.assertEquals((Object)END_TIME, (Object)LOAD_STATISTICS_INCOMPLETE.getEndTime());
        Assert.assertEquals((Object)INPUT_BYTES, (Object)LOAD_STATISTICS_INCOMPLETE.getInputBytes());
        Assert.assertEquals((Object)INPUT_FILES, (Object)LOAD_STATISTICS_INCOMPLETE.getInputFiles());
        Assert.assertEquals((Object)BAD_RECORDS, (Object)LOAD_STATISTICS_INCOMPLETE.getBadRecords());
        Assert.assertEquals(null, (Object)LOAD_STATISTICS_INCOMPLETE.getOutputBytes());
        Assert.assertEquals(null, (Object)LOAD_STATISTICS_INCOMPLETE.getOutputRows());
        Assert.assertEquals((Object)CREATION_TIME, (Object)QUERY_STATISTICS_INCOMPLETE.getCreationTime());
        Assert.assertEquals((Object)START_TIME, (Object)QUERY_STATISTICS_INCOMPLETE.getStartTime());
        Assert.assertEquals((Object)END_TIME, (Object)QUERY_STATISTICS_INCOMPLETE.getEndTime());
        Assert.assertEquals((Object)BILLING_TIER, (Object)QUERY_STATISTICS_INCOMPLETE.getBillingTier());
        Assert.assertEquals((Object)CACHE_HIT, (Object)QUERY_STATISTICS_INCOMPLETE.getCacheHit());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getDdlOperationPerformed());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getDdlTargetTable());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getDdlTargetRoutine());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getEstimatedBytesProcessed());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getNumDmlAffectedRows());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getTotalBytesBilled());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getTotalBytesProcessed());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getTotalPartitionsProcessed());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getTotalSlotMs());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getReferencedTables());
        Assert.assertEquals(null, (Object)QUERY_STATISTICS_INCOMPLETE.getQueryPlan());
        Assert.assertEquals((Object)EVALUATIONKIND_TYPE_STATEMENT, (Object)STATEMENT_SCRIPT_STATISTICS.getEvaluationKind());
        Assert.assertEquals((Object)ImmutableList.of((Object)STATEMENT_STACK_FRAME), (Object)STATEMENT_SCRIPT_STATISTICS.getStackFrames());
        Assert.assertEquals((Object)EVALUATIONKIND_TYPE_EXPRESSION, (Object)EXPRESSION_SCRIPT_STATISTICS.getEvaluationKind());
        Assert.assertEquals((Object)ImmutableList.of((Object)EXPRESSION_STACK_FRAME), (Object)EXPRESSION_SCRIPT_STATISTICS.getStackFrames());
        Assert.assertEquals((Object)NAME, (Object)RESERVATION_USAGE.getName());
        Assert.assertEquals((Object)SLOTMS, (Object)RESERVATION_USAGE.getSlotMs());
        Assert.assertEquals((Object)TRANSACTION_ID, (Object)TRANSACTION_INFO.getTransactionId());
        Assert.assertEquals((Object)SESSION_ID, (Object)SESSION_INFO.getSessionId());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareExtractStatistics(EXTRACT_STATISTICS, JobStatistics.ExtractStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)EXTRACT_STATISTICS.toPb()));
        this.compareCopyStatistics(COPY_STATISTICS, JobStatistics.CopyStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)COPY_STATISTICS.toPb()));
        this.compareLoadStatistics(LOAD_STATISTICS, JobStatistics.LoadStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)LOAD_STATISTICS.toPb()));
        this.compareQueryStatistics(QUERY_STATISTICS, JobStatistics.QueryStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)QUERY_STATISTICS.toPb()));
        this.compareStatistics((JobStatistics)COPY_STATISTICS, (JobStatistics)JobStatistics.CopyStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)COPY_STATISTICS.toPb()));
        this.compareLoadStatistics(LOAD_STATISTICS_INCOMPLETE, JobStatistics.LoadStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)LOAD_STATISTICS_INCOMPLETE.toPb()));
        this.compareQueryStatistics(QUERY_STATISTICS_INCOMPLETE, JobStatistics.QueryStatistics.fromPb((com.google.api.services.bigquery.model.JobStatistics)QUERY_STATISTICS_INCOMPLETE.toPb()));
        this.compareScriptStatistics(STATEMENT_SCRIPT_STATISTICS, JobStatistics.ScriptStatistics.fromPb((ScriptStatistics)STATEMENT_SCRIPT_STATISTICS.toPb()));
        this.compareScriptStatistics(EXPRESSION_SCRIPT_STATISTICS, JobStatistics.ScriptStatistics.fromPb((ScriptStatistics)EXPRESSION_SCRIPT_STATISTICS.toPb()));
        for (JobStatistics.ScriptStatistics.ScriptStackFrame stackFrame : STATEMENT_SCRIPT_STATISTICS.getStackFrames()) {
            this.compareStackFrames(stackFrame, JobStatistics.ScriptStatistics.ScriptStackFrame.fromPb((ScriptStackFrame)stackFrame.toPb()));
        }
        for (JobStatistics.ScriptStatistics.ScriptStackFrame stackFrame : EXPRESSION_SCRIPT_STATISTICS.getStackFrames()) {
            this.compareStackFrames(stackFrame, JobStatistics.ScriptStatistics.ScriptStackFrame.fromPb((ScriptStackFrame)stackFrame.toPb()));
        }
        this.compareReservation(RESERVATION_USAGE, JobStatistics.ReservationUsage.fromPb((JobStatistics.ReservationUsage)RESERVATION_USAGE.toPb()));
        this.compareTransactionInfo(TRANSACTION_INFO, JobStatistics.TransactionInfo.fromPb((TransactionInfo)TRANSACTION_INFO.toPb()));
        this.compareSessionInfo(SESSION_INFO, JobStatistics.SessionInfo.fromPb((SessionInfo)SESSION_INFO.toPb()));
    }

    @Test
    public void testIncomplete() {
        Job job = new Job().setStatistics(new com.google.api.services.bigquery.model.JobStatistics().setCreationTime(Long.valueOf(1234L)).setStartTime(Long.valueOf(5678L)));
        job.setConfiguration(new JobConfiguration().setCopy(new JobConfigurationTableCopy()));
        JobStatistics jobStatistics = JobStatistics.fromPb((Job)job);
        Truth.assertThat((Object)jobStatistics).isInstanceOf(JobStatistics.CopyStatistics.class);
        job.setConfiguration(new JobConfiguration().setLoad(new JobConfigurationLoad()));
        jobStatistics = JobStatistics.fromPb((Job)job);
        Truth.assertThat((Object)jobStatistics).isInstanceOf(JobStatistics.LoadStatistics.class);
        job.setConfiguration(new JobConfiguration().setExtract(new JobConfigurationExtract()));
        jobStatistics = JobStatistics.fromPb((Job)job);
        Truth.assertThat((Object)jobStatistics).isInstanceOf(JobStatistics.ExtractStatistics.class);
        job.setConfiguration(new JobConfiguration().setQuery(new JobConfigurationQuery()));
        jobStatistics = JobStatistics.fromPb((Job)job);
        Truth.assertThat((Object)jobStatistics).isInstanceOf(JobStatistics.QueryStatistics.class);
    }

    private void compareExtractStatistics(JobStatistics.ExtractStatistics expected, JobStatistics.ExtractStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.getDestinationUriFileCounts(), (Object)value.getDestinationUriFileCounts());
        Assert.assertEquals((Object)expected.getInputBytes(), (Object)value.getInputBytes());
    }

    private void compareCopyStatistics(JobStatistics.CopyStatistics expected, JobStatistics.CopyStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.getCopiedLogicalBytes(), (Object)value.getCopiedLogicalBytes());
        Assert.assertEquals((Object)expected.getCopiedRows(), (Object)value.getCopiedRows());
    }

    private void compareLoadStatistics(JobStatistics.LoadStatistics expected, JobStatistics.LoadStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.getInputBytes(), (Object)value.getInputBytes());
        Assert.assertEquals((Object)expected.getInputFiles(), (Object)value.getInputFiles());
        Assert.assertEquals((Object)expected.getOutputBytes(), (Object)value.getOutputBytes());
        Assert.assertEquals((Object)expected.getOutputRows(), (Object)value.getOutputRows());
    }

    private void compareQueryStatistics(JobStatistics.QueryStatistics expected, JobStatistics.QueryStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareStatistics((JobStatistics)expected, (JobStatistics)value);
        Assert.assertEquals((Object)expected.getBillingTier(), (Object)value.getBillingTier());
        Assert.assertEquals((Object)expected.getCacheHit(), (Object)value.getCacheHit());
        Assert.assertEquals((Object)expected.getDdlOperationPerformed(), (Object)value.getDdlOperationPerformed());
        Assert.assertEquals((Object)expected.getDdlTargetTable(), (Object)value.getDdlTargetTable());
        Assert.assertEquals((Object)expected.getDdlTargetRoutine(), (Object)value.getDdlTargetRoutine());
        Assert.assertEquals((Object)expected.getEstimatedBytesProcessed(), (Object)value.getEstimatedBytesProcessed());
        Assert.assertEquals((Object)expected.getTotalBytesBilled(), (Object)value.getTotalBytesBilled());
        Assert.assertEquals((Object)expected.getTotalBytesProcessed(), (Object)value.getTotalBytesProcessed());
        Assert.assertEquals((Object)expected.getTotalPartitionsProcessed(), (Object)value.getTotalPartitionsProcessed());
        Assert.assertEquals((Object)expected.getTotalSlotMs(), (Object)value.getTotalSlotMs());
        Assert.assertEquals((Object)expected.getQueryPlan(), (Object)value.getQueryPlan());
        Assert.assertEquals((Object)expected.getReferencedTables(), (Object)value.getReferencedTables());
        Assert.assertEquals((Object)expected.getSchema(), (Object)value.getSchema());
        Assert.assertEquals((Object)expected.getSearchStats().getIndexUsageMode(), (Object)value.getSearchStats().getIndexUsageMode());
        Assert.assertEquals((Object)expected.getMetadataCacheStats(), (Object)value.getMetadataCacheStats());
        Assert.assertEquals((Object)expected.getStatementType(), (Object)value.getStatementType());
        Assert.assertEquals((Object)expected.getTimeline(), (Object)value.getTimeline());
        Assert.assertEquals((Object)expected.getDmlStats(), (Object)value.getDmlStats());
        Assert.assertEquals((Object)expected.getExportDataStats(), (Object)value.getExportDataStats());
    }

    private void compareStatistics(JobStatistics expected, JobStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getEndTime(), (Object)value.getEndTime());
        Assert.assertEquals((Object)expected.getStartTime(), (Object)value.getStartTime());
        Assert.assertEquals((Object)expected.getNumChildJobs(), (Object)value.getNumChildJobs());
        Assert.assertEquals((Object)expected.getParentJobId(), (Object)value.getParentJobId());
        Assert.assertEquals((Object)expected.getScriptStatistics(), (Object)value.getScriptStatistics());
        Assert.assertEquals((Object)expected.getTotalSlotMs(), (Object)value.getTotalSlotMs());
    }

    private void compareScriptStatistics(JobStatistics.ScriptStatistics expected, JobStatistics.ScriptStatistics value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)expected.toString());
        Assert.assertEquals((Object)expected.getEvaluationKind(), (Object)value.getEvaluationKind());
        Assert.assertEquals((Object)expected.getStackFrames(), (Object)value.getStackFrames());
    }

    private void compareStackFrames(JobStatistics.ScriptStatistics.ScriptStackFrame expected, JobStatistics.ScriptStatistics.ScriptStackFrame value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getEndColumn(), (Object)value.getEndColumn());
        Assert.assertEquals((Object)expected.getEndLine(), (Object)value.getEndLine());
        Assert.assertEquals((Object)expected.getProcedureId(), (Object)value.getProcedureId());
        Assert.assertEquals((Object)expected.getStartColumn(), (Object)value.getStartColumn());
        Assert.assertEquals((Object)expected.getStartLine(), (Object)value.getStartLine());
        Assert.assertEquals((Object)expected.getText(), (Object)value.getText());
    }

    private void compareReservation(JobStatistics.ReservationUsage expected, JobStatistics.ReservationUsage value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.toPb(), (Object)value.toPb());
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getSlotMs(), (Object)value.getSlotMs());
    }

    private void compareTransactionInfo(JobStatistics.TransactionInfo expected, JobStatistics.TransactionInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.toPb(), (Object)value.toPb());
        Assert.assertEquals((Object)expected.getTransactionId(), (Object)value.getTransactionId());
    }

    private void compareSessionInfo(JobStatistics.SessionInfo expected, JobStatistics.SessionInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.toPb(), (Object)value.toPb());
        Assert.assertEquals((Object)expected.getSessionId(), (Object)value.getSessionId());
    }
}

