/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.JobStatus;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JobStatusTest {
    private static final JobStatus.State STATE = JobStatus.State.DONE;
    private static final BigQueryError ERROR = new BigQueryError("reason", "location", "message", "debugInfo");
    private static final List<BigQueryError> ALL_ERRORS = ImmutableList.of((Object)new BigQueryError("reason1", "location1", "message1", "debugInfo1"), (Object)new BigQueryError("reason2", "location2", "message2", "debugInfo2"));
    private static final JobStatus JOB_STATUS = new JobStatus(STATE, ERROR, ALL_ERRORS);
    private static final JobStatus JOB_STATUS_INCOMPLETE1 = new JobStatus(STATE, ERROR, null);
    private static final JobStatus JOB_STATUS_INCOMPLETE2 = new JobStatus(STATE, null, null);

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)STATE, (Object)JOB_STATUS.getState());
        Assert.assertEquals((Object)ERROR, (Object)JOB_STATUS.getError());
        Assert.assertEquals(ALL_ERRORS, (Object)JOB_STATUS.getExecutionErrors());
        Assert.assertEquals((Object)STATE, (Object)JOB_STATUS_INCOMPLETE1.getState());
        Assert.assertEquals((Object)ERROR, (Object)JOB_STATUS_INCOMPLETE1.getError());
        Assert.assertEquals(null, (Object)JOB_STATUS_INCOMPLETE1.getExecutionErrors());
        Assert.assertEquals((Object)STATE, (Object)JOB_STATUS_INCOMPLETE2.getState());
        Assert.assertEquals(null, (Object)JOB_STATUS_INCOMPLETE2.getError());
        Assert.assertEquals(null, (Object)JOB_STATUS_INCOMPLETE2.getExecutionErrors());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareStatus(JOB_STATUS, JobStatus.fromPb((com.google.api.services.bigquery.model.JobStatus)JOB_STATUS.toPb()));
        this.compareStatus(JOB_STATUS_INCOMPLETE1, JobStatus.fromPb((com.google.api.services.bigquery.model.JobStatus)JOB_STATUS_INCOMPLETE1.toPb()));
        this.compareStatus(JOB_STATUS_INCOMPLETE2, JobStatus.fromPb((com.google.api.services.bigquery.model.JobStatus)JOB_STATUS_INCOMPLETE2.toPb()));
    }

    private void compareStatus(JobStatus expected, JobStatus value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getState(), (Object)value.getState());
        Assert.assertEquals((Object)expected.getError(), (Object)value.getError());
        Assert.assertEquals((Object)expected.getExecutionErrors(), (Object)value.getExecutionErrors());
    }
}

