/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.CurrentMillisClock;
import com.google.api.gax.paging.Page;
import com.google.api.gax.paging.Pages;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.truth.Truth;
import java.time.Duration;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class JobTest {
    private static final JobId JOB_ID = JobId.of((String)"project", (String)"job");
    private static final TableId TABLE_ID1 = TableId.of((String)"dataset", (String)"table1");
    private static final TableId TABLE_ID2 = TableId.of((String)"dataset", (String)"table2");
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "id";
    private static final String SELF_LINK = "selfLink";
    private static final String EMAIL = "email";
    private static final JobStatus JOB_STATUS = new JobStatus(JobStatus.State.DONE);
    private static final JobStatistics COPY_JOB_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
    private static final CopyJobConfiguration COPY_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID1, (TableId)TABLE_ID2);
    private static final QueryJobConfiguration DDL_QUERY_CONFIGURATION = QueryJobConfiguration.newBuilder((String)"CREATE VIEW").setDestinationTable(TABLE_ID1).build();
    private static final QueryJobConfiguration DRL_QUERY_CONFIGURATION = QueryJobConfiguration.newBuilder((String)"SELECT 1").setDestinationTable(TABLE_ID1).build();
    private static final JobInfo JOB_INFO = JobInfo.newBuilder((JobConfiguration)COPY_CONFIGURATION).setJobId(JOB_ID).setStatistics(COPY_JOB_STATISTICS).setJobId(JOB_ID).setEtag("etag").setGeneratedId("id").setSelfLink("selfLink").setUserEmail("email").setStatus(JOB_STATUS).build();
    private static final RetryOption[] TEST_RETRY_OPTIONS = new RetryOption[]{RetryOption.totalTimeoutDuration((Duration)Duration.ofSeconds(3L)), RetryOption.initialRetryDelayDuration((Duration)Duration.ofMillis(1L)), RetryOption.jittered((boolean)false), RetryOption.retryDelayMultiplier((double)1.0)};
    private static final BigQueryRetryConfig TEST_BIGQUERY_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().retryOnMessage(new String[]{"Exceeded rate limits:"}).build();
    @Rule
    public MockitoRule rule;
    private BigQuery bigquery;
    private BigQueryOptions mockOptions;
    private Job expectedJob;
    private Job job;

    @Before
    public void setUp() {
        this.bigquery = (BigQuery)Mockito.mock(BigQuery.class);
        this.mockOptions = (BigQueryOptions)Mockito.mock(BigQueryOptions.class);
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        this.expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(JOB_INFO));
        this.job = new Job(this.bigquery, new JobInfo.BuilderImpl(JOB_INFO));
    }

    @Test
    public void testBuilder() {
        Job builtJob = new Job.Builder(this.bigquery, (JobConfiguration)COPY_CONFIGURATION).setJobId(JOB_ID).setStatistics(COPY_JOB_STATISTICS).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        Assert.assertEquals((Object)ETAG, (Object)builtJob.getEtag());
        Assert.assertEquals((Object)GENERATED_ID, (Object)builtJob.getGeneratedId());
        Assert.assertEquals((Object)SELF_LINK, (Object)builtJob.getSelfLink());
        Assert.assertEquals((Object)EMAIL, (Object)builtJob.getUserEmail());
        Assert.assertEquals((Object)JOB_ID, (Object)builtJob.getJobId());
        Assert.assertEquals((Object)JOB_STATUS, (Object)builtJob.getStatus());
        Assert.assertEquals((Object)COPY_CONFIGURATION, (Object)builtJob.getConfiguration());
        Assert.assertEquals((Object)COPY_JOB_STATISTICS, (Object)builtJob.getStatistics());
        Assert.assertSame((Object)this.bigquery, (Object)builtJob.getBigQuery());
    }

    @Test
    public void testToBuilder() {
        this.compareJob(this.expectedJob, this.expectedJob.toBuilder().build());
    }

    @Test
    public void testExists_True() {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])};
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)this.expectedJob);
        Assert.assertTrue((boolean)this.job.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testExists_False() {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])};
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn(null);
        Assert.assertFalse((boolean)this.job.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testIsDone_True() {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        Job job = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.DONE)).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)job);
        Assert.assertTrue((boolean)job.isDone());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testIsDone_False() {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        Job job = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)job);
        Assert.assertFalse((boolean)job.isDone());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testIsDone_NotExists() {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn(null);
        Assert.assertTrue((boolean)this.job.isDone());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testWaitFor() throws InterruptedException {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        JobStatus status = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)status.getState()).thenReturn((Object)JobStatus.State.DONE);
        Mockito.when((Object)status.getState()).thenReturn((Object)JobStatus.State.DONE);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job completedJob = this.expectedJob.toBuilder().setStatus(status).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)completedJob);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        Assert.assertSame((Object)completedJob, (Object)this.job.waitFor(TEST_RETRY_OPTIONS));
        ((BigQueryOptions)Mockito.verify((Object)this.mockOptions)).getClock();
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForAndGetQueryResultsEmpty() throws InterruptedException {
        JobStatistics.QueryStatistics jobStatistics = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)DDL_QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)jobStatistics).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job completedJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        QueryResponse completedQuery = QueryResponse.newBuilder().setCompleted(true).setTotalRows(0L).setSchema(Schema.of((Field[])new Field[0])).setErrors(ImmutableList.of()).build();
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        this.job = this.job.toBuilder().setConfiguration((JobConfiguration)DDL_QUERY_CONFIGURATION).build();
        Truth.assertThat((Object)this.job.waitFor(TEST_RETRY_OPTIONS)).isSameInstanceAs((Object)completedJob);
        Truth.assertThat((Iterable)this.job.getQueryResults(new BigQuery.QueryResultsOption[0]).iterateAll()).isEmpty();
        ((BigQuery)Mockito.verify((Object)this.bigquery, (VerificationMode)Mockito.times((int)2))).getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForAndGetQueryResultsEmptyWithSchema() throws InterruptedException {
        JobStatistics.QueryStatistics jobStatistics = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)DDL_QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)jobStatistics).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        JobStatus status = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job completedJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        QueryResponse completedQuery = QueryResponse.newBuilder().setCompleted(true).setTotalRows(0L).setSchema(Schema.of((Field[])new Field[]{Field.of((String)"field1", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0])})).setErrors(ImmutableList.of()).build();
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        this.job = this.job.toBuilder().setConfiguration((JobConfiguration)DDL_QUERY_CONFIGURATION).build();
        Truth.assertThat((Object)this.job.waitFor(TEST_RETRY_OPTIONS)).isSameInstanceAs((Object)completedJob);
        Truth.assertThat((Object)this.job.getQueryResults(new BigQuery.QueryResultsOption[0]).getSchema()).isEqualTo((Object)Schema.of((Field[])new Field[]{Field.of((String)"field1", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0])}));
        ((BigQuery)Mockito.verify((Object)this.bigquery, (VerificationMode)Mockito.times((int)2))).getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForAndGetQueryResults() throws InterruptedException {
        JobStatistics.QueryStatistics jobStatistics = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)DRL_QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)jobStatistics).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job completedJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        Page singlePage = Pages.empty();
        TableResult result = TableResult.newBuilder().setSchema(Schema.of((Field[])new Field[0])).setTotalRows(Long.valueOf(1L)).setPageNoSchema(singlePage).build();
        QueryResponse completedQuery = QueryResponse.newBuilder().setCompleted(true).setTotalRows(1L).setSchema(Schema.of((Field[])new Field[]{Field.of((String)"_f0", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])})).setErrors(ImmutableList.of()).build();
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        Mockito.when((Object)this.bigquery.listTableData((TableId)Mockito.eq((Object)TABLE_ID1), (Schema)Mockito.any(Schema.class), new BigQuery.TableDataListOption[0])).thenReturn((Object)result);
        this.job = this.job.toBuilder().setConfiguration((JobConfiguration)DRL_QUERY_CONFIGURATION).build();
        Truth.assertThat((Object)this.job.waitFor(TEST_RETRY_OPTIONS)).isSameInstanceAs((Object)completedJob);
        Truth.assertThat((Iterable)this.job.getQueryResults(new BigQuery.QueryResultsOption[0]).iterateAll()).hasSize(0);
        ((BigQuery)Mockito.verify((Object)this.bigquery, (VerificationMode)Mockito.times((int)2))).getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForAndGetQueryResults_Unsupported() throws InterruptedException {
        try {
            this.job.getQueryResults(new BigQuery.QueryResultsOption[0]);
            Assert.fail();
        }
        catch (UnsupportedOperationException expected) {
            Assert.assertNotNull((Object)expected.getMessage());
        }
    }

    @Test
    public void testWaitFor_Null() throws InterruptedException {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn(null);
        Assert.assertNull((Object)this.job.waitFor(TEST_RETRY_OPTIONS));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testWaitForWithCheckingPeriod() throws InterruptedException {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        JobStatus status = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)status.getState()).thenReturn((Object)JobStatus.State.RUNNING);
        Mockito.when((Object)status.getState()).thenReturn((Object)JobStatus.State.RUNNING);
        Mockito.when((Object)status.getState()).thenReturn((Object)JobStatus.State.DONE);
        Mockito.when((Object)status.getState()).thenReturn((Object)JobStatus.State.DONE);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job runningJob = this.expectedJob.toBuilder().setStatus(status).build();
        Job completedJob = this.expectedJob.toBuilder().setStatus(status).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)runningJob);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)completedJob);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        Assert.assertSame((Object)completedJob, (Object)this.job.waitFor(TEST_RETRY_OPTIONS));
        ((BigQueryOptions)Mockito.verify((Object)this.mockOptions)).getClock();
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForWithCheckingPeriod_Null() throws InterruptedException {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job runningJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)runningJob);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn(null);
        Assert.assertNull((Object)this.job.waitFor(TEST_RETRY_OPTIONS));
        ((BigQueryOptions)Mockito.verify((Object)this.mockOptions)).getClock();
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), expectedOptions);
    }

    @Test
    public void testWaitForWithTimeout() throws InterruptedException {
        BigQuery.JobOption[] expectedOptions = new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.STATUS})};
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job runningJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)runningJob);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), expectedOptions)).thenReturn((Object)runningJob);
        try {
            this.job.waitFor((RetryOption[])ObjectArrays.concat((Object[])TEST_RETRY_OPTIONS, (Object)RetryOption.totalTimeoutDuration((Duration)Duration.ofMillis(3L))));
            Assert.fail();
        }
        catch (BigQueryException expected) {
            Assert.assertNotNull((Object)expected.getMessage());
        }
    }

    @Test
    public void testWaitForWithBigQueryRetryConfig() throws InterruptedException {
        JobStatistics.QueryStatistics jobStatistics = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)DRL_QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)jobStatistics).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job completedJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        QueryResponse completedQuery = QueryResponse.newBuilder().setCompleted(true).setTotalRows(1L).setSchema(Schema.of((Field[])new Field[]{Field.of((String)"_f0", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])})).setErrors(ImmutableList.of()).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenReturn((Object)completedQuery);
        this.job = this.job.toBuilder().setConfiguration((JobConfiguration)DRL_QUERY_CONFIGURATION).build();
        Truth.assertThat((Object)this.job.waitFor(TEST_BIGQUERY_RETRY_CONFIG, TEST_RETRY_OPTIONS)).isSameInstanceAs((Object)completedJob);
        ((BigQuery)Mockito.verify((Object)this.bigquery, (VerificationMode)Mockito.times((int)1))).getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForWithBigQueryRetryConfigShouldRetry() throws InterruptedException {
        JobStatistics.QueryStatistics jobStatistics = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)DRL_QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)jobStatistics).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        Job completedJob = this.expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.RUNNING)).build();
        QueryResponse completedQuery = QueryResponse.newBuilder().setCompleted(true).setTotalRows(1L).setSchema(Schema.of((Field[])new Field[]{Field.of((String)"_f0", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])})).setErrors(ImmutableList.of()).build();
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)completedJob);
        BigQueryError bigQueryError = new BigQueryError("testReasonRateLimitExceeded", "US", "testMessage: Exceeded rate limits:");
        ImmutableList bigQueryErrorList = ImmutableList.of((Object)bigQueryError);
        BigQueryException bigQueryException = new BigQueryException((List)bigQueryErrorList);
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenThrow(new Throwable[]{bigQueryException}).thenReturn((Object)completedQuery);
        this.job = this.job.toBuilder().setConfiguration((JobConfiguration)DRL_QUERY_CONFIGURATION).build();
        Truth.assertThat((Object)this.job.waitFor(TEST_BIGQUERY_RETRY_CONFIG, TEST_RETRY_OPTIONS)).isSameInstanceAs((Object)completedJob);
        ((BigQuery)Mockito.verify((Object)this.bigquery, (VerificationMode)Mockito.times((int)2))).getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testWaitForWithBigQueryRetryConfigErrorShouldNotRetry() throws InterruptedException {
        JobStatistics.QueryStatistics jobStatistics = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
        JobInfo jobInfo = JobInfo.newBuilder((JobConfiguration)DRL_QUERY_CONFIGURATION).setJobId(JOB_ID).setStatistics((JobStatistics)jobStatistics).setJobId(JOB_ID).setEtag(ETAG).setGeneratedId(GENERATED_ID).setSelfLink(SELF_LINK).setUserEmail(EMAIL).setStatus(JOB_STATUS).build();
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        Mockito.when((Object)this.mockOptions.getClock()).thenReturn((Object)CurrentMillisClock.getDefaultClock());
        QueryResponse completedQuery = QueryResponse.newBuilder().setCompleted(true).setTotalRows(1L).setSchema(Schema.of((Field[])new Field[]{Field.of((String)"_f0", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])})).setErrors(ImmutableList.of()).build();
        BigQueryError bigQueryError = new BigQueryError("testReasonRateLimitExceeded", "US", "testMessage: do not retry error");
        ImmutableList bigQueryErrorList = ImmutableList.of((Object)bigQueryError);
        BigQueryException bigQueryException = new BigQueryException((List)bigQueryErrorList);
        Mockito.when((Object)this.bigquery.getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS)).thenThrow(new Throwable[]{bigQueryException}).thenReturn((Object)completedQuery);
        this.job = this.job.toBuilder().setConfiguration((JobConfiguration)DRL_QUERY_CONFIGURATION).build();
        try {
            this.job.waitFor(TEST_BIGQUERY_RETRY_CONFIG, TEST_RETRY_OPTIONS);
            Assert.fail((String)"JobException expected");
        }
        catch (BigQueryException e) {
            Assert.assertNotNull((Object)e.getErrors());
        }
        ((BigQuery)Mockito.verify((Object)this.bigquery, (VerificationMode)Mockito.times((int)1))).getQueryResults(jobInfo.getJobId(), Job.DEFAULT_QUERY_WAIT_OPTIONS);
    }

    @Test
    public void testReload() {
        JobInfo updatedInfo = JOB_INFO.toBuilder().setEtag(ETAG).build();
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job updatedJob = this.job.reload(new BigQuery.JobOption[0]);
        this.compareJob(expectedJob, updatedJob);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testReloadJobException() {
        JobInfo updatedInfo = JOB_INFO.toBuilder().setEtag(ETAG).build();
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(updatedInfo));
        BigQueryError bigQueryError = new BigQueryError("invalidQuery", "US", "invalidQuery");
        expectedJob = expectedJob.toBuilder().setStatus(new JobStatus(JobStatus.State.DONE, bigQueryError, null)).build();
        ImmutableList bigQueryErrorList = ImmutableList.of((Object)bigQueryError);
        BigQueryException bigQueryException = new BigQueryException((List)bigQueryErrorList);
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn((Object)expectedJob).thenThrow(new Throwable[]{bigQueryException});
        try {
            this.job.reload(new BigQuery.JobOption[0]);
            Assert.fail((String)"JobException expected");
        }
        catch (BigQueryException e) {
            Assert.assertNotNull((Object)e.getErrors());
        }
    }

    @Test
    public void testReloadNull() {
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0])).thenReturn(null);
        Assert.assertNull((Object)this.job.reload(new BigQuery.JobOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[0]);
    }

    @Test
    public void testReloadWithOptions() {
        JobInfo updatedInfo = JOB_INFO.toBuilder().setEtag(ETAG).build();
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])})).thenReturn((Object)expectedJob);
        Job updatedJob = this.job.reload(new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])});
        this.compareJob(expectedJob, updatedJob);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getJob(JOB_INFO.getJobId(), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0])});
    }

    @Test
    public void testCancel() {
        Mockito.when((Object)this.bigquery.cancel(JOB_INFO.getJobId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.job.cancel());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).cancel(JOB_INFO.getJobId());
    }

    @Test
    public void testBigQuery() {
        Assert.assertSame((Object)this.bigquery, (Object)this.expectedJob.getBigQuery());
    }

    @Test
    public void testToAndFromPb() {
        this.compareJob(this.expectedJob, Job.fromPb((BigQuery)this.bigquery, (com.google.api.services.bigquery.model.Job)this.expectedJob.toPb()));
    }

    @Test
    public void testToAndFromPbWithoutConfiguration() {
        Assert.assertNotEquals((Object)this.expectedJob, (Object)this.bigquery);
        this.compareJob(this.expectedJob, Job.fromPb((BigQuery)this.bigquery, (com.google.api.services.bigquery.model.Job)this.expectedJob.toPb()));
    }

    private void compareJob(Job expected, Job value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareJobInfo((JobInfo)expected, (JobInfo)value);
        Assert.assertEquals((Object)expected.getBigQuery().getOptions(), (Object)value.getBigQuery().getOptions());
    }

    private void compareJobInfo(JobInfo expected, JobInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getGeneratedId(), (Object)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getJobId(), (Object)value.getJobId());
        Assert.assertEquals((Object)expected.getSelfLink(), (Object)value.getSelfLink());
        Assert.assertEquals((Object)expected.getStatus(), (Object)value.getStatus());
        Assert.assertEquals((Object)expected.getStatistics(), (Object)value.getStatistics());
        Assert.assertEquals((Object)expected.getUserEmail(), (Object)value.getUserEmail());
        Assert.assertEquals((Object)expected.getConfiguration(), (Object)value.getConfiguration());
    }
}

