/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LoadJobConfigurationTest {
    private static final String TEST_PROJECT_ID = "test-project-id";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().setAllowJaggedRows(true).setAllowQuotedNewLines(false).setEncoding(StandardCharsets.UTF_8).build();
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final String FORMAT = "CSV";
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final Field FIELD_SCHEMA = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription").build();
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final List<String> DECIMAL_TARGET_TYPES = ImmutableList.of((Object)"NUMERIC", (Object)"BIGNUMERIC", (Object)"STRING");
    private static final List<JobInfo.SchemaUpdateOption> SCHEMA_UPDATE_OPTIONS = ImmutableList.of((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA});
    private static final Boolean AUTODETECT = true;
    private static final Boolean USE_AVRO_LOGICAL_TYPES = true;
    private static final boolean CREATE_SESSION = true;
    private static final EncryptionConfiguration JOB_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"test-job-name", (Object)"test-load-job");
    private static final Long TIMEOUT = 10L;
    private static final RangePartitioning.Range RANGE = RangePartitioning.Range.newBuilder().setStart(Long.valueOf(1L)).setInterval(Long.valueOf(2L)).setEnd(Long.valueOf(10L)).build();
    private static final RangePartitioning RANGE_PARTITIONING = RangePartitioning.newBuilder().setField("IntegerField").setRange(RANGE).build();
    private static final String MODE = "STRING";
    private static final String SOURCE_URI_PREFIX = "gs://bucket/path_to_table";
    private static final String KEY = "session_id";
    private static final String VALUE = "session_id_1234567890";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("session_id").setValue("session_id_1234567890").build();
    private static final List<ConnectionProperty> CONNECTION_PROPERTIES = ImmutableList.of((Object)CONNECTION_PROPERTY);
    private static final HivePartitioningOptions HIVE_PARTITIONING_OPTIONS = HivePartitioningOptions.newBuilder().setMode("STRING").setSourceUriPrefix("gs://bucket/path_to_table").build();
    private static final LoadJobConfiguration LOAD_CONFIGURATION_CSV = LoadJobConfiguration.newBuilder((TableId)TABLE_ID, SOURCE_URIS).setDecimalTargetTypes(DECIMAL_TARGET_TYPES).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setFormatOptions((FormatOptions)CSV_OPTIONS).setFileSetSpecType("FILE_SET_SPEC_TYPE_FILE_SYSTEM_MATCH").setColumnNameCharacterMap("STRICT").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setAutodetect(AUTODETECT).setDestinationEncryptionConfiguration(JOB_ENCRYPTION_CONFIGURATION).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).setRangePartitioning(RANGE_PARTITIONING).setNullMarker("nullMarker").setHivePartitioningOptions(HIVE_PARTITIONING_OPTIONS).setConnectionProperties(CONNECTION_PROPERTIES).setCreateSession(Boolean.valueOf(true)).build();
    private static final DatastoreBackupOptions BACKUP_OPTIONS = DatastoreBackupOptions.newBuilder().setProjectionFields((List)ImmutableList.of((Object)"field_1", (Object)"field_2")).build();
    private static final LoadJobConfiguration LOAD_CONFIGURATION_BACKUP = LoadJobConfiguration.newBuilder((TableId)TABLE_ID, SOURCE_URIS).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setFormatOptions((FormatOptions)BACKUP_OPTIONS).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setAutodetect(AUTODETECT).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).setRangePartitioning(RANGE_PARTITIONING).build();
    private static final LoadJobConfiguration LOAD_CONFIGURATION_AVRO = LoadJobConfiguration.newBuilder((TableId)TABLE_ID, SOURCE_URIS).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setFormatOptions((FormatOptions)FormatOptions.avro()).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setAutodetect(AUTODETECT).setDestinationEncryptionConfiguration(JOB_ENCRYPTION_CONFIGURATION).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setUseAvroLogicalTypes(USE_AVRO_LOGICAL_TYPES).setLabels(LABELS).setJobTimeoutMs(TIMEOUT).setRangePartitioning(RANGE_PARTITIONING).build();

    @Test
    public void testToBuilder() {
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_CSV, LOAD_CONFIGURATION_CSV.toBuilder().build());
        LoadJobConfiguration configurationCSV = LOAD_CONFIGURATION_CSV.toBuilder().setDestinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)configurationCSV.getDestinationTable().getTable());
        configurationCSV = configurationCSV.toBuilder().setDestinationTable(TABLE_ID).build();
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_CSV, configurationCSV);
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_BACKUP, LOAD_CONFIGURATION_BACKUP.toBuilder().build());
        LoadJobConfiguration configurationBackup = LOAD_CONFIGURATION_BACKUP.toBuilder().setDestinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)configurationBackup.getDestinationTable().getTable());
        configurationBackup = configurationBackup.toBuilder().setDestinationTable(TABLE_ID).build();
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_BACKUP, configurationBackup);
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_AVRO, LOAD_CONFIGURATION_AVRO.toBuilder().build());
        LoadJobConfiguration configurationAvro = LOAD_CONFIGURATION_AVRO.toBuilder().setDestinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)configurationAvro.getDestinationTable().getTable());
        configurationAvro = configurationAvro.toBuilder().setDestinationTable(TABLE_ID).build();
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_AVRO, configurationAvro);
    }

    @Test
    public void testOf() {
        LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.getDestinationTable());
        Assert.assertEquals(SOURCE_URIS, (Object)configuration.getSourceUris());
        configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS, (FormatOptions)CSV_OPTIONS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.getDestinationTable());
        Assert.assertEquals((Object)FORMAT, (Object)configuration.getFormat());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)configuration.getCsvOptions());
        Assert.assertEquals(SOURCE_URIS, (Object)configuration.getSourceUris());
        configuration = LoadJobConfiguration.of((TableId)TABLE_ID, (String)"uri1");
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.getDestinationTable());
        Assert.assertEquals((Object)ImmutableList.of((Object)"uri1"), (Object)configuration.getSourceUris());
        configuration = LoadJobConfiguration.of((TableId)TABLE_ID, (String)"uri1", (FormatOptions)CSV_OPTIONS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.getDestinationTable());
        Assert.assertEquals((Object)FORMAT, (Object)configuration.getFormat());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)configuration.getCsvOptions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"uri1"), (Object)configuration.getSourceUris());
    }

    @Test
    public void testToBuilderIncomplete() {
        LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
        this.compareLoadJobConfiguration(configuration, configuration.toBuilder().build());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareLoadJobConfiguration(LOAD_CONFIGURATION_CSV, LoadJobConfiguration.fromPb((JobConfiguration)LOAD_CONFIGURATION_CSV.toPb()));
        LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
        this.compareLoadJobConfiguration(configuration, LoadJobConfiguration.fromPb((JobConfiguration)configuration.toPb()));
    }

    @Test
    public void testSetProjectId() {
        LoadJobConfiguration configuration = LOAD_CONFIGURATION_CSV.setProjectId(TEST_PROJECT_ID);
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDestinationTable().getProject());
    }

    @Test
    public void testSetProjectIdDoNotOverride() {
        LoadJobConfiguration configuration = LOAD_CONFIGURATION_CSV.toBuilder().setDestinationTable(TABLE_ID.setProjectId(TEST_PROJECT_ID)).build().setProjectId("do-not-update");
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDestinationTable().getProject());
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)JobConfiguration.Type.LOAD, (Object)LOAD_CONFIGURATION_CSV.getType());
    }

    private void compareLoadJobConfiguration(LoadJobConfiguration expected, LoadJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.getFileSetSpecType(), (Object)value.getFileSetSpecType());
        Assert.assertEquals((Object)expected.getColumnNameCharacterMap(), (Object)value.getColumnNameCharacterMap());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getDestinationTable(), (Object)value.getDestinationTable());
        Assert.assertEquals((Object)expected.getDecimalTargetTypes(), (Object)value.getDecimalTargetTypes());
        Assert.assertEquals((Object)expected.getCreateDisposition(), (Object)value.getCreateDisposition());
        Assert.assertEquals((Object)expected.getWriteDisposition(), (Object)value.getWriteDisposition());
        Assert.assertEquals((Object)expected.getCsvOptions(), (Object)value.getCsvOptions());
        Assert.assertEquals((Object)expected.getFormat(), (Object)value.getFormat());
        Assert.assertEquals((Object)expected.ignoreUnknownValues(), (Object)value.ignoreUnknownValues());
        Assert.assertEquals((Object)expected.getMaxBadRecords(), (Object)value.getMaxBadRecords());
        Assert.assertEquals((Object)expected.getSchema(), (Object)value.getSchema());
        Assert.assertEquals((Object)expected.getDatastoreBackupOptions(), (Object)value.getDatastoreBackupOptions());
        Assert.assertEquals((Object)expected.getAutodetect(), (Object)value.getAutodetect());
        Assert.assertEquals((Object)expected.getSchemaUpdateOptions(), (Object)value.getSchemaUpdateOptions());
        Assert.assertEquals((Object)expected.getDestinationEncryptionConfiguration(), (Object)value.getDestinationEncryptionConfiguration());
        Assert.assertEquals((Object)expected.getTimePartitioning(), (Object)value.getTimePartitioning());
        Assert.assertEquals((Object)expected.getClustering(), (Object)value.getClustering());
        Assert.assertEquals((Object)expected.getUseAvroLogicalTypes(), (Object)value.getUseAvroLogicalTypes());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getJobTimeoutMs(), (Object)value.getJobTimeoutMs());
        Assert.assertEquals((Object)expected.getRangePartitioning(), (Object)value.getRangePartitioning());
        Assert.assertEquals((Object)expected.getNullMarker(), (Object)value.getNullMarker());
        Assert.assertEquals((Object)expected.getHivePartitioningOptions(), (Object)value.getHivePartitioningOptions());
        Assert.assertEquals((Object)expected.getConnectionProperties(), (Object)value.getConnectionProperties());
        Assert.assertEquals((Object)expected.getCreateSession(), (Object)value.getCreateSession());
    }
}

