/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.MaterializedViewDefinition;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MaterializedViewDefinitionTest {
    private static final String MATERIALIZED_VIEW_QUERY = "MATERIALIZED_VIEW_QUERY";
    private static final Long LAST_REFRESH_TIME = 1580302008L;
    private static final Boolean ENABLE_REFRESH = false;
    private static final Long REFRESH_INTERVAL_MS = 60000L;
    private static final Schema SCHEMA = Schema.of((Field[])new Field[0]);
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY, (long)42L);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final MaterializedViewDefinition MATERIALIZED_VIEW_DEFINITION = MaterializedViewDefinition.newBuilder().setSchema(SCHEMA).setQuery("MATERIALIZED_VIEW_QUERY").setLastRefreshTime(LAST_REFRESH_TIME).setEnableRefresh(ENABLE_REFRESH).setRefreshIntervalMs(REFRESH_INTERVAL_MS).setClustering(CLUSTERING).setTimePartitioning(TIME_PARTITIONING).build();

    @Test
    public void testToBuilder() {
        this.compareMaterializedView(MATERIALIZED_VIEW_DEFINITION, MATERIALIZED_VIEW_DEFINITION.toBuilder().build());
        MaterializedViewDefinition materializedViewDefinition = MATERIALIZED_VIEW_DEFINITION.toBuilder().setQuery("NEW QUERY").build();
        Assert.assertEquals((Object)"NEW QUERY", (Object)materializedViewDefinition.getQuery());
        materializedViewDefinition = materializedViewDefinition.toBuilder().setQuery(MATERIALIZED_VIEW_QUERY).build();
        this.compareMaterializedView(MATERIALIZED_VIEW_DEFINITION, materializedViewDefinition);
    }

    @Test
    public void testToBuilderIncomplete() {
        MaterializedViewDefinition materializedViewDefinition = MaterializedViewDefinition.of((String)MATERIALIZED_VIEW_QUERY);
        Assert.assertEquals((Object)materializedViewDefinition, (Object)materializedViewDefinition.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)MATERIALIZED_VIEW_QUERY, (Object)MATERIALIZED_VIEW_DEFINITION.getQuery());
        Assert.assertEquals((Object)TableDefinition.Type.MATERIALIZED_VIEW, (Object)MATERIALIZED_VIEW_DEFINITION.getType());
        Assert.assertEquals((Object)LAST_REFRESH_TIME, (Object)MATERIALIZED_VIEW_DEFINITION.getLastRefreshTime());
        MaterializedViewDefinition materializedViewDefinition = MaterializedViewDefinition.newBuilder().setSchema(SCHEMA).setQuery(MATERIALIZED_VIEW_QUERY).setLastRefreshTime(LAST_REFRESH_TIME).setEnableRefresh(ENABLE_REFRESH).setRefreshIntervalMs(REFRESH_INTERVAL_MS).setClustering(CLUSTERING).setTimePartitioning(TIME_PARTITIONING).build();
        Assert.assertEquals((Object)MATERIALIZED_VIEW_DEFINITION, (Object)materializedViewDefinition);
    }

    @Test
    public void testToAndFromPb() {
        MaterializedViewDefinition materializedViewDefinition = MATERIALIZED_VIEW_DEFINITION.toBuilder().build();
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)materializedViewDefinition.toPb()) instanceof MaterializedViewDefinition));
        this.compareMaterializedView(materializedViewDefinition, (MaterializedViewDefinition)TableDefinition.fromPb((Table)materializedViewDefinition.toPb()));
    }

    private void compareMaterializedView(MaterializedViewDefinition expected, MaterializedViewDefinition actual) {
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getSchema(), (Object)actual.getSchema());
        Assert.assertEquals((Object)expected.getQuery(), (Object)actual.getQuery());
        Assert.assertEquals((Object)expected.getLastRefreshTime(), (Object)actual.getLastRefreshTime());
        Assert.assertEquals((Object)expected.getEnableRefresh(), (Object)actual.getEnableRefresh());
        Assert.assertEquals((Object)expected.getRefreshIntervalMs(), (Object)actual.getRefreshIntervalMs());
        Assert.assertEquals((Object)expected.getClustering(), (Object)actual.getClustering());
        Assert.assertEquals((Object)expected.getTimePartitioning(), (Object)actual.getTimePartitioning());
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((long)expected.hashCode(), (long)actual.hashCode());
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

