/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.MetadataCacheStatistics;
import com.google.cloud.bigquery.MetadataCacheStats;
import com.google.cloud.bigquery.TableMetadataCacheUsage;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class MetadataCacheStatsTest {
    private static List<com.google.api.services.bigquery.model.TableMetadataCacheUsage> TABLE_METADATA_CACHE_USAGE_PB_LIST = ImmutableList.of((Object)new com.google.api.services.bigquery.model.TableMetadataCacheUsage().setExplanation("test explanation"));
    private static final MetadataCacheStats METADATA_CACHE_STATS = MetadataCacheStats.newBuilder().setTableMetadataCacheUsage(TABLE_METADATA_CACHE_USAGE_PB_LIST.stream().map(TableMetadataCacheUsage::fromPb).collect(Collectors.toList())).build();
    private static final MetadataCacheStatistics METADATA_CACHE_STATISTICS_PB = new MetadataCacheStatistics().setTableMetadataCacheUsage(TABLE_METADATA_CACHE_USAGE_PB_LIST);

    @Test
    public void testToPbAndFromPb() {
        Assert.assertEquals((Object)METADATA_CACHE_STATISTICS_PB, (Object)METADATA_CACHE_STATS.toPb());
        this.compareMetadataCacheStats(METADATA_CACHE_STATS, MetadataCacheStats.fromPb((MetadataCacheStatistics)METADATA_CACHE_STATISTICS_PB));
    }

    private void compareMetadataCacheStats(MetadataCacheStats expected, MetadataCacheStats value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Truth.assertThat((Boolean)expected.getTableMetadataCacheUsage().containsAll(value.getTableMetadataCacheUsage()));
    }
}

