/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ModelReference;
import com.google.cloud.bigquery.ModelId;
import org.junit.Assert;
import org.junit.Test;

public class ModelIdTest {
    public static final ModelId MODEL = ModelId.of((String)"dataset", (String)"model");
    public static final ModelId MODEL_COMPLETE = ModelId.of((String)"project", (String)"dataset", (String)"model");

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)MODEL.getProject());
        Assert.assertEquals((Object)"dataset", (Object)MODEL.getDataset());
        Assert.assertEquals((Object)"model", (Object)MODEL.getModel());
        Assert.assertEquals((Object)"project", (Object)MODEL_COMPLETE.getProject());
        Assert.assertEquals((Object)"dataset", (Object)MODEL_COMPLETE.getDataset());
        Assert.assertEquals((Object)"model", (Object)MODEL_COMPLETE.getModel());
    }

    @Test
    public void testEquals() {
        this.compareModelIds(MODEL, ModelId.of((String)"dataset", (String)"model"));
        this.compareModelIds(MODEL_COMPLETE, ModelId.of((String)"project", (String)"dataset", (String)"model"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareModelIds(MODEL, ModelId.fromPb((ModelReference)MODEL.toPb()));
        this.compareModelIds(MODEL_COMPLETE, ModelId.fromPb((ModelReference)MODEL_COMPLETE.toPb()));
    }

    @Test
    public void testSetProjectId() {
        ModelId differentProjectTable = ModelId.of((String)"differentProject", (String)"dataset", (String)"model");
        Assert.assertEquals((Object)differentProjectTable, (Object)MODEL.setProjectId("differentProject"));
    }

    private void compareModelIds(ModelId expected, ModelId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getProject(), (Object)value.getProject());
        Assert.assertEquals((Object)expected.getDataset(), (Object)value.getDataset());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

