/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Model;
import com.google.api.services.bigquery.model.TrainingOptions;
import com.google.api.services.bigquery.model.TrainingRun;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ModelInfoTest {
    private static final ModelId MODEL_ID = ModelId.of((String)"dataset", (String)"model");
    private static final String ETAG = "etag";
    private static final Long CREATION_TIME = 10L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final Long EXPIRATION_TIME = 30L;
    private static final String DESCRIPTION = "description";
    private static final String FRIENDLY_NAME = "friendlyname";
    private static final String LOCATION = "US";
    private static final EncryptionConfiguration MODEL_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final TrainingOptions TRAINING_OPTIONS = new TrainingOptions().setDataSplitColumn("foo").setEarlyStop(Boolean.valueOf(true)).setLossType("bar");
    private static final TrainingRun TRAINING_RUN = new TrainingRun().setTrainingOptions(TRAINING_OPTIONS);
    private static final List<TrainingRun> TRAINING_RUN_LIST = Arrays.asList(TRAINING_RUN);
    private static final ModelInfo MODEL_INFO = ModelInfo.newBuilder((ModelId)MODEL_ID).setEtag("etag").setCreationTime(CREATION_TIME).setExpirationTime(EXPIRATION_TIME).setLastModifiedTime(LAST_MODIFIED_TIME).setDescription("description").setFriendlyName("friendlyname").setTrainingRuns(TRAINING_RUN_LIST).setEncryptionConfiguration(MODEL_ENCRYPTION_CONFIGURATION).setLocation("US").build();

    @Test
    public void testToBuilder() {
        this.compareModelInfo(MODEL_INFO, MODEL_INFO.toBuilder().build());
    }

    @Test
    public void testToBuilderIncomplete() {
        ModelInfo modelInfo = ModelInfo.of((ModelId)MODEL_ID);
        Assert.assertEquals((Object)modelInfo, (Object)modelInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ETAG, (Object)MODEL_INFO.getEtag());
        Assert.assertEquals((Object)CREATION_TIME, (Object)MODEL_INFO.getCreationTime());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)MODEL_INFO.getLastModifiedTime());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)MODEL_INFO.getExpirationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)MODEL_INFO.getDescription());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)MODEL_INFO.getFriendlyName());
        Assert.assertEquals((Object)TRAINING_OPTIONS, (Object)((TrainingRun)MODEL_INFO.getTrainingRuns().get(0)).getTrainingOptions());
        Assert.assertEquals((Object)MODEL_ENCRYPTION_CONFIGURATION, (Object)MODEL_INFO.getEncryptionConfiguration());
        Assert.assertEquals((Object)LOCATION, (Object)MODEL_INFO.getLocation());
    }

    @Test
    public void testOf() {
        ModelInfo modelInfo = ModelInfo.of((ModelId)MODEL_ID);
        Assert.assertEquals((Object)MODEL_ID, (Object)modelInfo.getModelId());
        Assert.assertNull((Object)modelInfo.getEtag());
        Assert.assertNull((Object)modelInfo.getCreationTime());
        Assert.assertNull((Object)modelInfo.getLastModifiedTime());
        Assert.assertNull((Object)modelInfo.getExpirationTime());
        Assert.assertNull((Object)modelInfo.getDescription());
        Assert.assertNull((Object)modelInfo.getFriendlyName());
        Assert.assertNull((Object)modelInfo.getEncryptionConfiguration());
        Assert.assertNull((Object)modelInfo.getLocation());
        Assert.assertEquals((Object)modelInfo.getTrainingRuns().isEmpty(), (Object)true);
        Assert.assertEquals((Object)modelInfo.getLabelColumns().isEmpty(), (Object)true);
        Assert.assertEquals((Object)modelInfo.getFeatureColumns().isEmpty(), (Object)true);
    }

    @Test
    public void testToAndFromPb() {
        this.compareModelInfo(MODEL_INFO, ModelInfo.fromPb((Model)MODEL_INFO.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)"project", (Object)MODEL_INFO.setProjectId("project").getModelId().getProject());
    }

    private void compareModelInfo(ModelInfo expected, ModelInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getModelId(), (Object)value.getModelId());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getLastModifiedTime(), (Object)value.getLastModifiedTime());
        Assert.assertEquals((Object)expected.getExpirationTime(), (Object)value.getExpirationTime());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getFriendlyName(), (Object)value.getFriendlyName());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getLocation(), (Object)value.getLocation());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.getTrainingRuns(), (Object)value.getTrainingRuns());
        Assert.assertEquals((Object)expected.getLabelColumns(), (Object)value.getLabelColumns());
        Assert.assertEquals((Object)expected.getFeatureColumns(), (Object)value.getFeatureColumns());
        Assert.assertEquals((Object)expected.getEncryptionConfiguration(), (Object)value.getEncryptionConfiguration());
    }
}

