/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.ModelTableDefinition;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import org.junit.Assert;
import org.junit.Test;

public class ModelTableDefinitionTest {
    private static final String LOCATION = "US";
    private static final Long NUM_BYTES = 14L;
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final ModelTableDefinition MODEL_TABLE_DEFINITION = ((ModelTableDefinition.Builder)ModelTableDefinition.newBuilder().setSchema(TABLE_SCHEMA)).setType(TableDefinition.Type.MODEL).setLocation("US").setNumBytes(NUM_BYTES).build();

    @Test
    public void testToBuilder() {
        this.compareModelTableDefinition(MODEL_TABLE_DEFINITION, MODEL_TABLE_DEFINITION.toBuilder().build());
    }

    @Test
    public void testTypeNullPointerException() {
        try {
            MODEL_TABLE_DEFINITION.toBuilder().setType(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testToBuilderIncomplete() {
        ModelTableDefinition modelTableDefinition = ModelTableDefinition.newBuilder().build();
        Assert.assertEquals((Object)modelTableDefinition, (Object)modelTableDefinition.toBuilder().build());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertEquals((Object)MODEL_TABLE_DEFINITION, (Object)ModelTableDefinition.fromPb((Table)MODEL_TABLE_DEFINITION.toPb()));
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)MODEL_TABLE_DEFINITION.getSchema(), (Object)TABLE_SCHEMA);
        Assert.assertEquals((Object)MODEL_TABLE_DEFINITION.getType(), (Object)TableDefinition.Type.MODEL);
        Assert.assertEquals((Object)MODEL_TABLE_DEFINITION.getLocation(), (Object)LOCATION);
        Assert.assertEquals((Object)MODEL_TABLE_DEFINITION.getNumBytes(), (Object)NUM_BYTES);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)MODEL_TABLE_DEFINITION, (Object)MODEL_TABLE_DEFINITION);
    }

    @Test
    public void testNotEquals() {
        Assert.assertNotEquals((Object)MODEL_TABLE_DEFINITION, (Object)LOCATION);
    }

    private void compareModelTableDefinition(ModelTableDefinition expected, ModelTableDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getSchema(), (Object)value.getSchema());
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getLocation(), (Object)value.getLocation());
        Assert.assertEquals((Object)expected.getNumBytes(), (Object)value.getNumBytes());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

