/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Model;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.junit.MockitoRule;

@RunWith(value=MockitoJUnitRunner.class)
public class ModelTest {
    private static final ModelId MODEL_ID = ModelId.of((String)"dataset", (String)"model");
    private static final String ETAG = "etag";
    private static final Long CREATION_TIME = 10L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final Long EXPIRATION_TIME = 30L;
    private static final String DESCRIPTION = "description";
    private static final String FRIENDLY_NAME = "friendlyname";
    private static final ModelInfo MODEL_INFO = ModelInfo.newBuilder((ModelId)MODEL_ID).setEtag("etag").setCreationTime(CREATION_TIME).setExpirationTime(EXPIRATION_TIME).setLastModifiedTime(LAST_MODIFIED_TIME).setDescription("description").setFriendlyName("friendlyname").build();
    @Rule
    public MockitoRule rule;
    private BigQuery bigquery;
    private BigQueryOptions mockOptions;
    private Model expectedModel;
    private Model model;

    @Before
    public void setUp() {
        this.bigquery = (BigQuery)Mockito.mock(BigQuery.class);
        this.mockOptions = (BigQueryOptions)Mockito.mock(BigQueryOptions.class);
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        this.expectedModel = new Model(this.bigquery, new ModelInfo.BuilderImpl(MODEL_INFO));
        this.model = new Model(this.bigquery, new ModelInfo.BuilderImpl(MODEL_INFO));
    }

    @Test
    public void testBuilder() {
        Model builtModel = new Model.Builder(this.bigquery, MODEL_ID).setEtag(ETAG).setCreationTime(CREATION_TIME).setExpirationTime(EXPIRATION_TIME).setLastModifiedTime(LAST_MODIFIED_TIME).setDescription(DESCRIPTION).setFriendlyName(FRIENDLY_NAME).build();
        Assert.assertEquals((Object)ETAG, (Object)builtModel.getEtag());
        Assert.assertSame((Object)this.bigquery, (Object)builtModel.getBigQuery());
    }

    @Test
    public void testToBuilder() {
        this.compareModelInfo((ModelInfo)this.expectedModel, (ModelInfo)this.expectedModel.toBuilder().build());
    }

    @Test
    public void testExists_True() {
        BigQuery.ModelOption[] expectedOptions = new BigQuery.ModelOption[]{BigQuery.ModelOption.fields((BigQuery.ModelField[])new BigQuery.ModelField[0])};
        Mockito.when((Object)this.bigquery.getModel(MODEL_INFO.getModelId(), expectedOptions)).thenReturn((Object)this.expectedModel);
        Assert.assertTrue((boolean)this.model.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getModel(MODEL_INFO.getModelId(), expectedOptions);
    }

    @Test
    public void testExists_False() {
        BigQuery.ModelOption[] expectedOptions = new BigQuery.ModelOption[]{BigQuery.ModelOption.fields((BigQuery.ModelField[])new BigQuery.ModelField[0])};
        Mockito.when((Object)this.bigquery.getModel(MODEL_INFO.getModelId(), expectedOptions)).thenReturn(null);
        Assert.assertFalse((boolean)this.model.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getModel(MODEL_INFO.getModelId(), expectedOptions);
    }

    @Test
    public void testReload() {
        ModelInfo updatedInfo = MODEL_INFO.toBuilder().setDescription("Description").build();
        Model expectedModel = new Model(this.bigquery, new ModelInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getModel(MODEL_INFO.getModelId(), new BigQuery.ModelOption[0])).thenReturn((Object)expectedModel);
        Model updatedModel = this.model.reload(new BigQuery.ModelOption[0]);
        this.compareModel(expectedModel, updatedModel);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getModel(MODEL_INFO.getModelId(), new BigQuery.ModelOption[0]);
    }

    @Test
    public void testReloadNull() {
        Mockito.when((Object)this.bigquery.getModel(MODEL_INFO.getModelId(), new BigQuery.ModelOption[0])).thenReturn(null);
        Assert.assertNull((Object)this.model.reload(new BigQuery.ModelOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getModel(MODEL_INFO.getModelId(), new BigQuery.ModelOption[0]);
    }

    @Test
    public void testUpdate() {
        Model expectedUpdatedModel = this.expectedModel.toBuilder().setDescription("Description").build();
        Mockito.when((Object)this.bigquery.update((ModelInfo)Mockito.eq((Object)this.expectedModel), new BigQuery.ModelOption[0])).thenReturn((Object)expectedUpdatedModel);
        Model actualUpdatedModel = this.model.update(new BigQuery.ModelOption[0]);
        this.compareModel(expectedUpdatedModel, actualUpdatedModel);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((ModelInfo)Mockito.eq((Object)this.expectedModel), new BigQuery.ModelOption[0]);
    }

    @Test
    public void testUpdateWithOptions() {
        Model expectedUpdatedModel = this.expectedModel.toBuilder().setDescription("Description").build();
        Mockito.when((Object)this.bigquery.update((ModelInfo)Mockito.eq((Object)this.expectedModel), new BigQuery.ModelOption[]{(BigQuery.ModelOption)Mockito.eq((Object)BigQuery.ModelOption.fields((BigQuery.ModelField[])new BigQuery.ModelField[0]))})).thenReturn((Object)expectedUpdatedModel);
        Model actualUpdatedModel = this.model.update(new BigQuery.ModelOption[]{BigQuery.ModelOption.fields((BigQuery.ModelField[])new BigQuery.ModelField[0])});
        this.compareModel(expectedUpdatedModel, actualUpdatedModel);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((ModelInfo)Mockito.eq((Object)this.expectedModel), new BigQuery.ModelOption[]{(BigQuery.ModelOption)Mockito.eq((Object)BigQuery.ModelOption.fields((BigQuery.ModelField[])new BigQuery.ModelField[0]))});
    }

    @Test
    public void testDeleteTrue() {
        Mockito.when((Object)this.bigquery.delete(MODEL_INFO.getModelId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.model.delete());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(MODEL_INFO.getModelId());
    }

    @Test
    public void testDeleteFalse() {
        Mockito.when((Object)this.bigquery.delete(MODEL_INFO.getModelId())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.model.delete());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(MODEL_INFO.getModelId());
    }

    private void compareModel(Model expected, Model value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareModelInfo((ModelInfo)expected, (ModelInfo)value);
        Assert.assertEquals((Object)expected.getBigQuery().getOptions(), (Object)value.getBigQuery().getOptions());
    }

    private void compareModelInfo(ModelInfo expected, ModelInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getModelId(), (Object)value.getModelId());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getLastModifiedTime(), (Object)value.getLastModifiedTime());
        Assert.assertEquals((Object)expected.getExpirationTime(), (Object)value.getExpirationTime());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getFriendlyName(), (Object)value.getFriendlyName());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

