/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import org.junit.Assert;
import org.junit.Test;

public class OptionTest {
    private static final BigQueryRpc.Option RPC_OPTION = BigQueryRpc.Option.PAGE_TOKEN;
    private static final BigQueryRpc.Option ANOTHER_RPC_OPTION = BigQueryRpc.Option.FIELDS;
    private static final String VALUE = "some value";
    private static final String OTHER_VALUE = "another value";
    private static final Option OPTION = new Option(RPC_OPTION, "some value"){};
    private static final Option OPTION_EQUALS = new Option(RPC_OPTION, "some value"){};
    private static final Option OPTION_NOT_EQUALS1 = new Option(RPC_OPTION, "another value"){};
    private static final Option OPTION_NOT_EQUALS2 = new Option(ANOTHER_RPC_OPTION, "some value"){};

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)OPTION, (Object)OPTION_EQUALS);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS1);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS2);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)OPTION.hashCode(), (long)OPTION_EQUALS.hashCode());
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)RPC_OPTION, (Object)OPTION.getRpcOption());
        Assert.assertEquals((Object)VALUE, (Object)OPTION.getValue());
        Option option = new Option(RPC_OPTION, null){};
        Assert.assertEquals((Object)RPC_OPTION, (Object)option.getRpcOption());
        Assert.assertNull((Object)option.getValue());
        try {
            new Option(null, VALUE){};
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

