/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.ParquetOptions;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;

public class ParquetOptionsTest {
    private static final ParquetOptions OPTIONS = ParquetOptions.newBuilder().setEnableListInference(Boolean.valueOf(true)).setEnumAsString(Boolean.valueOf(true)).setMapTargetType("ARRAY_OF_STRUCT").build();

    @Test
    public void testToBuilder() {
        this.compareParquetOptions(OPTIONS, OPTIONS.toBuilder().build());
        ParquetOptions parquetOptions = OPTIONS.toBuilder().setEnableListInference(Boolean.valueOf(true)).build();
        Assert.assertEquals((Object)true, (Object)parquetOptions.getEnableListInference());
        parquetOptions = parquetOptions.toBuilder().setEnumAsString(Boolean.valueOf(true)).setMapTargetType("ARRAY_OF_STRUCT").build();
        this.compareParquetOptions(OPTIONS, parquetOptions);
    }

    @Test
    public void testToBuilderIncomplete() {
        ParquetOptions parquetOptions = ParquetOptions.newBuilder().setEnableListInference(Boolean.valueOf(true)).build();
        Assert.assertEquals((Object)parquetOptions, (Object)parquetOptions.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"PARQUET", (Object)OPTIONS.getType());
        Assert.assertEquals((Object)true, (Object)OPTIONS.getEnableListInference());
        Assert.assertEquals((Object)true, (Object)OPTIONS.getEnumAsString());
        Assert.assertEquals((Object)"ARRAY_OF_STRUCT", (Object)OPTIONS.getMapTargetType());
    }

    @Test
    public void testToAndFromPb() {
        this.compareParquetOptions(OPTIONS, ParquetOptions.fromPb((com.google.api.services.bigquery.model.ParquetOptions)OPTIONS.toPb()));
        ParquetOptions parquetOptions = ParquetOptions.newBuilder().setEnableListInference(Boolean.valueOf(true)).build();
        this.compareParquetOptions(parquetOptions, ParquetOptions.fromPb((com.google.api.services.bigquery.model.ParquetOptions)parquetOptions.toPb()));
    }

    private void compareParquetOptions(ParquetOptions expected, ParquetOptions actual) {
        Truth.assertThat((Object)expected).isEqualTo((Object)actual);
        Truth.assertThat((Boolean)expected.getEnableListInference()).isEqualTo((Object)actual.getEnableListInference());
        Truth.assertThat((Boolean)expected.getEnumAsString()).isEqualTo((Object)actual.getEnumAsString());
        Truth.assertThat((Integer)expected.hashCode()).isEqualTo((Object)actual.hashCode());
        Truth.assertThat((String)expected.toString()).isEqualTo((Object)actual.toString());
    }
}

