/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Binding;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.bigquery.PolicyHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PolicyHelperTest {
    public static final String ETAG = "etag";
    public static final String ROLE1 = "roles/bigquery.admin";
    public static final String ROLE2 = "roles/bigquery.dataEditor";
    public static final String USER1 = "user1@gmail.com";
    public static final String USER2 = "user2@gmail.com";
    static final com.google.api.services.bigquery.model.Policy API_POLICY = new com.google.api.services.bigquery.model.Policy().setBindings((List)ImmutableList.of((Object)new Binding().setRole("roles/bigquery.admin").setMembers((List)ImmutableList.of((Object)String.format("user:%s", "user1@gmail.com"))), (Object)new Binding().setRole("roles/bigquery.dataEditor").setMembers((List)ImmutableList.of((Object)String.format("user:%s", "user2@gmail.com"), (Object)"allUsers")))).setEtag("etag").setVersion(Integer.valueOf(1));
    static final com.google.api.services.bigquery.model.Policy API_POLICY_NO_BINDINGS = new com.google.api.services.bigquery.model.Policy().setEtag("etag").setVersion(Integer.valueOf(1));
    static final Policy IAM_POLICY = Policy.newBuilder().addIdentity(Role.of((String)"roles/bigquery.admin"), Identity.user((String)"user1@gmail.com"), new Identity[0]).addIdentity(Role.of((String)"roles/bigquery.dataEditor"), Identity.user((String)"user2@gmail.com"), new Identity[]{Identity.allUsers()}).setEtag("etag").setVersion(1).build();
    static final Policy IAM_POLICY_NO_BINDINGS = Policy.newBuilder().setEtag("etag").setVersion(1).build();

    @Test
    public void testConversionWithBindings() {
        Assert.assertEquals((Object)IAM_POLICY, (Object)PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)API_POLICY));
        Assert.assertEquals((Object)API_POLICY, (Object)PolicyHelper.convertToApiPolicy((Policy)IAM_POLICY));
        Assert.assertEquals((Object)IAM_POLICY, (Object)PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)PolicyHelper.convertToApiPolicy((Policy)IAM_POLICY)));
        Assert.assertEquals((Object)API_POLICY, (Object)PolicyHelper.convertToApiPolicy((Policy)PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)API_POLICY)));
    }

    @Test
    public void testConversionNoBindings() {
        Assert.assertEquals((Object)IAM_POLICY_NO_BINDINGS, (Object)PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)API_POLICY_NO_BINDINGS));
        Assert.assertEquals((Object)API_POLICY_NO_BINDINGS, (Object)PolicyHelper.convertToApiPolicy((Policy)IAM_POLICY_NO_BINDINGS));
        Assert.assertEquals((Object)IAM_POLICY_NO_BINDINGS, (Object)PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)PolicyHelper.convertToApiPolicy((Policy)IAM_POLICY_NO_BINDINGS)));
        Assert.assertEquals((Object)API_POLICY_NO_BINDINGS, (Object)PolicyHelper.convertToApiPolicy((Policy)PolicyHelper.convertFromApiPolicy((com.google.api.services.bigquery.model.Policy)API_POLICY_NO_BINDINGS)));
    }
}

