/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.bigquery.PolicyTags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PolicyTagsTest {
    private static final List<String> POLICIES = ImmutableList.of((Object)"test/policy1", (Object)"test/policy2");
    private static final PolicyTags POLICY_TAGS = PolicyTags.newBuilder().setNames(POLICIES).build();

    @Test
    public void testToBuilder() {
        this.comparePolicyTags(POLICY_TAGS, POLICY_TAGS.toBuilder().build());
    }

    @Test
    public void testToBuilderIncomplete() {
        PolicyTags policyTags = PolicyTags.newBuilder().build();
        Assert.assertEquals((Object)policyTags, (Object)policyTags);
        Assert.assertEquals((Object)policyTags, (Object)policyTags.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals(POLICIES, (Object)POLICY_TAGS.getNames());
        Assert.assertNotEquals((Object)POLICY_TAGS, POLICIES);
    }

    @Test
    public void testWithoutNames() {
        TableFieldSchema.PolicyTags PARTIALTAG = new TableFieldSchema.PolicyTags();
        Assert.assertNull((Object)PolicyTags.fromPb((TableFieldSchema.PolicyTags)PARTIALTAG));
    }

    @Test
    public void testFromAndPb() {
        Assert.assertEquals((Object)POLICY_TAGS, (Object)PolicyTags.fromPb((TableFieldSchema.PolicyTags)POLICY_TAGS.toPb()));
    }

    private void comparePolicyTags(PolicyTags expected, PolicyTags value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getNames(), (Object)value.getNames());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

