/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableConstraints;
import com.google.cloud.bigquery.PrimaryKey;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PrimaryKeyTest {
    private static final List<String> COLUMNS = Arrays.asList("column1", "column2");
    private static final PrimaryKey PRIMARY_KEY = PrimaryKey.newBuilder().setColumns(COLUMNS).build();

    @Test
    public void testToBuilder() {
        this.comparePrimaryKeyDefinition(PRIMARY_KEY, PRIMARY_KEY.toBuilder().build());
        PrimaryKey primaryKey = PRIMARY_KEY.toBuilder().setColumns(Arrays.asList("col1", "col2", "col3")).build();
        Assert.assertEquals(Arrays.asList("col1", "col2", "col3"), (Object)primaryKey.getColumns());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals(COLUMNS, (Object)PRIMARY_KEY.getColumns());
        PrimaryKey primaryKey = PRIMARY_KEY.newBuilder().setColumns(COLUMNS).build();
        Assert.assertEquals((Object)PRIMARY_KEY, (Object)primaryKey);
    }

    @Test
    public void testToAndFromPb() {
        PrimaryKey primaryKey = PRIMARY_KEY.toBuilder().build();
        Assert.assertTrue((boolean)(PrimaryKey.fromPb((TableConstraints.PrimaryKey)primaryKey.toPb()) instanceof PrimaryKey));
        this.comparePrimaryKeyDefinition(primaryKey, PrimaryKey.fromPb((TableConstraints.PrimaryKey)primaryKey.toPb()));
    }

    private void comparePrimaryKeyDefinition(PrimaryKey expected, PrimaryKey value) {
        Assert.assertEquals((Object)expected.getColumns(), (Object)value.getColumns());
    }
}

