/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class QueryJobConfigurationTest {
    private static final String TEST_PROJECT_ID = "test-project-id";
    private static final String QUERY = "BigQuery SQL";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final String KEY = "time_zone";
    private static final String VALUE = "US/Eastern";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("time_zone").setValue("US/Eastern").build();
    private static final List<ConnectionProperty> CONNECTION_PROPERTIES = ImmutableList.of((Object)CONNECTION_PROPERTY);
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().build();
    private static final ExternalTableDefinition TABLE_CONFIGURATION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setCompression("GZIP").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).build();
    private static final Map<String, ExternalTableDefinition> TABLE_DEFINITIONS = ImmutableMap.of((Object)"tableName", (Object)TABLE_CONFIGURATION);
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final QueryJobConfiguration.Priority PRIORITY = QueryJobConfiguration.Priority.BATCH;
    private static final boolean ALLOW_LARGE_RESULTS = true;
    private static final boolean USE_QUERY_CACHE = false;
    private static final boolean CREATE_SESSION = true;
    private static final boolean FLATTEN_RESULTS = true;
    private static final boolean USE_LEGACY_SQL = true;
    private static final Integer MAX_BILLING_TIER = 123;
    private static final Long MAX_BYTES_BILL = 12345L;
    private static final List<JobInfo.SchemaUpdateOption> SCHEMA_UPDATE_OPTIONS = ImmutableList.of((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final EncryptionConfiguration JOB_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final Long TIMEOUT = 10L;
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"test-job-name", (Object)"test-query-job");
    private static final RangePartitioning.Range RANGE = RangePartitioning.Range.newBuilder().setStart(Long.valueOf(1L)).setInterval(Long.valueOf(2L)).setEnd(Long.valueOf(10L)).build();
    private static final RangePartitioning RANGE_PARTITIONING = RangePartitioning.newBuilder().setField("IntegerField").setRange(RANGE).build();
    private static final QueryParameterValue STRING_PARAMETER = QueryParameterValue.string((String)"stringValue");
    private static final QueryParameterValue TIMESTAMP_PARAMETER = QueryParameterValue.timestamp((String)"2014-01-01 07:00:00.000000+00:00");
    private static final QueryParameterValue BIGNUMERIC_PARAMETER = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal(0));
    private static final List<QueryParameterValue> POSITIONAL_PARAMETER = ImmutableList.of((Object)STRING_PARAMETER, (Object)TIMESTAMP_PARAMETER, (Object)BIGNUMERIC_PARAMETER);
    private static final Map<String, QueryParameterValue> NAME_PARAMETER = ImmutableMap.of((Object)"string", (Object)STRING_PARAMETER, (Object)"timestamp", (Object)TIMESTAMP_PARAMETER);
    private static final String PARAMETER_MODE = "POSITIONAL";
    private static final QueryJobConfiguration.JobCreationMode JOB_CREATION_MODE = QueryJobConfiguration.JobCreationMode.JOB_CREATION_OPTIONAL;
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.newBuilder((String)"BigQuery SQL").setUseQueryCache(Boolean.valueOf(false)).setTableDefinitions(TABLE_DEFINITIONS).setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition(CREATE_DISPOSITION).setDefaultDataset(DATASET_ID).setDestinationTable(TABLE_ID).setWriteDisposition(WRITE_DISPOSITION).setPriority(PRIORITY).setCreateSession(Boolean.valueOf(true)).setFlattenResults(Boolean.valueOf(true)).setUserDefinedFunctions(USER_DEFINED_FUNCTIONS).setDryRun(Boolean.valueOf(true)).setUseLegacySql(Boolean.valueOf(true)).setMaximumBillingTier(MAX_BILLING_TIER).setMaximumBytesBilled(MAX_BYTES_BILL).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setDestinationEncryptionConfiguration(JOB_ENCRYPTION_CONFIGURATION).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setJobTimeoutMs(TIMEOUT).setLabels(LABELS).setRangePartitioning(RANGE_PARTITIONING).setConnectionProperties(CONNECTION_PROPERTIES).setPositionalParameters(POSITIONAL_PARAMETER).setParameterMode("POSITIONAL").build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_ADD_POSITIONAL_PARAMETER = QUERY_JOB_CONFIGURATION.toBuilder().setPositionalParameters((Iterable)ImmutableList.of()).addPositionalParameter(STRING_PARAMETER).build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_SET_NAME_PARAMETER = QUERY_JOB_CONFIGURATION.toBuilder().setPositionalParameters((Iterable)ImmutableList.of()).setNamedParameters(NAME_PARAMETER).build();
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_SET_JOB_CREATION_MODE = QUERY_JOB_CONFIGURATION.toBuilder().setJobCreationMode(JOB_CREATION_MODE).build();

    @Test
    public void testToBuilder() {
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION, QUERY_JOB_CONFIGURATION.toBuilder().build());
        QueryJobConfiguration job = QUERY_JOB_CONFIGURATION.toBuilder().setQuery("New BigQuery SQL").build();
        Assert.assertEquals((Object)"New BigQuery SQL", (Object)job.getQuery());
        job = job.toBuilder().setQuery(QUERY).build();
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION, job);
    }

    @Test
    public void testOf() {
        QueryJobConfiguration job = QueryJobConfiguration.of((String)QUERY);
        Assert.assertEquals((Object)QUERY, (Object)job.getQuery());
    }

    @Test
    public void testToBuilderIncomplete() {
        QueryJobConfiguration job = QueryJobConfiguration.of((String)QUERY);
        this.compareQueryJobConfiguration(job, job.toBuilder().build());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.toPb().getQuery());
        Assert.assertNull((Object)QUERY_JOB_CONFIGURATION.toPb().getExtract());
        Assert.assertNull((Object)QUERY_JOB_CONFIGURATION.toPb().getCopy());
        Assert.assertNull((Object)QUERY_JOB_CONFIGURATION.toPb().getLoad());
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.getJobTimeoutMs());
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.getLabels());
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.getRangePartitioning());
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.getConnectionProperties());
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.getPositionalParameters());
        Assert.assertNotNull((Object)QUERY_JOB_CONFIGURATION.getNamedParameters());
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION, QueryJobConfiguration.fromPb((JobConfiguration)QUERY_JOB_CONFIGURATION.toPb()));
        QueryJobConfiguration job = QueryJobConfiguration.of((String)QUERY);
        this.compareQueryJobConfiguration(job, QueryJobConfiguration.fromPb((JobConfiguration)job.toPb()));
    }

    @Test
    public void testSetProjectId() {
        QueryJobConfiguration configuration = QUERY_JOB_CONFIGURATION.setProjectId(TEST_PROJECT_ID);
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDefaultDataset().getProject());
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDestinationTable().getProject());
    }

    @Test
    public void testSetProjectIdDoNotOverride() {
        QueryJobConfiguration configuration = QUERY_JOB_CONFIGURATION.toBuilder().setDestinationTable(TABLE_ID.setProjectId(TEST_PROJECT_ID)).build().setProjectId("update-only-on-dataset");
        Assert.assertEquals((Object)"update-only-on-dataset", (Object)configuration.getDefaultDataset().getProject());
        Assert.assertEquals((Object)TEST_PROJECT_ID, (Object)configuration.getDestinationTable().getProject());
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)JobConfiguration.Type.QUERY, (Object)QUERY_JOB_CONFIGURATION.getType());
    }

    @Test
    public void testPositionalParameter() {
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION_ADD_POSITIONAL_PARAMETER, QUERY_JOB_CONFIGURATION_ADD_POSITIONAL_PARAMETER.toBuilder().build());
    }

    @Test
    public void testNamedParameter() {
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION_SET_NAME_PARAMETER, QUERY_JOB_CONFIGURATION_SET_NAME_PARAMETER.toBuilder().build());
    }

    @Test
    public void testJobCreationMode() {
        this.compareQueryJobConfiguration(QUERY_JOB_CONFIGURATION_SET_JOB_CREATION_MODE, QUERY_JOB_CONFIGURATION_SET_JOB_CREATION_MODE.toBuilder().build());
    }

    private void compareQueryJobConfiguration(QueryJobConfiguration expected, QueryJobConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.dryRun(), (Object)value.dryRun());
        Assert.assertEquals((Object)expected.allowLargeResults(), (Object)value.allowLargeResults());
        Assert.assertEquals((Object)expected.getCreateDisposition(), (Object)value.getCreateDisposition());
        Assert.assertEquals((Object)expected.getDefaultDataset(), (Object)value.getDefaultDataset());
        Assert.assertEquals((Object)expected.getDestinationTable(), (Object)value.getDestinationTable());
        Assert.assertEquals((Object)expected.createSession(), (Object)value.createSession());
        Assert.assertEquals((Object)expected.flattenResults(), (Object)value.flattenResults());
        Assert.assertEquals((Object)expected.getPriority(), (Object)value.getPriority());
        Assert.assertEquals((Object)expected.getQuery(), (Object)value.getQuery());
        Assert.assertEquals((Object)expected.getTableDefinitions(), (Object)value.getTableDefinitions());
        Assert.assertEquals((Object)expected.useQueryCache(), (Object)value.useQueryCache());
        Assert.assertEquals((Object)expected.getUserDefinedFunctions(), (Object)value.getUserDefinedFunctions());
        Assert.assertEquals((Object)expected.getWriteDisposition(), (Object)value.getWriteDisposition());
        Assert.assertEquals((Object)expected.useLegacySql(), (Object)value.useLegacySql());
        Assert.assertEquals((Object)expected.getMaximumBillingTier(), (Object)value.getMaximumBillingTier());
        Assert.assertEquals((Object)expected.getMaximumBytesBilled(), (Object)value.getMaximumBytesBilled());
        Assert.assertEquals((Object)expected.getSchemaUpdateOptions(), (Object)value.getSchemaUpdateOptions());
        Assert.assertEquals((Object)expected.getDestinationEncryptionConfiguration(), (Object)value.getDestinationEncryptionConfiguration());
        Assert.assertEquals((Object)expected.getTimePartitioning(), (Object)value.getTimePartitioning());
        Assert.assertEquals((Object)expected.getClustering(), (Object)value.getClustering());
        Assert.assertEquals((Object)expected.getJobTimeoutMs(), (Object)value.getJobTimeoutMs());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getRangePartitioning(), (Object)value.getRangePartitioning());
        Assert.assertEquals((Object)expected.getConnectionProperties(), (Object)value.getConnectionProperties());
        Assert.assertEquals((Object)expected.getPositionalParameters(), (Object)value.getPositionalParameters());
        Assert.assertEquals((Object)expected.getNamedParameters(), (Object)value.getNamedParameters());
    }
}

