/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.cloud.Date;
import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Range;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.threeten.extra.PeriodDuration;

public class QueryParameterValueTest {
    private static final DateTimeFormatter TIMESTAMPFORMATTER = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 6, 9, true).optionalStart().appendOffset("+HHMM", "+00:00").optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final QueryParameterValue QUERY_PARAMETER_VALUE = QueryParameterValue.newBuilder().setType(StandardSQLTypeName.STRING).setValue("test-string").build();

    @Test
    public void testBuilder() {
        QueryParameterValue value = QUERY_PARAMETER_VALUE.toBuilder().build();
        Truth.assertThat((Object)value).isEqualTo((Object)QUERY_PARAMETER_VALUE);
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.STRING);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"test-string");
        Truth.assertThat((String)value.toString()).isEqualTo((Object)QUERY_PARAMETER_VALUE.toString());
        Truth.assertThat((Integer)value.hashCode()).isEqualTo((Object)QUERY_PARAMETER_VALUE.hashCode());
        Truth.assertThat((Boolean)value.equals(value)).isTrue();
        Truth.assertThat((Object)QUERY_PARAMETER_VALUE).isNotEqualTo((Object)StandardSQLTypeName.STRING);
    }

    @Test
    public void testTypeNullPointerException() {
        try {
            QUERY_PARAMETER_VALUE.toBuilder().setType(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Truth.assertThat((Throwable)ex).isNotNull();
        }
    }

    @Test
    public void testBool() {
        QueryParameterValue value = QueryParameterValue.bool((Boolean)true);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"true");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.BOOL);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testInt64() {
        QueryParameterValue value = QueryParameterValue.int64((Long)8L);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"8");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.INT64);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testInt64FromInteger() {
        QueryParameterValue value = QueryParameterValue.int64((Integer)7);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"7");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.INT64);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testFloat64() {
        QueryParameterValue value = QueryParameterValue.float64((Double)1.2);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"1.2");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.FLOAT64);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testFloat64FromFloat() {
        QueryParameterValue value = QueryParameterValue.float64((Float)Float.valueOf(1.2f));
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"1.2");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.FLOAT64);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testNumeric() {
        QueryParameterValue value = QueryParameterValue.numeric((BigDecimal)new BigDecimal("123.456"));
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"123.456");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.NUMERIC);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testBigNumeric() {
        QueryParameterValue value = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("0.33333333333333333333333333333333333333"));
        QueryParameterValue value1 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("0.50000000000000000000000000000000000000"));
        QueryParameterValue value2 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("0.00000000500000000000000000000000000000"));
        QueryParameterValue value3 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("-0.00000000500000000000000000000000000000"));
        QueryParameterValue value4 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("0.33333333333333333333333333333333333333888888888888888"));
        QueryParameterValue value5 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("1e-38"));
        QueryParameterValue value6 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("-1e38"));
        QueryParameterValue value7 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("578960446186580977117854925043439539266.34992332820282019728792003956564819967"));
        QueryParameterValue value8 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("-578960446186580977117854925043439539266.34992332820282019728792003956564819968"));
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"0.33333333333333333333333333333333333333");
        Truth.assertThat((String)value1.getValue()).isEqualTo((Object)"0.50000000000000000000000000000000000000");
        Truth.assertThat((String)value2.getValue()).isEqualTo((Object)"5.00000000000000000000000000000E-9");
        Truth.assertThat((String)value3.getValue()).isEqualTo((Object)"-5.00000000000000000000000000000E-9");
        Truth.assertThat((String)value4.getValue()).isEqualTo((Object)"0.33333333333333333333333333333333333333888888888888888");
        Truth.assertThat((String)value5.getValue()).isEqualTo((Object)"1E-38");
        Truth.assertThat((String)value6.getValue()).isEqualTo((Object)"-1E+38");
        Truth.assertThat((String)value7.getValue()).isEqualTo((Object)"578960446186580977117854925043439539266.34992332820282019728792003956564819967");
        Truth.assertThat((String)value8.getValue()).isEqualTo((Object)"-578960446186580977117854925043439539266.34992332820282019728792003956564819968");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.BIGNUMERIC);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testString() {
        QueryParameterValue value = QueryParameterValue.string((String)"foo");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"foo");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.STRING);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testGeography() {
        QueryParameterValue value = QueryParameterValue.geography((String)"POINT(-122.350220 47.649154)");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"POINT(-122.350220 47.649154)");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.GEOGRAPHY);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testJson() {
        QueryParameterValue value = QueryParameterValue.json((String)"{\"class\" : {\"students\" : [{\"name\" : \"Jane\"}]}}");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("class", "student");
        QueryParameterValue value1 = QueryParameterValue.json((JsonObject)jsonObject);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"{\"class\" : {\"students\" : [{\"name\" : \"Jane\"}]}}");
        Truth.assertThat((String)value1.getValue()).isEqualTo((Object)"{\"class\":\"student\"}");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.JSON);
        Truth.assertThat((Comparable)value1.getType()).isEqualTo((Object)StandardSQLTypeName.JSON);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Comparable)value1.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
        Truth.assertThat((Comparable)value1.getArrayType()).isNull();
    }

    @Test
    public void testInterval() {
        QueryParameterValue value = QueryParameterValue.interval((String)"123-7 -19 0:24:12.000006");
        QueryParameterValue value1 = QueryParameterValue.interval((String)"P123Y7M-19DT0H24M12.000006S");
        QueryParameterValue value2 = QueryParameterValue.interval((PeriodDuration)PeriodDuration.of((Period)Period.of(1, 2, 25), (Duration)Duration.ofHours(8L)));
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"123-7 -19 0:24:12.000006");
        Truth.assertThat((String)value1.getValue()).isEqualTo((Object)"P123Y7M-19DT0H24M12.000006S");
        Truth.assertThat((String)value2.getValue()).isEqualTo((Object)"P1Y2M25DT8H");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.INTERVAL);
        Truth.assertThat((Comparable)value1.getType()).isEqualTo((Object)StandardSQLTypeName.INTERVAL);
        Truth.assertThat((Comparable)value2.getType()).isEqualTo((Object)StandardSQLTypeName.INTERVAL);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Comparable)value1.getArrayType()).isNull();
        Truth.assertThat((Comparable)value2.getArrayType()).isNull();
    }

    @Test
    public void testBytes() {
        QueryParameterValue value = QueryParameterValue.bytes((byte[])new byte[]{1, 3});
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"AQM=");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.BYTES);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testBoolArray() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new Boolean[]{true, false}, Boolean.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.BOOL);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"true", "false"}, StandardSQLTypeName.BOOL, value.getArrayValues());
    }

    @Test
    public void testInt64Array() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new Long[]{2L, 5L}, Long.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.INT64);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2", "5"}, StandardSQLTypeName.INT64, value.getArrayValues());
    }

    @Test
    public void testInt64ArrayFromIntegers() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new Integer[]{2, 5}, Integer.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.INT64);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2", "5"}, StandardSQLTypeName.INT64, value.getArrayValues());
    }

    @Test
    public void testFloat64Array() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new Double[]{2.6, 5.4}, Double.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.FLOAT64);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2.6", "5.4"}, StandardSQLTypeName.FLOAT64, value.getArrayValues());
    }

    @Test
    public void testFloat64ArrayFromFloats() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new Float[]{Float.valueOf(2.6f), Float.valueOf(5.4f)}, Float.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.FLOAT64);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2.6", "5.4"}, StandardSQLTypeName.FLOAT64, value.getArrayValues());
    }

    @Test
    public void testNumericArray() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new BigDecimal[]{new BigDecimal("3.14"), new BigDecimal("1.59")}, BigDecimal.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.NUMERIC);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"3.14", "1.59"}, StandardSQLTypeName.NUMERIC, value.getArrayValues());
    }

    @Test
    public void testStringArray() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new String[]{"Ana", "Marv"}, String.class);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.STRING);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"Ana", "Marv"}, StandardSQLTypeName.STRING, value.getArrayValues());
    }

    @Test
    public void testTimestampFromLong() {
        QueryParameterValue value = QueryParameterValue.timestamp((Long)1408452095220000L);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"2014-08-19 12:41:35.220000+00:00");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testTimestampWithFormatter() {
        long timestampInMicroseconds = 1571068536842123L;
        long microseconds = 1000000L;
        long secs = Math.floorDiv(timestampInMicroseconds, microseconds);
        int nano = (int)Math.floorMod(timestampInMicroseconds, microseconds) * 1000;
        Instant instant = Instant.ofEpochSecond(secs, nano);
        String expected = TIMESTAMPFORMATTER.format(instant);
        Truth.assertThat((String)expected).isEqualTo((Object)QueryParameterValue.timestamp((Long)timestampInMicroseconds).getValue());
    }

    @Test
    public void testTimestamp() {
        QueryParameterValue value = QueryParameterValue.timestamp((String)"2014-08-19 12:41:35.220000+00:00");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"2014-08-19 12:41:35.220000+00:00");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testTimestampWithDateTimeFormatterBuilder() {
        QueryParameterValue value = QueryParameterValue.timestamp((String)"2019-02-14 12:34:45.938993Z");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"2019-02-14 12:34:45.938993Z");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
        QueryParameterValue value1 = QueryParameterValue.timestamp((String)"2019-02-14 12:34:45.938993+0000");
        Truth.assertThat((String)value1.getValue()).isEqualTo((Object)"2019-02-14 12:34:45.938993+0000");
        Truth.assertThat((Comparable)value1.getType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((Comparable)value1.getArrayType()).isNull();
        Truth.assertThat((Iterable)value1.getArrayValues()).isNull();
        QueryParameterValue value2 = QueryParameterValue.timestamp((String)"2019-02-14 12:34:45.102+00:00");
        Truth.assertThat((String)value2.getValue()).isEqualTo((Object)"2019-02-14 12:34:45.102+00:00");
        Truth.assertThat((Comparable)value2.getType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((Comparable)value2.getArrayType()).isNull();
        Truth.assertThat((Iterable)value2.getArrayValues()).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTimestamp() {
        QueryParameterValue.timestamp((String)"2014-08-19");
    }

    @Test
    public void testDate() {
        QueryParameterValue value = QueryParameterValue.date((String)"2014-08-19");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"2014-08-19");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.DATE);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test
    public void testStandardDate() throws ParseException {
        Date gcDate = Date.parseDate((String)"2016-09-18");
        java.util.Date date = Date.toJavaUtilDate((Date)gcDate);
        QueryParameterValue value = QueryParameterValue.of((Object)date, java.util.Date.class);
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"2016-09-18");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.DATE);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidDate() {
        QueryParameterValue.date((String)"2014-08-19 12:41:35.220000");
    }

    @Test
    public void testTime() {
        QueryParameterValue value = QueryParameterValue.time((String)"05:41:35.220000");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"05:41:35.220000");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.TIME);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTime() {
        QueryParameterValue.time((String)"2014-08-19 12:41:35.220000");
    }

    @Test
    public void testDateTime() {
        QueryParameterValue value = QueryParameterValue.dateTime((String)"2014-08-19 05:41:35.220000");
        Truth.assertThat((String)value.getValue()).isEqualTo((Object)"2014-08-19 05:41:35.220000");
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.DATETIME);
        Truth.assertThat((Comparable)value.getArrayType()).isNull();
        Truth.assertThat((Iterable)value.getArrayValues()).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidDateTime() {
        QueryParameterValue.dateTime((String)"2014-08-19");
    }

    @Test
    public void testTimestampArrayFromLongs() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new Long[]{1408452095220000L, 1481041545110000L}, (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2014-08-19 12:41:35.220000+00:00", "2016-12-06 16:25:45.110000+00:00"}, StandardSQLTypeName.TIMESTAMP, value.getArrayValues());
    }

    @Test
    public void testTimestampArray() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new String[]{"2014-08-19 12:41:35.220000+00:00", "2016-12-06 16:25:45.110000+00:00"}, (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2014-08-19 12:41:35.220000+00:00", "2016-12-06 16:25:45.110000+00:00"}, StandardSQLTypeName.TIMESTAMP, value.getArrayValues());
    }

    @Test
    public void testTimestampArrayWithDateTimeFormatterBuilder() {
        QueryParameterValue value = QueryParameterValue.array((Object[])new String[]{"2019-02-14 12:34:45.938993Z", "2019-02-14 12:34:45.938993+0000", "2019-02-14 12:34:45.102+00:00"}, (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.TIMESTAMP);
        QueryParameterValueTest.assertArrayDataEquals(new String[]{"2019-02-14 12:34:45.938993Z", "2019-02-14 12:34:45.938993+0000", "2019-02-14 12:34:45.102+00:00"}, StandardSQLTypeName.TIMESTAMP, value.getArrayValues());
    }

    @Test
    public void testFromEmptyArray() {
        QueryParameterType typePb = new QueryParameterType().setType("ARRAY").setArrayType(new QueryParameterType().setType("INT64"));
        QueryParameterValue value = QueryParameterValue.fromPb(null, (QueryParameterType)typePb);
        Truth.assertThat((String)value.getValue()).isNull();
        Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)value.getArrayType()).isEqualTo((Object)StandardSQLTypeName.INT64);
        Truth.assertThat((Iterable)value.getArrayValues()).isEmpty();
    }

    @Test
    public void testStruct() {
        QueryParameterValue booleanField = QueryParameterValue.bool((Boolean)true);
        QueryParameterValue integerField = QueryParameterValue.int64((Integer)15);
        QueryParameterValue stringField = QueryParameterValue.string((String)"test-string");
        QueryParameterValue recordField = QueryParameterValue.struct((Map)ImmutableMap.of((Object)"booleanField", (Object)booleanField, (Object)"integerField", (Object)integerField, (Object)"stringField", (Object)stringField));
        com.google.api.services.bigquery.model.QueryParameterValue parameterValue = recordField.toValuePb();
        QueryParameterType parameterType = recordField.toTypePb();
        QueryParameterValue queryParameterValue = QueryParameterValue.fromPb((com.google.api.services.bigquery.model.QueryParameterValue)parameterValue, (QueryParameterType)parameterType);
        Truth.assertThat((Object)queryParameterValue).isEqualTo((Object)recordField);
        Truth.assertThat((String)recordField.getValue()).isNull();
        Truth.assertThat((Comparable)recordField.getType()).isEqualTo((Object)StandardSQLTypeName.STRUCT);
        Truth.assertThat((Map)recordField.getStructTypes()).isNotNull();
        Truth.assertThat((Map)recordField.getStructValues()).isNotNull();
    }

    @Test
    public void testNestedStruct() {
        QueryParameterValue booleanField = QueryParameterValue.bool((Boolean)true);
        QueryParameterValue integerField = QueryParameterValue.int64((Integer)15);
        QueryParameterValue stringField = QueryParameterValue.string((String)"test-string");
        QueryParameterValue recordField = QueryParameterValue.struct((Map)ImmutableMap.of((Object)"booleanField", (Object)booleanField, (Object)"integerField", (Object)integerField, (Object)"stringField", (Object)stringField));
        HashMap<String, QueryParameterValue> structValue = new HashMap<String, QueryParameterValue>();
        structValue.put("bool", booleanField);
        structValue.put("int", integerField);
        structValue.put("string", stringField);
        structValue.put("struct", recordField);
        QueryParameterValue nestedRecordField = QueryParameterValue.struct(structValue);
        com.google.api.services.bigquery.model.QueryParameterValue parameterValue = nestedRecordField.toValuePb();
        QueryParameterType parameterType = nestedRecordField.toTypePb();
        QueryParameterValue queryParameterValue = QueryParameterValue.fromPb((com.google.api.services.bigquery.model.QueryParameterValue)parameterValue, (QueryParameterType)parameterType);
        Truth.assertThat((Object)queryParameterValue).isEqualTo((Object)nestedRecordField);
        Truth.assertThat((String)nestedRecordField.getValue()).isNull();
        Truth.assertThat((Comparable)nestedRecordField.getType()).isEqualTo((Object)StandardSQLTypeName.STRUCT);
        Truth.assertThat((Comparable)((QueryParameterValue)nestedRecordField.getStructTypes().get("struct")).getType()).isEqualTo((Object)StandardSQLTypeName.STRUCT);
        Truth.assertThat((Map)((QueryParameterValue)nestedRecordField.getStructValues().get("struct")).getStructValues()).containsAtLeastEntriesIn(recordField.getStructValues());
        Truth.assertThat((Integer)nestedRecordField.getStructTypes().size()).isEqualTo((Object)structValue.size());
        Truth.assertThat((Integer)nestedRecordField.getStructValues().size()).isEqualTo((Object)structValue.size());
    }

    @Test
    public void testStructArray() {
        Boolean[] boolValues = new Boolean[]{true, false};
        Integer[] intValues = new Integer[]{15, 20};
        String[] stringValues = new String[]{"test-string", "test-string2"};
        ArrayList<ImmutableMap> fieldMaps = new ArrayList<ImmutableMap>();
        ArrayList<QueryParameterValue> tuples = new ArrayList<QueryParameterValue>();
        for (int i = 0; i < 2; ++i) {
            QueryParameterValue booleanField = QueryParameterValue.bool((Boolean)boolValues[i]);
            QueryParameterValue integerField = QueryParameterValue.int64((Integer)intValues[i]);
            QueryParameterValue stringField = QueryParameterValue.string((String)stringValues[i]);
            ImmutableMap fieldMap = ImmutableMap.of((Object)"booleanField", (Object)booleanField, (Object)"integerField", (Object)integerField, (Object)"stringField", (Object)stringField);
            fieldMaps.add(fieldMap);
            QueryParameterValue recordField = QueryParameterValue.struct((Map)fieldMap);
            tuples.add(recordField);
        }
        QueryParameterValue repeatedRecordField = QueryParameterValue.array((Object[])tuples.toArray(), (StandardSQLTypeName)StandardSQLTypeName.STRUCT);
        com.google.api.services.bigquery.model.QueryParameterValue parameterValue = repeatedRecordField.toValuePb();
        QueryParameterType parameterType = repeatedRecordField.toTypePb();
        QueryParameterValue queryParameterValue = QueryParameterValue.fromPb((com.google.api.services.bigquery.model.QueryParameterValue)parameterValue, (QueryParameterType)parameterType);
        Truth.assertThat((String)queryParameterValue.getValue()).isNull();
        Truth.assertThat((Comparable)queryParameterValue.getType()).isEqualTo((Object)StandardSQLTypeName.ARRAY);
        Truth.assertThat((Comparable)queryParameterValue.getArrayType()).isEqualTo((Object)StandardSQLTypeName.STRUCT);
        Truth.assertThat((Integer)queryParameterValue.getArrayValues().size()).isEqualTo((Object)2);
        for (int i = 0; i < 2; ++i) {
            QueryParameterValue record = (QueryParameterValue)queryParameterValue.getArrayValues().get(i);
            Truth.assertThat((Comparable)record.getType()).isEqualTo((Object)StandardSQLTypeName.STRUCT);
            Truth.assertThat((Map)record.getStructTypes()).isNotNull();
            Truth.assertThat((Map)record.getStructValues()).isEqualTo(fieldMaps.get(i));
        }
    }

    private static void assertArrayDataEquals(String[] expectedValues, StandardSQLTypeName expectedType, List<QueryParameterValue> actualValues) {
        Truth.assertThat((Integer)actualValues.size()).isEqualTo((Object)expectedValues.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            QueryParameterValue value = actualValues.get(i);
            Truth.assertThat((Comparable)value.getType()).isEqualTo((Object)expectedType);
            Truth.assertThat((String)value.getValue()).isEqualTo((Object)expectedValues[i]);
            Truth.assertThat((Comparable)value.getArrayType()).isNull();
            Truth.assertThat((Iterable)value.getArrayValues()).isNull();
        }
    }

    @Test
    public void testRange() {
        QueryParameterValueTest.testRangeDataEquals(null, null, FieldElementType.newBuilder().setType("DATE").build());
        QueryParameterValueTest.testRangeDataEquals(null, "1971-02-03", FieldElementType.newBuilder().setType("DATE").build());
        QueryParameterValueTest.testRangeDataEquals("1970-01-02", null, FieldElementType.newBuilder().setType("DATE").build());
        QueryParameterValueTest.testRangeDataEquals("1970-01-02", "1971-02-03", FieldElementType.newBuilder().setType("DATE").build());
        QueryParameterValueTest.testRangeDataEquals(null, null, FieldElementType.newBuilder().setType("DATETIME").build());
        QueryParameterValueTest.testRangeDataEquals(null, "2015-09-20 06:41:35.220000", FieldElementType.newBuilder().setType("DATETIME").build());
        QueryParameterValueTest.testRangeDataEquals("2014-08-19 05:41:35.220000", null, FieldElementType.newBuilder().setType("DATETIME").build());
        QueryParameterValueTest.testRangeDataEquals("2014-08-19 05:41:35.220000", "2015-09-20 06:41:35.220000", FieldElementType.newBuilder().setType("DATETIME").build());
        QueryParameterValueTest.testRangeDataEquals(null, null, FieldElementType.newBuilder().setType("TIMESTAMP").build());
        QueryParameterValueTest.testRangeDataEquals(null, "2015-09-20 13:41:35.220000+01:00", FieldElementType.newBuilder().setType("TIMESTAMP").build());
        QueryParameterValueTest.testRangeDataEquals("2014-08-19 12:41:35.220000+00:00", null, FieldElementType.newBuilder().setType("TIMESTAMP").build());
        QueryParameterValueTest.testRangeDataEquals("2014-08-19 12:41:35.220000+00:00", "2015-09-20 13:41:35.220000+01:00", FieldElementType.newBuilder().setType("TIMESTAMP").build());
    }

    private static void testRangeDataEquals(String start, String end, FieldElementType type) {
        QueryParameterValue rangeField = QueryParameterValue.range((Range)Range.newBuilder().setType(type).setStart(start).setEnd(end).build());
        QueryParameterType parameterType = rangeField.toTypePb();
        com.google.api.services.bigquery.model.QueryParameterValue parameterValue = rangeField.toValuePb();
        QueryParameterValue queryParameterValue = QueryParameterValue.fromPb((com.google.api.services.bigquery.model.QueryParameterValue)parameterValue, (QueryParameterType)parameterType);
        Truth.assertThat((Comparable)queryParameterValue.getType()).isEqualTo((Object)StandardSQLTypeName.RANGE);
        if (start == null) {
            Truth.assertThat((Boolean)queryParameterValue.getRangeValues().getStart().isNull()).isTrue();
        } else {
            Truth.assertThat((String)queryParameterValue.getRangeValues().getStart().getStringValue()).isEqualTo((Object)start);
        }
        if (end == null) {
            Truth.assertThat((Boolean)queryParameterValue.getRangeValues().getEnd().isNull()).isTrue();
        } else {
            Truth.assertThat((String)queryParameterValue.getRangeValues().getEnd().getStringValue()).isEqualTo((Object)end);
        }
        Truth.assertThat((Object)queryParameterValue.getRangeValues().getType()).isEqualTo((Object)type);
        Truth.assertThat((Iterable)queryParameterValue.getArrayValues()).isNull();
        Truth.assertThat((Map)queryParameterValue.getStructValues()).isNull();
        Truth.assertThat((String)queryParameterValue.getValue()).isNull();
    }
}

