/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.QueryRequest;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.QueryRequestInfo;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class QueryRequestInfoTest {
    private static final String QUERY = "BigQuery SQL";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"dataset");
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final String KEY = "time_zone";
    private static final String VALUE = "US/Eastern";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("time_zone").setValue("US/Eastern").build();
    private static final List<ConnectionProperty> CONNECTION_PROPERTIES = ImmutableList.of((Object)CONNECTION_PROPERTY);
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().build();
    private static final ExternalTableDefinition TABLE_CONFIGURATION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setCompression("GZIP").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).build();
    private static final Map<String, ExternalTableDefinition> TABLE_DEFINITIONS = ImmutableMap.of((Object)"tableName", (Object)TABLE_CONFIGURATION);
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final QueryJobConfiguration.Priority PRIORITY = QueryJobConfiguration.Priority.BATCH;
    private static final boolean ALLOW_LARGE_RESULTS = true;
    private static final boolean CREATE_SESSION = true;
    private static final boolean USE_QUERY_CACHE = false;
    private static final boolean FLATTEN_RESULTS = true;
    private static final boolean USE_LEGACY_SQL = true;
    private static final Integer MAX_BILLING_TIER = 123;
    private static final Long MAX_BYTES_BILL = 12345L;
    private static final List<JobInfo.SchemaUpdateOption> SCHEMA_UPDATE_OPTIONS = ImmutableList.of((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final EncryptionConfiguration JOB_ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final Long TIMEOUT = 10L;
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"test-job-name", (Object)"test-query-job");
    private static final RangePartitioning.Range RANGE = RangePartitioning.Range.newBuilder().setStart(Long.valueOf(1L)).setInterval(Long.valueOf(2L)).setEnd(Long.valueOf(10L)).build();
    private static final RangePartitioning RANGE_PARTITIONING = RangePartitioning.newBuilder().setField("IntegerField").setRange(RANGE).build();
    private static final QueryParameterValue STRING_PARAMETER = QueryParameterValue.string((String)"stringValue");
    private static final QueryParameterValue TIMESTAMP_PARAMETER = QueryParameterValue.timestamp((String)"2014-01-01 07:00:00.000000+00:00");
    private static final List<QueryParameterValue> POSITIONAL_PARAMETER = ImmutableList.of((Object)STRING_PARAMETER, (Object)TIMESTAMP_PARAMETER);
    private static final Map<String, QueryParameterValue> NAME_PARAMETER = ImmutableMap.of((Object)"string", (Object)STRING_PARAMETER, (Object)"timestamp", (Object)TIMESTAMP_PARAMETER);
    private static final QueryJobConfiguration.JobCreationMode jobCreationModeRequired = QueryJobConfiguration.JobCreationMode.JOB_CREATION_REQUIRED;
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.newBuilder((String)"BigQuery SQL").setUseQueryCache(Boolean.valueOf(false)).setTableDefinitions(TABLE_DEFINITIONS).setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition(CREATE_DISPOSITION).setDefaultDataset(DATASET_ID).setDestinationTable(TABLE_ID).setWriteDisposition(WRITE_DISPOSITION).setPriority(PRIORITY).setFlattenResults(Boolean.valueOf(true)).setUserDefinedFunctions(USER_DEFINED_FUNCTIONS).setDryRun(Boolean.valueOf(true)).setUseLegacySql(Boolean.valueOf(true)).setMaximumBillingTier(MAX_BILLING_TIER).setMaximumBytesBilled(MAX_BYTES_BILL).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setDestinationEncryptionConfiguration(JOB_ENCRYPTION_CONFIGURATION).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setJobTimeoutMs(TIMEOUT).setLabels(LABELS).setRangePartitioning(RANGE_PARTITIONING).setConnectionProperties(CONNECTION_PROPERTIES).setPositionalParameters(POSITIONAL_PARAMETER).setMaxResults(Long.valueOf(100L)).setJobCreationMode(jobCreationModeRequired).build();
    QueryRequestInfo REQUEST_INFO = new QueryRequestInfo(QUERY_JOB_CONFIGURATION, Boolean.valueOf(false));
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION_SUPPORTED = QueryJobConfiguration.newBuilder((String)"BigQuery SQL").setUseQueryCache(Boolean.valueOf(false)).setDefaultDataset(DATASET_ID).setDryRun(Boolean.valueOf(true)).setUseLegacySql(Boolean.valueOf(true)).setMaximumBytesBilled(MAX_BYTES_BILL).setLabels(LABELS).setConnectionProperties(CONNECTION_PROPERTIES).setPositionalParameters(POSITIONAL_PARAMETER).setCreateSession(Boolean.valueOf(true)).setMaxResults(Long.valueOf(100L)).build();
    QueryRequestInfo REQUEST_INFO_SUPPORTED = new QueryRequestInfo(QUERY_JOB_CONFIGURATION_SUPPORTED, Boolean.valueOf(false));

    @Test
    public void testIsFastQuerySupported() {
        JobId jobIdSupported = JobId.newBuilder().build();
        JobId jobIdNotSupported = JobId.newBuilder().setJob("random-job-id").build();
        Assert.assertEquals((Object)false, (Object)this.REQUEST_INFO.isFastQuerySupported(jobIdSupported));
        Assert.assertEquals((Object)true, (Object)this.REQUEST_INFO_SUPPORTED.isFastQuerySupported(jobIdSupported));
        Assert.assertEquals((Object)false, (Object)this.REQUEST_INFO.isFastQuerySupported(jobIdNotSupported));
        Assert.assertEquals((Object)false, (Object)this.REQUEST_INFO_SUPPORTED.isFastQuerySupported(jobIdNotSupported));
    }

    @Test
    public void testToPb() {
        QueryRequest requestPb = this.REQUEST_INFO.toPb();
        Assert.assertEquals((Object)requestPb, (Object)this.REQUEST_INFO.toPb());
    }

    @Test
    public void equalTo() {
        this.compareQueryRequestInfo(new QueryRequestInfo(QUERY_JOB_CONFIGURATION_SUPPORTED, Boolean.valueOf(false)), this.REQUEST_INFO_SUPPORTED);
        this.compareQueryRequestInfo(new QueryRequestInfo(QUERY_JOB_CONFIGURATION, Boolean.valueOf(false)), this.REQUEST_INFO);
    }

    @Test
    public void testInt64Timestamp() {
        QueryRequestInfo requestInfo = new QueryRequestInfo(QUERY_JOB_CONFIGURATION, Boolean.valueOf(false));
        QueryRequest requestPb = requestInfo.toPb();
        Assert.assertFalse((boolean)requestPb.getFormatOptions().getUseInt64Timestamp());
        QueryRequestInfo requestInfoLosslessTs = new QueryRequestInfo(QUERY_JOB_CONFIGURATION, Boolean.valueOf(true));
        QueryRequest requestLosslessTsPb = requestInfoLosslessTs.toPb();
        Assert.assertTrue((boolean)requestLosslessTsPb.getFormatOptions().getUseInt64Timestamp());
    }

    private void compareQueryRequestInfo(QueryRequestInfo expected, QueryRequestInfo actual) {
        QueryRequest expectedQueryReq = expected.toPb();
        QueryRequest actualQueryReq = actual.toPb();
        Assert.assertNotEquals((Object)expectedQueryReq.getRequestId(), (Object)actualQueryReq.getRequestId());
        Assert.assertEquals((Object)expectedQueryReq.getConnectionProperties(), (Object)actualQueryReq.getConnectionProperties());
        Assert.assertEquals((Object)expectedQueryReq.getDefaultDataset(), (Object)actualQueryReq.getDefaultDataset());
        Assert.assertEquals((Object)expectedQueryReq.getDryRun(), (Object)actualQueryReq.getDryRun());
        Assert.assertEquals((Object)expectedQueryReq.getLabels(), (Object)actualQueryReq.getLabels());
        Assert.assertEquals((Object)expectedQueryReq.getMaximumBytesBilled(), (Object)actualQueryReq.getMaximumBytesBilled());
        Assert.assertEquals((Object)expectedQueryReq.getMaxResults(), (Object)actualQueryReq.getMaxResults());
        Assert.assertEquals((Object)expectedQueryReq.getQuery(), (Object)actualQueryReq.getQuery());
        Assert.assertEquals((Object)expectedQueryReq.getQueryParameters(), (Object)actualQueryReq.getQueryParameters());
        Assert.assertEquals((Object)expectedQueryReq.getCreateSession(), (Object)actualQueryReq.getCreateSession());
        Assert.assertEquals((Object)expectedQueryReq.getUseQueryCache(), (Object)actualQueryReq.getUseQueryCache());
        Assert.assertEquals((Object)expectedQueryReq.getUseLegacySql(), (Object)actualQueryReq.getUseLegacySql());
        Assert.assertEquals((Object)expectedQueryReq.get((Object)"jobCreationMode"), (Object)actualQueryReq.get((Object)"jobCreationMode"));
        Assert.assertEquals((Object)expectedQueryReq.getFormatOptions(), (Object)actualQueryReq.getFormatOptions());
    }
}

