/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ExplainQueryStage;
import com.google.api.services.bigquery.model.ExplainQueryStep;
import com.google.cloud.bigquery.QueryStage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class QueryStageTest {
    private static final List<String> SUBSTEPS1 = ImmutableList.of((Object)"substep1", (Object)"substep2");
    private static final List<String> SUBSTEPS2 = ImmutableList.of((Object)"substep3", (Object)"substep4");
    private static final QueryStage.QueryStep QUERY_STEP1 = new QueryStage.QueryStep("KIND", SUBSTEPS1);
    private static final QueryStage.QueryStep QUERY_STEP2 = new QueryStage.QueryStep("KIND", SUBSTEPS2);
    private static final long COMPLETED_PARALLEL_INPUTS = 3L;
    private static final long COMPUTE_MS_AVG = 1234L;
    private static final long COMPUTE_MS_MAX = 2345L;
    private static final double COMPUTE_RATIO_AVG = 1.1;
    private static final double COMPUTE_RATIO_MAX = 2.2;
    private static final long END_MS = 1522540860000L;
    private static final long ID = 42L;
    private static final List<Long> INPUT_STAGES = ImmutableList.of((Object)7L, (Object)9L);
    private static final String NAME = "StageName";
    private static final long PARALLEL_INPUTS = 4L;
    private static final long READ_MS_AVG = 3456L;
    private static final long READ_MS_MAX = 4567L;
    private static final double READ_RATIO_AVG = 3.3;
    private static final double READ_RATIO_MAX = 4.4;
    private static final long RECORDS_READ = 5L;
    private static final long RECORDS_WRITTEN = 6L;
    private static final long SHUFFLE_OUTPUT_BYTES = 4096L;
    private static final long SHUFFLE_OUTPUT_BYTES_SPILLED = 0L;
    private static final long START_MS = 1522540800000L;
    private static final String STATUS = "COMPLETE";
    private static final List<QueryStage.QueryStep> STEPS = ImmutableList.of((Object)QUERY_STEP1, (Object)QUERY_STEP2);
    private static final long WAIT_MS_AVG = 3333L;
    private static final long WAIT_MS_MAX = 3344L;
    private static final double WAIT_RATIO_AVG = 7.7;
    private static final double WAIT_RATIO_MAX = 8.8;
    private static final long WRITE_MS_AVG = 44L;
    private static final long WRITE_MS_MAX = 50L;
    private static final double WRITE_RATIO_AVG = 9.9;
    private static final double WRITE_RATIO_MAX = 10.1;
    private static final long SLOTMS = 1522540800000L;
    private static final QueryStage QUERY_STAGE = QueryStage.newBuilder().setCompletedParallelInputs(3L).setComputeMsAvg(1234L).setComputeMsMax(2345L).setComputeRatioAvg(1.1).setComputeRatioMax(2.2).setEndMs(1522540860000L).setGeneratedId(42L).setInputStages(INPUT_STAGES).setName("StageName").setParallelInputs(4L).setReadMsAvg(3456L).setReadMsMax(4567L).setReadRatioAvg(3.3).setReadRatioMax(4.4).setRecordsRead(5L).setRecordsWritten(6L).setShuffleOutputBytes(4096L).setShuffleOutputBytesSpilled(0L).setStartMs(1522540800000L).setStatus("COMPLETE").setSteps(STEPS).setWaitMsAvg(3333L).setWaitMsMax(3344L).setWaitRatioAvg(7.7).setWaitRatioMax(8.8).setWriteMsAvg(44L).setWriteMsMax(50L).setWriteRatioAvg(9.9).setWriteRatioMax(10.1).setSlotMs(1522540800000L).build();

    @Test
    public void testQueryStepConstructor() {
        Assert.assertEquals((Object)"KIND", (Object)QUERY_STEP1.getName());
        Assert.assertEquals((Object)"KIND", (Object)QUERY_STEP2.getName());
        Assert.assertEquals(SUBSTEPS1, (Object)QUERY_STEP1.getSubsteps());
        Assert.assertEquals(SUBSTEPS2, (Object)QUERY_STEP2.getSubsteps());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((long)3L, (long)QUERY_STAGE.getCompletedParallelInputs());
        Assert.assertEquals((long)1234L, (long)QUERY_STAGE.getComputeMsAvg());
        Assert.assertEquals((long)2345L, (long)QUERY_STAGE.getComputeMsMax());
        Assert.assertEquals((double)1.1, (double)QUERY_STAGE.getComputeRatioAvg(), (double)0.0);
        Assert.assertEquals((double)2.2, (double)QUERY_STAGE.getComputeRatioMax(), (double)0.0);
        Assert.assertEquals((long)1522540860000L, (long)QUERY_STAGE.getEndMs());
        Assert.assertEquals((long)42L, (long)QUERY_STAGE.getGeneratedId());
        Assert.assertEquals(INPUT_STAGES, (Object)QUERY_STAGE.getInputStages());
        Assert.assertEquals((long)4L, (long)QUERY_STAGE.getParallelInputs());
        Assert.assertEquals((Object)NAME, (Object)QUERY_STAGE.getName());
        Assert.assertEquals((long)3456L, (long)QUERY_STAGE.getReadMsAvg());
        Assert.assertEquals((long)4567L, (long)QUERY_STAGE.getReadMsMax());
        Assert.assertEquals((double)3.3, (double)QUERY_STAGE.getReadRatioAvg(), (double)0.0);
        Assert.assertEquals((double)4.4, (double)QUERY_STAGE.getReadRatioMax(), (double)0.0);
        Assert.assertEquals((long)5L, (long)QUERY_STAGE.getRecordsRead());
        Assert.assertEquals((long)6L, (long)QUERY_STAGE.getRecordsWritten());
        Assert.assertEquals((long)4096L, (long)QUERY_STAGE.getShuffleOutputBytes());
        Assert.assertEquals((long)0L, (long)QUERY_STAGE.getShuffleOutputBytesSpilled());
        Assert.assertEquals((long)1522540800000L, (long)QUERY_STAGE.getStartMs());
        Assert.assertEquals((Object)STATUS, (Object)QUERY_STAGE.getStatus());
        Assert.assertEquals(STEPS, (Object)QUERY_STAGE.getSteps());
        Assert.assertEquals((long)3333L, (long)QUERY_STAGE.getWaitMsAvg());
        Assert.assertEquals((long)3344L, (long)QUERY_STAGE.getWaitMsMax());
        Assert.assertEquals((double)7.7, (double)QUERY_STAGE.getWaitRatioAvg(), (double)0.0);
        Assert.assertEquals((double)8.8, (double)QUERY_STAGE.getWaitRatioMax(), (double)0.0);
        Assert.assertEquals((long)44L, (long)QUERY_STAGE.getWriteMsAvg());
        Assert.assertEquals((long)50L, (long)QUERY_STAGE.getWriteMsMax());
        Assert.assertEquals((double)9.9, (double)QUERY_STAGE.getWriteRatioAvg(), (double)0.0);
        Assert.assertEquals((double)10.1, (double)QUERY_STAGE.getWriteRatioMax(), (double)0.0);
        Assert.assertEquals((long)1522540800000L, (long)QUERY_STAGE.getSlotMs());
    }

    @Test
    public void testToAndFromPb() {
        this.compareQueryStep(QUERY_STEP1, QueryStage.QueryStep.fromPb((ExplainQueryStep)QUERY_STEP1.toPb()));
        this.compareQueryStep(QUERY_STEP2, QueryStage.QueryStep.fromPb((ExplainQueryStep)QUERY_STEP2.toPb()));
        this.compareQueryStage(QUERY_STAGE, QueryStage.fromPb((ExplainQueryStage)QUERY_STAGE.toPb()));
        ExplainQueryStep stepPb = new ExplainQueryStep();
        stepPb.setKind("KIND");
        stepPb.setSubsteps(null);
        this.compareQueryStep(new QueryStage.QueryStep("KIND", (List)ImmutableList.of()), QueryStage.QueryStep.fromPb((ExplainQueryStep)stepPb));
    }

    @Test
    public void testEquals() {
        this.compareQueryStep(QUERY_STEP1, QUERY_STEP1);
        this.compareQueryStep(QUERY_STEP2, QUERY_STEP2);
        this.compareQueryStage(QUERY_STAGE, QUERY_STAGE);
    }

    @Test
    public void testNotEquals() {
        Assert.assertNotEquals((Object)QUERY_STAGE, (Object)QUERY_STEP1);
        Assert.assertNotEquals((Object)QUERY_STEP1, (Object)QUERY_STAGE);
    }

    private void compareQueryStage(QueryStage expected, QueryStage value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.getCompletedParallelInputs(), (long)value.getCompletedParallelInputs());
        Assert.assertEquals((long)expected.getComputeMsAvg(), (long)value.getComputeMsAvg());
        Assert.assertEquals((long)expected.getComputeMsMax(), (long)value.getComputeMsMax());
        Assert.assertEquals((double)expected.getComputeRatioAvg(), (double)value.getComputeRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.getComputeRatioMax(), (double)value.getComputeRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.getEndMs(), (long)value.getEndMs());
        Assert.assertEquals((long)expected.getGeneratedId(), (long)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getInputStages(), (Object)value.getInputStages());
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((long)expected.getParallelInputs(), (long)value.getParallelInputs());
        Assert.assertEquals((double)expected.getReadRatioAvg(), (double)value.getReadRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.getReadRatioMax(), (double)value.getReadRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.getRecordsRead(), (long)value.getRecordsRead());
        Assert.assertEquals((long)expected.getRecordsWritten(), (long)value.getRecordsWritten());
        Assert.assertEquals((long)expected.getShuffleOutputBytes(), (long)value.getShuffleOutputBytes());
        Assert.assertEquals((long)expected.getShuffleOutputBytesSpilled(), (long)value.getShuffleOutputBytesSpilled());
        Assert.assertEquals((long)expected.getStartMs(), (long)value.getStartMs());
        Assert.assertEquals((Object)expected.getStatus(), (Object)value.getStatus());
        Assert.assertEquals((Object)expected.getSteps(), (Object)value.getSteps());
        Assert.assertEquals((long)expected.getWaitMsAvg(), (long)value.getWaitMsAvg());
        Assert.assertEquals((long)expected.getWaitMsMax(), (long)value.getWaitMsMax());
        Assert.assertEquals((double)expected.getWaitRatioAvg(), (double)value.getWaitRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.getWaitRatioMax(), (double)value.getWaitRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.getWriteMsAvg(), (long)expected.getWriteMsAvg());
        Assert.assertEquals((long)expected.getWriteMsMax(), (long)expected.getWriteMsMax());
        Assert.assertEquals((double)expected.getWriteRatioAvg(), (double)value.getWriteRatioAvg(), (double)0.0);
        Assert.assertEquals((double)expected.getWriteRatioMax(), (double)value.getWriteRatioMax(), (double)0.0);
        Assert.assertEquals((long)expected.getSlotMs(), (long)value.getSlotMs());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }

    private void compareQueryStep(QueryStage.QueryStep expected, QueryStage.QueryStep value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getSubsteps(), (Object)value.getSubsteps());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

