/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.Range;
import com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    private static final Range RANGE_DATE = Range.newBuilder().setType(FieldElementType.newBuilder().setType("DATE").build()).setStart("1970-01-02").setEnd("1970-03-04").build();
    private static final Range RANGE_DATETIME = Range.newBuilder().setType(FieldElementType.newBuilder().setType("DATETIME").build()).setStart("2014-08-19 05:41:35.220000").setEnd("2015-09-20 06:41:35.220000").build();
    private static final Range RANGE_TIMESTAMP = Range.newBuilder().setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).setStart("2014-08-19 12:41:35.220000+00:00").setEnd("2015-09-20 13:41:35.220000+01:00").build();

    @Test
    public void testOf() {
        RangeTest.compareRange(null, null, Range.of((String)"[null, NULL)"));
        RangeTest.compareRange(null, null, Range.of((String)"[unbounded, UNBOUNDED)"));
        RangeTest.compareRange(null, null, Range.of((String)"[nUlL, uNbOuNdEd)"));
        RangeTest.compareRange(null, "2020-12-31", Range.of((String)"[null, 2020-12-31)"));
        RangeTest.compareRange("2020-01-01", null, Range.of((String)"[2020-01-01, null)"));
        RangeTest.compareRange("2020-01-01", "2020-12-31", Range.of((String)"[2020-01-01, 2020-12-31)"));
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)"1970-01-02", (Object)RANGE_DATE.getStart().getStringValue());
        Assert.assertEquals((Object)"1970-03-04", (Object)RANGE_DATE.getEnd().getStringValue());
        Assert.assertEquals((Object)FieldElementType.newBuilder().setType("DATE").build(), (Object)RANGE_DATE.getType());
        Assert.assertEquals((Object)"2014-08-19 05:41:35.220000", (Object)RANGE_DATETIME.getStart().getStringValue());
        Assert.assertEquals((Object)"2015-09-20 06:41:35.220000", (Object)RANGE_DATETIME.getEnd().getStringValue());
        Assert.assertEquals((Object)FieldElementType.newBuilder().setType("DATETIME").build(), (Object)RANGE_DATETIME.getType());
        Assert.assertEquals((Object)"2014-08-19 12:41:35.220000+00:00", (Object)RANGE_TIMESTAMP.getStart().getStringValue());
        Assert.assertEquals((Object)"2015-09-20 13:41:35.220000+01:00", (Object)RANGE_TIMESTAMP.getEnd().getStringValue());
        Assert.assertEquals((Object)FieldElementType.newBuilder().setType("TIMESTAMP").build(), (Object)RANGE_TIMESTAMP.getType());
    }

    @Test
    public void testToBuilder() {
        RangeTest.compareRange(RANGE_DATE, RANGE_DATE.toBuilder().build());
        RangeTest.compareRange(RANGE_DATETIME, RANGE_DATETIME.toBuilder().build());
        RangeTest.compareRange(RANGE_TIMESTAMP, RANGE_TIMESTAMP.toBuilder().build());
    }

    @Test
    public void testGetValues() {
        RangeTest.compareRange(null, null, (ImmutableMap<String, String>)Range.of((String)"[null, NULL)").getValues());
        RangeTest.compareRange(null, null, (ImmutableMap<String, String>)Range.of((String)"[unbounded, UNBOUNDED)").getValues());
        RangeTest.compareRange(null, null, (ImmutableMap<String, String>)Range.of((String)"[nUlL, uNbOuNdEd)").getValues());
        RangeTest.compareRange(null, "2020-12-31", (ImmutableMap<String, String>)Range.of((String)"[null, 2020-12-31)").getValues());
        RangeTest.compareRange("2020-01-01", null, (ImmutableMap<String, String>)Range.of((String)"[2020-01-01, null)").getValues());
        RangeTest.compareRange("2020-01-01", "2020-12-31", (ImmutableMap<String, String>)Range.of((String)"[2020-01-01, 2020-12-31)").getValues());
    }

    private static void compareRange(Range expected, Range value) {
        Assert.assertEquals((Object)expected.getStart(), (Object)value.getStart());
        Assert.assertEquals((Object)expected.getEnd(), (Object)value.getEnd());
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }

    private static void compareRange(String expectedStart, String expectedEnd, Range range) {
        if (expectedStart == null) {
            Assert.assertTrue((boolean)range.getStart().isNull());
        } else {
            Assert.assertEquals((Object)expectedStart, (Object)range.getStart().getStringValue());
        }
        if (expectedEnd == null) {
            Assert.assertTrue((boolean)range.getEnd().isNull());
        } else {
            Assert.assertEquals((Object)expectedEnd, (Object)range.getEnd().getStringValue());
        }
    }

    private static void compareRange(String expectedStart, String expectedEnd, ImmutableMap<String, String> values) {
        Assert.assertEquals((Object)expectedStart, (Object)values.get((Object)"start"));
        Assert.assertEquals((Object)expectedEnd, (Object)values.get((Object)"end"));
    }
}

