/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.RemoteFunctionOptions;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class RemoteFunctionOptionsTest {
    private static final String endpoint = "https://aaabbbccc-uc.a.run.app";
    private static final String connection = "projects/{projectId}/locations/{locationId}/connections/{connectionId}";
    private static final Map<String, String> userDefinedContext = new HashMap<String, String>(){
        {
            this.put("key1", "value1");
            this.put("key2", "value2");
        }
    };
    private static final Long maxBatchingRows = 20L;
    private static final RemoteFunctionOptions REMOTE_FUNCTION_OPTIONS = RemoteFunctionOptions.newBuilder().setEndpoint("https://aaabbbccc-uc.a.run.app").setConnection("projects/{projectId}/locations/{locationId}/connections/{connectionId}").setUserDefinedContext(userDefinedContext).setMaxBatchingRows(maxBatchingRows).build();

    @Test
    public void testToBuilder() {
        this.compareRemoteFunctionOptions(REMOTE_FUNCTION_OPTIONS, REMOTE_FUNCTION_OPTIONS.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)endpoint, (Object)REMOTE_FUNCTION_OPTIONS.getEndpoint());
        Assert.assertEquals((Object)connection, (Object)REMOTE_FUNCTION_OPTIONS.getConnection());
        Assert.assertEquals(userDefinedContext, (Object)REMOTE_FUNCTION_OPTIONS.getUserDefinedContext());
        Assert.assertEquals((Object)maxBatchingRows, (Object)REMOTE_FUNCTION_OPTIONS.getMaxBatchingRows());
    }

    @Test
    public void testToAndFromPb() {
        this.compareRemoteFunctionOptions(REMOTE_FUNCTION_OPTIONS, RemoteFunctionOptions.fromPb((com.google.api.services.bigquery.model.RemoteFunctionOptions)REMOTE_FUNCTION_OPTIONS.toPb()));
    }

    public void compareRemoteFunctionOptions(RemoteFunctionOptions expected, RemoteFunctionOptions actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.getEndpoint(), (Object)actual.getEndpoint());
        Assert.assertEquals((Object)expected.getConnection(), (Object)actual.getConnection());
        Assert.assertEquals((Object)expected.getMaxBatchingRows(), (Object)actual.getMaxBatchingRows());
        Assert.assertEquals((Object)expected.getUserDefinedContext(), (Object)actual.getUserDefinedContext());
    }
}

