/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Argument;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.StandardSQLDataType;
import org.junit.Assert;
import org.junit.Test;

public class RoutineArgumentTest {
    private static final String NAME = "foo";
    private static final String KIND = "SCALAR_FUNCTION";
    private static final String MODE = "IN";
    private static final StandardSQLDataType DATA_TYPE = StandardSQLDataType.newBuilder((String)"STRING").build();
    private static final RoutineArgument ARGUMENT = RoutineArgument.newBuilder().setName("foo").setKind("SCALAR_FUNCTION").setMode("IN").setDataType(DATA_TYPE).build();

    @Test
    public void testToBuilder() {
        this.compareRoutineArguments(ARGUMENT, ARGUMENT.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)NAME, (Object)ARGUMENT.getName());
        Assert.assertEquals((Object)KIND, (Object)ARGUMENT.getKind());
        Assert.assertEquals((Object)MODE, (Object)ARGUMENT.getMode());
        Assert.assertEquals((Object)DATA_TYPE, (Object)ARGUMENT.getDataType());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareRoutineArguments(ARGUMENT, RoutineArgument.fromPb((Argument)ARGUMENT.toPb()));
    }

    public void compareRoutineArguments(RoutineArgument expected, RoutineArgument value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getKind(), (Object)value.getKind());
        Assert.assertEquals((Object)expected.getMode(), (Object)value.getMode());
        Assert.assertEquals((Object)expected.getDataType(), (Object)value.getDataType());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

