/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.RoutineReference;
import com.google.cloud.bigquery.RoutineId;
import org.junit.Assert;
import org.junit.Test;

public class RoutineIdTest {
    public static final RoutineId ROUTINE = RoutineId.of((String)"dataset", (String)"routine");
    public static final RoutineId ROUTINE_COMPLETE = RoutineId.of((String)"project", (String)"dataset", (String)"routine");

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)ROUTINE.getProject());
        Assert.assertEquals((Object)"dataset", (Object)ROUTINE.getDataset());
        Assert.assertEquals((Object)"routine", (Object)ROUTINE.getRoutine());
        Assert.assertEquals((Object)"project", (Object)ROUTINE_COMPLETE.getProject());
        Assert.assertEquals((Object)"dataset", (Object)ROUTINE_COMPLETE.getDataset());
        Assert.assertEquals((Object)"routine", (Object)ROUTINE_COMPLETE.getRoutine());
    }

    @Test
    public void testEquals() {
        this.compareRoutineIds(ROUTINE, RoutineId.of((String)"dataset", (String)"routine"));
        this.compareRoutineIds(ROUTINE_COMPLETE, RoutineId.of((String)"project", (String)"dataset", (String)"routine"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareRoutineIds(ROUTINE, RoutineId.fromPb((RoutineReference)ROUTINE.toPb()));
        this.compareRoutineIds(ROUTINE_COMPLETE, RoutineId.fromPb((RoutineReference)ROUTINE_COMPLETE.toPb()));
    }

    @Test
    public void testSetProjectId() {
        RoutineId differentProjectTable = RoutineId.of((String)"differentProject", (String)"dataset", (String)"routine");
        Assert.assertEquals((Object)differentProjectTable, (Object)ROUTINE.setProjectId("differentProject"));
    }

    private void compareRoutineIds(RoutineId expected, RoutineId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getProject(), (Object)value.getProject());
        Assert.assertEquals((Object)expected.getDataset(), (Object)value.getDataset());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

