/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Routine;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class RoutineInfoTest {
    private static final RoutineId ROUTINE_ID = RoutineId.of((String)"dataset", (String)"routine");
    private static final String ETAG = "etag";
    private static final String ROUTINE_TYPE = "SCALAR_FUNCTION";
    private static final Long CREATION_TIME = 10L;
    private static final String DESCRIPTION = "description";
    private static final String DETERMINISM = "DETERMINISTIC";
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final String LANGUAGE = "SQL";
    private static final String DATA_GOVERNANCE_TYPE = "DATA_MASKING";
    private static final RoutineArgument ARG_1 = RoutineArgument.newBuilder().setDataType(StandardSQLDataType.newBuilder((String)"STRING").build()).setName("arg1").build();
    private static final List<RoutineArgument> ARGUMENT_LIST = ImmutableList.of((Object)ARG_1);
    private static final StandardSQLDataType RETURN_TYPE = StandardSQLDataType.newBuilder((String)"FLOAT64").build();
    private static final List<String> IMPORTED_LIBRARIES = ImmutableList.of((Object)"gs://foo", (Object)"gs://bar", (Object)"gs://baz");
    private static final String BODY = "body";
    private static final RoutineInfo ROUTINE_INFO = RoutineInfo.of((RoutineId)ROUTINE_ID).toBuilder().setEtag("etag").setRoutineType("SCALAR_FUNCTION").setCreationTime(CREATION_TIME).setDescription("description").setDeterminismLevel("DETERMINISTIC").setLastModifiedTime(LAST_MODIFIED_TIME).setLanguage("SQL").setArguments(ARGUMENT_LIST).setReturnType(RETURN_TYPE).setImportedLibraries(IMPORTED_LIBRARIES).setBody("body").setDataGovernanceType("DATA_MASKING").build();

    @Test
    public void testToBuilder() {
        this.compareRoutineInfo(ROUTINE_INFO, ROUTINE_INFO.toBuilder().build());
    }

    @Test
    public void testBuilderIncomplete() {
        RoutineInfo routineInfo = RoutineInfo.of((RoutineId)ROUTINE_ID);
        Assert.assertEquals((Object)routineInfo, (Object)routineInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ROUTINE_ID, (Object)ROUTINE_INFO.getRoutineId());
        Assert.assertEquals((Object)ETAG, (Object)ROUTINE_INFO.getEtag());
        Assert.assertEquals((Object)ROUTINE_TYPE, (Object)ROUTINE_INFO.getRoutineType());
        Assert.assertEquals((Object)CREATION_TIME, (Object)ROUTINE_INFO.getCreationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)ROUTINE_INFO.getDescription());
        Assert.assertEquals((Object)DETERMINISM, (Object)ROUTINE_INFO.getDeterminismLevel());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)ROUTINE_INFO.getLastModifiedTime());
        Assert.assertEquals((Object)LANGUAGE, (Object)ROUTINE_INFO.getLanguage());
        Assert.assertEquals(ARGUMENT_LIST, (Object)ROUTINE_INFO.getArguments());
        Assert.assertEquals((Object)RETURN_TYPE, (Object)ROUTINE_INFO.getReturnType());
        Assert.assertEquals(IMPORTED_LIBRARIES, (Object)ROUTINE_INFO.getImportedLibraries());
        Assert.assertEquals((Object)BODY, (Object)ROUTINE_INFO.getBody());
        Assert.assertEquals((Object)DATA_GOVERNANCE_TYPE, (Object)ROUTINE_INFO.getDataGovernanceType());
    }

    @Test
    public void testOf() {
        RoutineInfo routineInfo = RoutineInfo.of((RoutineId)ROUTINE_ID);
        Assert.assertEquals((Object)ROUTINE_ID, (Object)ROUTINE_INFO.getRoutineId());
        Assert.assertNull((Object)routineInfo.getEtag());
        Assert.assertNull((Object)routineInfo.getRoutineType());
        Assert.assertNull((Object)routineInfo.getCreationTime());
        Assert.assertNull((Object)routineInfo.getDescription());
        Assert.assertNull((Object)routineInfo.getDeterminismLevel());
        Assert.assertNull((Object)routineInfo.getLastModifiedTime());
        Assert.assertNull((Object)routineInfo.getLanguage());
        Assert.assertNull((Object)routineInfo.getArguments());
        Assert.assertNull((Object)routineInfo.getReturnType());
        Assert.assertNull((Object)routineInfo.getImportedLibraries());
        Assert.assertNull((Object)routineInfo.getBody());
        Assert.assertNull((Object)routineInfo.getDataGovernanceType());
    }

    @Test
    public void testToAndFromPb() {
        this.compareRoutineInfo(ROUTINE_INFO, RoutineInfo.fromPb((Routine)ROUTINE_INFO.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)"project", (Object)ROUTINE_INFO.setProjectId("project").getRoutineId().getProject());
    }

    public void compareRoutineInfo(RoutineInfo expected, RoutineInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getRoutineId(), (Object)value.getRoutineId());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getRoutineType(), (Object)value.getRoutineType());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getDeterminismLevel(), (Object)value.getDeterminismLevel());
        Assert.assertEquals((Object)expected.getLastModifiedTime(), (Object)value.getLastModifiedTime());
        Assert.assertEquals((Object)expected.getLanguage(), (Object)value.getLanguage());
        Assert.assertEquals((Object)expected.getArguments(), (Object)value.getArguments());
        Assert.assertEquals((Object)expected.getReturnType(), (Object)value.getReturnType());
        Assert.assertEquals((Object)expected.getImportedLibraries(), (Object)value.getImportedLibraries());
        Assert.assertEquals((Object)expected.getBody(), (Object)value.getBody());
        Assert.assertEquals((Object)expected.getDataGovernanceType(), (Object)value.getDataGovernanceType());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

