/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.RemoteFunctionOptions;
import com.google.cloud.bigquery.Routine;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLField;
import com.google.cloud.bigquery.StandardSQLTableType;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.junit.MockitoRule;

@RunWith(value=MockitoJUnitRunner.class)
public class RoutineTest {
    private static final RoutineId ROUTINE_ID = RoutineId.of((String)"dataset", (String)"routine");
    private static final RoutineId ROUTINE_ID_TVF = RoutineId.of((String)"dataset", (String)"tvf_routine");
    private static final String DETERMINISM_LEVEL = "DETERMINISTIC";
    private static final String ETAG = "etag";
    private static final String ROUTINE_TYPE = "SCALAR_FUNCTION";
    private static final String ROUTINE_TYPE_TVF = "TABLE_VALUED_FUNCTION";
    private static final Long CREATION_TIME = 10L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final String LANGUAGE = "SQL";
    private static final RoutineArgument ARG_1 = RoutineArgument.newBuilder().setDataType(StandardSQLDataType.newBuilder((String)"STRING").build()).setName("arg1").build();
    private static final List<RoutineArgument> ARGUMENT_LIST = ImmutableList.of((Object)ARG_1);
    private static final StandardSQLDataType RETURN_TYPE = StandardSQLDataType.newBuilder((String)"FLOAT64").build();
    private static final StandardSQLField COLUMN_1 = StandardSQLField.newBuilder((String)"COLUMN_1", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"STRING").build()).build();
    private static final StandardSQLField COLUMN_2 = StandardSQLField.newBuilder((String)"COLUMN_2", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"FLOAT64").build()).build();
    private static final List<StandardSQLField> COLUMN_LIST = ImmutableList.of((Object)COLUMN_1, (Object)COLUMN_2);
    private static final StandardSQLTableType RETURN_TABLE_TYPE = StandardSQLTableType.newBuilder(COLUMN_LIST).build();
    private static final List<String> IMPORTED_LIBRARIES = ImmutableList.of((Object)"gs://foo", (Object)"gs://bar", (Object)"gs://baz");
    private static final String BODY = "body";
    private static final Map<String, String> userDefinedContext = new HashMap<String, String>(){
        {
            this.put("key1", "value1");
            this.put("key2", "value2");
        }
    };
    private static final RemoteFunctionOptions REMOTE_FUNCTION_OPTIONS = RemoteFunctionOptions.newBuilder().setEndpoint("endpoint").setConnection("connection").setUserDefinedContext(userDefinedContext).setMaxBatchingRows(Long.valueOf(10L)).build();
    private static final String DATA_GOVERNANCE_TYPE = "DATA_MASKING";
    private static final RoutineInfo ROUTINE_INFO = RoutineInfo.newBuilder((RoutineId)ROUTINE_ID).setEtag("etag").setRoutineType("SCALAR_FUNCTION").setCreationTime(CREATION_TIME).setDeterminismLevel("DETERMINISTIC").setLastModifiedTime(LAST_MODIFIED_TIME).setLanguage("SQL").setArguments(ARGUMENT_LIST).setReturnType(RETURN_TYPE).setImportedLibraries(IMPORTED_LIBRARIES).setBody("body").setRemoteFunctionOptions(REMOTE_FUNCTION_OPTIONS).setDataGovernanceType("DATA_MASKING").build();
    private static final RoutineInfo ROUTINE_INFO_TVF = RoutineInfo.newBuilder((RoutineId)ROUTINE_ID_TVF).setBody("body").setRoutineType("TABLE_VALUED_FUNCTION").setReturnTableType(RETURN_TABLE_TYPE).build();
    @Rule
    public MockitoRule rule;
    private BigQuery bigquery;
    private BigQueryOptions mockOptions;
    private Routine expectedRoutine;
    private Routine expectedRoutineTvf;
    private Routine routine;

    @Before
    public void setUp() {
        this.bigquery = (BigQuery)Mockito.mock(BigQuery.class);
        this.mockOptions = (BigQueryOptions)Mockito.mock(BigQueryOptions.class);
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        this.expectedRoutine = new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO));
        this.expectedRoutineTvf = new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO_TVF));
        this.routine = new Routine(this.bigquery, new RoutineInfo.BuilderImpl(ROUTINE_INFO));
    }

    @Test
    public void testBuilder() {
        Routine builtRoutine = new Routine.Builder(this.bigquery, ROUTINE_ID).setEtag(ETAG).setRoutineType(ROUTINE_TYPE).setCreationTime(CREATION_TIME).setDeterminismLevel(DETERMINISM_LEVEL).setLastModifiedTime(LAST_MODIFIED_TIME).setLanguage(LANGUAGE).setArguments(ARGUMENT_LIST).setReturnType(RETURN_TYPE).setImportedLibraries(IMPORTED_LIBRARIES).setBody(BODY).setRemoteFunctionOptions(REMOTE_FUNCTION_OPTIONS).setDataGovernanceType(DATA_GOVERNANCE_TYPE).build();
        Assert.assertEquals((Object)ETAG, (Object)builtRoutine.getEtag());
        Assert.assertEquals((Object)DETERMINISM_LEVEL, (Object)builtRoutine.getDeterminismLevel());
        Assert.assertSame((Object)this.bigquery, (Object)builtRoutine.getBigQuery());
    }

    @Test
    public void testToBuilder() {
        this.compareRoutineInfo((RoutineInfo)this.expectedRoutine, (RoutineInfo)this.expectedRoutine.toBuilder().build());
        this.compareRoutineInfo((RoutineInfo)this.expectedRoutineTvf, (RoutineInfo)this.expectedRoutineTvf.toBuilder().build());
    }

    @Test
    public void testExists_True() {
        BigQuery.RoutineOption[] expectedOptions = new BigQuery.RoutineOption[]{BigQuery.RoutineOption.fields((BigQuery.RoutineField[])new BigQuery.RoutineField[0])};
        Mockito.when((Object)this.bigquery.getRoutine(ROUTINE_INFO.getRoutineId(), expectedOptions)).thenReturn(null);
        Assert.assertFalse((boolean)this.routine.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getRoutine(ROUTINE_INFO.getRoutineId(), expectedOptions);
    }

    @Test
    public void testExists_False() {
        BigQuery.RoutineOption[] expectedOptions = new BigQuery.RoutineOption[]{BigQuery.RoutineOption.fields((BigQuery.RoutineField[])new BigQuery.RoutineField[0])};
        Mockito.when((Object)this.bigquery.getRoutine(ROUTINE_INFO.getRoutineId(), expectedOptions)).thenReturn((Object)this.expectedRoutine);
        Assert.assertTrue((boolean)this.routine.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getRoutine(ROUTINE_INFO.getRoutineId(), expectedOptions);
    }

    @Test
    public void testReload() {
        RoutineInfo updatedInfo = ROUTINE_INFO.toBuilder().setBody("body2").build();
        Routine expectedRoutine = new Routine(this.bigquery, new RoutineInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getRoutine(ROUTINE_INFO.getRoutineId(), new BigQuery.RoutineOption[0])).thenReturn((Object)expectedRoutine);
        Routine updatedRoutine = this.routine.reload(new BigQuery.RoutineOption[0]);
        this.compareRoutine(expectedRoutine, updatedRoutine);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getRoutine(ROUTINE_INFO.getRoutineId(), new BigQuery.RoutineOption[0]);
    }

    @Test
    public void testReload_Null() {
        Mockito.when((Object)this.bigquery.getRoutine(ROUTINE_INFO.getRoutineId(), new BigQuery.RoutineOption[0])).thenReturn(null);
        Assert.assertNull((Object)this.routine.reload(new BigQuery.RoutineOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getRoutine(ROUTINE_INFO.getRoutineId(), new BigQuery.RoutineOption[0]);
    }

    @Test
    public void testUpdate() {
        Routine expectedUpdatedRoutine = this.expectedRoutine.toBuilder().setBody("body2").build();
        Mockito.when((Object)this.bigquery.update((RoutineInfo)Mockito.eq((Object)this.expectedRoutine), new BigQuery.RoutineOption[0])).thenReturn((Object)expectedUpdatedRoutine);
        Routine actualUpdatedRoutine = this.routine.update(new BigQuery.RoutineOption[0]);
        this.compareRoutine(expectedUpdatedRoutine, actualUpdatedRoutine);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((RoutineInfo)Mockito.eq((Object)this.expectedRoutine), new BigQuery.RoutineOption[0]);
    }

    @Test
    public void testUpdateWithOptions() {
        Routine expectedUpdatedRoutine = this.expectedRoutine.toBuilder().setBody("body2").build();
        Mockito.when((Object)this.bigquery.update((RoutineInfo)Mockito.eq((Object)this.expectedRoutine), new BigQuery.RoutineOption[]{(BigQuery.RoutineOption)Mockito.eq((Object)BigQuery.RoutineOption.fields((BigQuery.RoutineField[])new BigQuery.RoutineField[0]))})).thenReturn((Object)expectedUpdatedRoutine);
        Routine actualUpdatedRoutine = this.routine.update(new BigQuery.RoutineOption[]{BigQuery.RoutineOption.fields((BigQuery.RoutineField[])new BigQuery.RoutineField[0])});
        this.compareRoutine(expectedUpdatedRoutine, actualUpdatedRoutine);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((RoutineInfo)Mockito.eq((Object)this.expectedRoutine), new BigQuery.RoutineOption[]{(BigQuery.RoutineOption)Mockito.eq((Object)BigQuery.RoutineOption.fields((BigQuery.RoutineField[])new BigQuery.RoutineField[0]))});
    }

    @Test
    public void testDeleteTrue() {
        Mockito.when((Object)this.bigquery.delete(ROUTINE_INFO.getRoutineId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.routine.delete());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(ROUTINE_INFO.getRoutineId());
    }

    @Test
    public void testDeleteFalse() {
        Mockito.when((Object)this.bigquery.delete(ROUTINE_INFO.getRoutineId())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.routine.delete());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(ROUTINE_INFO.getRoutineId());
    }

    private void compareRoutine(Routine expected, Routine value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareRoutineInfo((RoutineInfo)expected, (RoutineInfo)value);
        Assert.assertEquals((Object)expected.getBigQuery().getOptions(), (Object)value.getBigQuery().getOptions());
    }

    public void compareRoutineInfo(RoutineInfo expected, RoutineInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getRoutineId(), (Object)value.getRoutineId());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getRoutineType(), (Object)value.getRoutineType());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getDeterminismLevel(), (Object)value.getDeterminismLevel());
        Assert.assertEquals((Object)expected.getLastModifiedTime(), (Object)value.getLastModifiedTime());
        Assert.assertEquals((Object)expected.getLanguage(), (Object)value.getLanguage());
        Assert.assertEquals((Object)expected.getArguments(), (Object)value.getArguments());
        Assert.assertEquals((Object)expected.getReturnType(), (Object)value.getReturnType());
        Assert.assertEquals((Object)expected.getReturnTableType(), (Object)value.getReturnTableType());
        Assert.assertEquals((Object)expected.getImportedLibraries(), (Object)value.getImportedLibraries());
        Assert.assertEquals((Object)expected.getBody(), (Object)value.getBody());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.getRemoteFunctionOptions(), (Object)value.getRemoteFunctionOptions());
        Assert.assertEquals((Object)expected.getDataGovernanceType(), (Object)value.getDataGovernanceType());
    }
}

